/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.simplify;

import com.pamirs.tro.entity.domain.entity.simplify.TShadowJobConfig;
import com.pamirs.tro.entity.domain.query.ShadowJobConfigQuery;
import com.pamirs.tro.entity.domain.vo.ShadowJobConfigVo;
import io.shulie.tro.common.beans.annotation.ModuleDef;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.service.simplify.ShadowJobConfigService;
import io.shulie.tro.web.app.utils.Estimate;
import io.shulie.tro.web.app.utils.XmlUtil;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5f71\u5b50JOB\u914d\u7f6e"})
@RequestMapping(value={"/api/console"})
@RestController
public class ShadowJobConfigController {
    private static final Logger log = LoggerFactory.getLogger(ShadowJobConfigController.class);
    @Autowired
    private ShadowJobConfigService shadowJobConfigService;

    @ApiOperation(value="\u5f71\u5b50JOB\u914d\u7f6e\u5206\u9875\u67e5\u8be2, Owner: yuhan.tang")
    @GetMapping(value={"/shadow/job/query"}, produces={"application/json;charset=UTF-8"})
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.QUERY)
    public Response queryByPage(@RequestParam(value="pageSize", defaultValue="0") Integer pageSize, @RequestParam(value="pageNum", defaultValue="0") Integer pageNum, @RequestParam(value="orderBy", defaultValue="") String orderBy, @RequestParam(value="applicationId", defaultValue="") Long applicationId) {
        try {
            Estimate.notBlank((Object)applicationId, (String)"\u5e94\u7528ID\u4e0d\u80fd\u4e3a\u7a7a");
            ShadowJobConfigQuery query = new ShadowJobConfigQuery();
            query.setPageSize(pageSize.intValue());
            query.setPageNum(pageNum.intValue());
            query.setOrderBy(orderBy);
            query.setApplicationId(applicationId);
            return this.shadowJobConfigService.queryByPage(query);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    @ApiOperation(value="\u5f71\u5b50JOB\u914d\u7f6e\u67e5\u8be2\u8be6\u60c5, Owner: yuhan.tang")
    @GetMapping(value={"/shadow/job/query/detail"}, produces={"application/json;charset=UTF-8"})
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.QUERY)
    public Response queryDetail(@RequestParam(value="id") Long id) {
        try {
            Estimate.notBlank((Object)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            return this.shadowJobConfigService.queryDetail(id);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    @ApiOperation(value="\u5f71\u5b50JOB\u914d\u7f6e\u65b0\u589e, Owner: yuhan.tang")
    @PostMapping(value={"/shadow/job/insert"}, produces={"application/json;charset=UTF-8"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="job\u4efb\u52a1", logMsgKey="message.job_task.create")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.CREATE)
    public Response insert(@RequestBody TShadowJobConfig config) {
        try {
            Estimate.notBlank((Object)config.getApplicationId(), (String)"\u5e94\u7528ID\u4e0d\u80fd\u4e3a\u7a7a");
            Estimate.notBlank((Object)config.getConfigCode(), (String)"\u76f8\u5173\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
            if (StringUtils.isNotBlank((CharSequence)config.getRemark()) && config.getRemark().length() > 200) {
                throw new TroWebException((ExceptionReadable)ExceptionCode.JOB_PARAM_ERROR, (Object)"\u5907\u6ce8\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7200\u5b57\u7b26");
            }
            Map xmlMap = XmlUtil.readStringXml((String)config.getConfigCode());
            String className = (String)xmlMap.get("className");
            OperationLogContextHolder.operationType((String)"\u65b0\u589e");
            OperationLogContextHolder.addVars((String)"task", (String)className);
            return this.shadowJobConfigService.insert(config);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    @ApiOperation(value="\u5f71\u5b50JOB\u914d\u7f6e\u4fee\u6539, Owner: yuhan.tang")
    @RequestMapping(value={"/shadow/job/update"}, method={RequestMethod.PUT, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="job\u4efb\u52a1", logMsgKey="message.job_task.update")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.UPDATE)
    public Response update(@RequestBody ShadowJobConfigQuery query) {
        try {
            Estimate.notBlank((Object)query.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            if (StringUtils.isNotBlank((CharSequence)query.getRemark()) && query.getRemark().length() > 200) {
                throw new TroWebException((ExceptionReadable)ExceptionCode.JOB_PARAM_ERROR, (Object)"\u5907\u6ce8\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7200\u5b57\u7b26");
            }
            Map xmlMap = XmlUtil.readStringXml((String)query.getConfigCode());
            String className = (String)xmlMap.get("className");
            OperationLogContextHolder.operationType((String)"\u7f16\u8f91");
            OperationLogContextHolder.addVars((String)"task", (String)className);
            return this.shadowJobConfigService.update(query);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    @ApiOperation(value="\u5f71\u5b50JOB\u914d\u7f6e\u7981\u7528\u505c\u6b62, Owner: yuhan.tang")
    @PutMapping(value={"/shadow/job/updateStatus"}, produces={"application/json;charset=UTF-8"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="job\u4efb\u52a1", logMsgKey="message.job_task.enable_disable")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.ENABLE_DISABLE)
    public Response updateStatus(@RequestBody ShadowJobConfigQuery query) {
        try {
            Estimate.notBlank((Object)query.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            ShadowJobConfigVo shadowJobConfigVo = this.shadowJobConfigVo(query.getId());
            if (null == shadowJobConfigVo) {
                return Response.fail((String)"\u5f71\u5b50JOB\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            }
            OperationLogContextHolder.operationType((String)(query.getStatus() == 0 ? "\u542f\u7528" : "\u7981\u7528"));
            OperationLogContextHolder.addVars((String)"task", (String)shadowJobConfigVo.getName());
            return this.shadowJobConfigService.update(query);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    @ApiOperation(value="\u5f71\u5b50JOB\u914d\u7f6e\u5220\u9664, Owner: yuhan.tang")
    @DeleteMapping(value={"/shadow/job/delete"}, produces={"application/json;charset=UTF-8"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="job\u4efb\u52a1", logMsgKey="message.job_task.delete")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.DELETE)
    public Response delete(@RequestBody ShadowJobConfigQuery query) {
        ShadowJobConfigVo shadowJobConfigVo = this.shadowJobConfigVo(query.getId());
        if (null == shadowJobConfigVo) {
            return Response.fail((String)"\u5f71\u5b50JOB\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        OperationLogContextHolder.operationType((String)"\u5220\u9664");
        OperationLogContextHolder.addVars((String)"task", (String)shadowJobConfigVo.getName());
        try {
            Estimate.notBlank((Object)query.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            return this.shadowJobConfigService.delete(query.getId());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    private ShadowJobConfigVo shadowJobConfigVo(Long id) {
        Response jobConfigVo = this.shadowJobConfigService.queryDetail(id);
        if (null == jobConfigVo) {
            return null;
        }
        ShadowJobConfigVo data = (ShadowJobConfigVo)jobConfigVo.getData();
        return data;
    }
}

