/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.scriptmanage;

import com.google.common.collect.Lists;
import io.shulie.tro.common.beans.annotation.ModuleDef;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.request.filemanage.FileManageCreateRequest;
import io.shulie.tro.web.app.request.filemanage.FileManageUpdateRequest;
import io.shulie.tro.web.app.request.scriptmanage.ScriptManageDeployCreateRequest;
import io.shulie.tro.web.app.request.scriptmanage.ScriptManageDeployDeleteRequest;
import io.shulie.tro.web.app.request.scriptmanage.ScriptManageDeployPageQueryRequest;
import io.shulie.tro.web.app.request.scriptmanage.ScriptManageDeployRollBackRequest;
import io.shulie.tro.web.app.request.scriptmanage.ScriptManageDeployUpdateRequest;
import io.shulie.tro.web.app.request.scriptmanage.ScriptTagCreateRefRequest;
import io.shulie.tro.web.app.request.scriptmanage.SupportJmeterPluginNameRequest;
import io.shulie.tro.web.app.request.scriptmanage.SupportJmeterPluginVersionRequest;
import io.shulie.tro.web.app.response.scriptmanage.ScriptManageActivityResponse;
import io.shulie.tro.web.app.response.scriptmanage.ScriptManageDeployDetailResponse;
import io.shulie.tro.web.app.response.scriptmanage.ScriptManageDeployResponse;
import io.shulie.tro.web.app.response.scriptmanage.ScriptManageSceneManageResponse;
import io.shulie.tro.web.app.response.scriptmanage.ScriptManageStringResponse;
import io.shulie.tro.web.app.response.scriptmanage.ScriptManageXmlContentResponse;
import io.shulie.tro.web.app.response.scriptmanage.SupportJmeterPluginNameResponse;
import io.shulie.tro.web.app.response.scriptmanage.SupportJmeterPluginVersionResponse;
import io.shulie.tro.web.app.response.tagmanage.TagManageResponse;
import io.shulie.tro.web.app.service.scriptmanage.ScriptManageService;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/scriptManage"})
@Api(tags={"\u811a\u672c\u6587\u4ef6\u7ba1\u7406"})
public class ScriptManageController {
    @Autowired
    private ScriptManageService scriptManageService;

    @GetMapping(value={"/getZipFileUrl"})
    @ApiOperation(value="\u6253\u5305\u4e0b\u8f7d\u811a\u672c\u5b9e\u4f8b\u6240\u6709\u6587\u4ef6")
    @AuthVerification(moduleCode="scriptManage", needAuth=ActionTypeEnum.DOWNLOAD)
    public ScriptManageStringResponse getZipFileUrl(@RequestParam(value="scriptId") @Valid Long scriptDeployId) {
        String zipFileUrl = this.scriptManageService.getZipFileUrl(scriptDeployId);
        return new ScriptManageStringResponse(zipFileUrl);
    }

    @PutMapping
    @ApiOperation(value="\u4fee\u6539\u811a\u672c\u6587\u4ef6")
    @ModuleDef(moduleName="\u811a\u672c\u7ba1\u7406", subModuleName="\u811a\u672c\u7ba1\u7406", logMsgKey="message.script_manage.update")
    @AuthVerification(moduleCode="scriptManage", needAuth=ActionTypeEnum.UPDATE)
    public ScriptManageStringResponse updateScriptManage(@RequestBody @Valid ScriptManageDeployUpdateRequest scriptManageDeployUpdateRequest) {
        List fileManageUpdateRequests = scriptManageDeployUpdateRequest.getFileManageUpdateRequests();
        List attachmentsManageUpdateRequests = scriptManageDeployUpdateRequest.getAttachmentManageUpdateRequests();
        ArrayList attachmentsFilterManageUpdateRequests = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)attachmentsManageUpdateRequests)) {
            for (FileManageUpdateRequest fileRequest : attachmentsManageUpdateRequests) {
                if (!StringUtils.isNotBlank((CharSequence)fileRequest.getFileName()) || fileRequest.getFileName().endsWith(".jmx")) continue;
                attachmentsFilterManageUpdateRequests.add(fileRequest);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)attachmentsFilterManageUpdateRequests)) {
            fileManageUpdateRequests.addAll(attachmentsFilterManageUpdateRequests);
        }
        this.scriptManageService.updateScriptManage(scriptManageDeployUpdateRequest);
        OperationLogContextHolder.operationType((String)"\u7f16\u8f91");
        OperationLogContextHolder.addVars((String)"scriptManageDeployId", (String)String.valueOf(scriptManageDeployUpdateRequest.getId()));
        OperationLogContextHolder.addVars((String)"scriptManageDeployName", (String)scriptManageDeployUpdateRequest.getName());
        return new ScriptManageStringResponse("\u4fee\u6539\u811a\u672c\u6210\u529f");
    }

    @PostMapping
    @ApiOperation(value="\u521b\u5efa\u811a\u672c\u6587\u4ef6")
    @ModuleDef(moduleName="\u811a\u672c\u7ba1\u7406", subModuleName="\u811a\u672c\u7ba1\u7406", logMsgKey="message.script_manage.create")
    @AuthVerification(moduleCode="scriptManage", needAuth=ActionTypeEnum.CREATE)
    public ScriptManageStringResponse createScriptManage(@RequestBody @Valid ScriptManageDeployCreateRequest scriptManageDeployCreateRequest) {
        List fileManageCreateRequests = scriptManageDeployCreateRequest.getFileManageCreateRequests();
        List attachmentsManageCreateRequests = scriptManageDeployCreateRequest.getAttachmentManageCreateRequests();
        ArrayList attachmentsFilterManageCreateRequests = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)attachmentsManageCreateRequests)) {
            for (FileManageCreateRequest fileRequest : attachmentsManageCreateRequests) {
                if (!StringUtils.isNotBlank((CharSequence)fileRequest.getFileName()) || fileRequest.getFileName().endsWith(".jmx")) continue;
                attachmentsFilterManageCreateRequests.add(fileRequest);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)attachmentsFilterManageCreateRequests)) {
            fileManageCreateRequests.addAll(attachmentsFilterManageCreateRequests);
        }
        Long scriptManageId = this.scriptManageService.createScriptManage(scriptManageDeployCreateRequest);
        OperationLogContextHolder.operationType((String)"\u65b0\u589e");
        OperationLogContextHolder.addVars((String)"scriptManageDeployId", (String)String.valueOf(scriptManageId));
        OperationLogContextHolder.addVars((String)"scriptManageDeployName", (String)scriptManageDeployCreateRequest.getName());
        return new ScriptManageStringResponse("\u521b\u5efa\u811a\u672c\u6210\u529f");
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u811a\u672c\u6587\u4ef6")
    @ModuleDef(moduleName="\u811a\u672c\u7ba1\u7406", subModuleName="\u811a\u672c\u7ba1\u7406", logMsgKey="message.script_manage.delete")
    @AuthVerification(moduleCode="scriptManage", needAuth=ActionTypeEnum.DELETE)
    public ScriptManageStringResponse deleteScriptManage(@RequestBody ScriptManageDeployDeleteRequest scriptManageDeployDeleteRequest) {
        this.scriptManageService.deleteScriptManage(scriptManageDeployDeleteRequest.getScriptDeployId());
        OperationLogContextHolder.operationType((String)"\u5220\u9664");
        OperationLogContextHolder.addVars((String)"scriptManageDeployId", (String)String.valueOf(scriptManageDeployDeleteRequest.getScriptDeployId()));
        return new ScriptManageStringResponse("\u5220\u9664\u811a\u672c\u6210\u529f");
    }

    @GetMapping
    @ApiOperation(value="\u67e5\u8be2\u811a\u672c\u8be6\u60c5")
    @AuthVerification(moduleCode="scriptManage", needAuth=ActionTypeEnum.QUERY)
    public ScriptManageDeployDetailResponse getScriptManageDeployDetail(@RequestParam(value="scriptId") Long scriptDeployId) {
        return this.scriptManageService.getScriptManageDeployDetail(scriptDeployId);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u811a\u672c\u6587\u4ef6\u5217\u8868")
    @AuthVerification(moduleCode="scriptManage", needAuth=ActionTypeEnum.QUERY)
    public PagingList<ScriptManageDeployResponse> pageQueryScriptManage(@RequestBody @Valid ScriptManageDeployPageQueryRequest scriptManageDeployPageQueryRequest) {
        return this.scriptManageService.pageQueryScriptManage(scriptManageDeployPageQueryRequest);
    }

    @PostMapping(value={"/createScriptTagRef"})
    @ApiOperation(value="\u65b0\u589e\u811a\u672c\u6807\u7b7e\u5173\u8054\u5173\u7cfb")
    @AuthVerification(moduleCode="scriptManage", needAuth=ActionTypeEnum.UPDATE)
    public ScriptManageStringResponse createScriptTagRef(@RequestBody @Valid ScriptTagCreateRefRequest scriptTagCreateRefRequest) {
        this.scriptManageService.createScriptTagRef(scriptTagCreateRefRequest);
        return new ScriptManageStringResponse("\u5173\u8054\u5173\u7cfb\u6dfb\u52a0\u6210\u529f");
    }

    @GetMapping(value={"/listScriptTag"})
    @ApiOperation(value="\u67e5\u8be2\u811a\u672c\u6807\u7b7e\u5217\u8868")
    public List<TagManageResponse> queryScriptTagList() {
        return this.scriptManageService.queryScriptTagList();
    }

    @GetMapping(value={"/explainScriptFile"})
    @ApiOperation(value="\u89e3\u6790\u811a\u672c\u6587\u4ef6")
    public ScriptManageStringResponse explainScriptFile(@RequestParam String scriptFileUploadPath) {
        String xmlContent = this.scriptManageService.explainScriptFile(scriptFileUploadPath);
        return new ScriptManageStringResponse(xmlContent);
    }

    @GetMapping(value={"/getFileDownLoadUrl"})
    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u4e0b\u8f7d\u8def\u5f84")
    @AuthVerification(moduleCode="scriptManage", needAuth=ActionTypeEnum.DOWNLOAD)
    public ScriptManageStringResponse getFileDownLoadUrl(@RequestParam String filePath) {
        String fileDownLoadUrl = this.scriptManageService.getFileDownLoadUrl(filePath);
        return new ScriptManageStringResponse(fileDownLoadUrl);
    }

    @GetMapping(value={"/businessFlow/all"})
    @ApiOperation(value="\u4e1a\u52a1\u6d41\u7a0b\u5217\u8868\u67e5\u8be2")
    @AuthVerification(moduleCode="businessFlow", needAuth=ActionTypeEnum.QUERY)
    public List<ScriptManageSceneManageResponse> getAllScenes() {
        return this.scriptManageService.getAllScenes(null);
    }

    @GetMapping(value={"/businessActivity/all"})
    @ApiOperation(value="\u4e1a\u52a1\u6d3b\u52a8\u5217\u8868\u67e5\u8be2")
    @AuthVerification(moduleCode="businessActivity", needAuth=ActionTypeEnum.QUERY)
    public List<ScriptManageActivityResponse> getAllActivity() {
        return this.scriptManageService.listAllActivities(null);
    }

    @GetMapping(value={"/support/plugin/list"})
    @ApiOperation(value="\u83b7\u53d6\u652f\u6301\u7684\u63d2\u4ef6\u5217\u8868")
    public List<SupportJmeterPluginNameResponse> getSupportJmeterPluginNameList(@Valid SupportJmeterPluginNameRequest nameRequest) {
        return this.scriptManageService.getSupportJmeterPluginNameList(nameRequest);
    }

    @GetMapping(value={"/support/plugin/version"})
    @ApiOperation(value="\u83b7\u53d6\u652f\u6301\u7684\u63d2\u4ef6\u7248\u672c")
    public SupportJmeterPluginVersionResponse getSupportJemterPluginVersionList(@Valid SupportJmeterPluginVersionRequest versionRequest) {
        return this.scriptManageService.getSupportJmeterPluginVersionList(versionRequest);
    }

    @GetMapping(value={"/listScriptDeployByScriptId"})
    @ApiOperation(value="\u6839\u636e\u811a\u672cid\u67e5\u8be2\u811a\u672c\u5b9e\u4f8b\u5217\u8868")
    @AuthVerification(moduleCode="scriptManage", needAuth=ActionTypeEnum.QUERY)
    public List<ScriptManageDeployResponse> listScriptDeployByScriptId(@ApiParam(name="scriptId", value="\u811a\u672cid", required=true) @RequestParam(value="scriptId") Long scriptId) {
        return this.scriptManageService.listScriptDeployByScriptId(scriptId);
    }

    @PostMapping(value={"/rollbackScriptDeploy"})
    @ApiOperation(value="\u56de\u6eda\u5386\u53f2\u811a\u672c")
    @ModuleDef(moduleName="\u811a\u672c\u7ba1\u7406", subModuleName="\u811a\u672c\u7ba1\u7406", logMsgKey="message.script_manage.rollback")
    @AuthVerification(moduleCode="scriptManage", needAuth=ActionTypeEnum.QUERY)
    public ScriptManageStringResponse rollbackScriptDeploy(@RequestBody ScriptManageDeployRollBackRequest request) {
        String scriptManageName = this.scriptManageService.rollbackScriptDeploy(request.getScriptDeployId());
        OperationLogContextHolder.operationType((String)"\u56de\u6eda");
        OperationLogContextHolder.addVars((String)"scriptManageDeployId", (String)String.valueOf(request.getScriptDeployId()));
        OperationLogContextHolder.addVars((String)"scriptManageName", (String)scriptManageName);
        return new ScriptManageStringResponse("\u56de\u6eda\u811a\u672c\u6210\u529f");
    }

    @GetMapping(value={"/compareScriptDeploy"})
    @ApiOperation(value="\u811a\u672c\u5185\u5bb9\u5bf9\u6bd4")
    public List<ScriptManageXmlContentResponse> compareScriptDeploy(@RequestParam List<Long> scriptManageDeployIds) {
        return this.scriptManageService.getScriptManageDeployXmlContent(scriptManageDeployIds);
    }
}

