/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.scenemanage;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.pamirs.tro.common.constant.VerifyTypeEnum;
import com.pamirs.tro.common.exception.ApiException;
import com.pamirs.tro.entity.domain.dto.report.SceneActionDTO;
import com.pamirs.tro.entity.domain.dto.scenemanage.SceneManageWrapperDTO;
import com.pamirs.tro.entity.domain.vo.report.SceneActionParam;
import io.shulie.tro.cloud.common.bean.scenemanage.SceneBusinessActivityRefBean;
import io.shulie.tro.cloud.open.req.scenemanage.SceneManageIdReq;
import io.shulie.tro.cloud.open.resp.scenemanage.SceneManageWrapperResp;
import io.shulie.tro.cloud.open.resp.scenetask.SceneActionResp;
import io.shulie.tro.common.beans.annotation.ModuleDef;
import io.shulie.tro.common.beans.response.ResponseResult;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.request.datasource.DataSourceTestRequest;
import io.shulie.tro.web.app.request.leakcheck.LeakSqlBatchRefsRequest;
import io.shulie.tro.web.app.request.leakcheck.SqlTestRequest;
import io.shulie.tro.web.app.request.leakverify.LeakVerifyTaskStartRequest;
import io.shulie.tro.web.app.request.leakverify.LeakVerifyTaskStopRequest;
import io.shulie.tro.web.app.request.scriptmanage.UpdateTpsRequest;
import io.shulie.tro.web.app.service.DataSourceService;
import io.shulie.tro.web.app.service.LeakSqlService;
import io.shulie.tro.web.app.service.VerifyTaskService;
import io.shulie.tro.web.app.service.scenemanage.SceneManageService;
import io.shulie.tro.web.app.service.scenemanage.SceneTaskService;
import io.shulie.tro.web.common.domain.WebResponse;
import io.shulie.tro.web.diff.api.scenetask.SceneTaskApi;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/scene/task/"})
@Api(tags={"\u573a\u666f\u4efb\u52a1"}, value="\u573a\u666f\u4efb\u52a1")
public class SceneTaskController {
    @Autowired
    private SceneTaskService sceneTaskService;
    @Autowired
    private SceneManageService sceneManageService;
    @Autowired
    private VerifyTaskService verifyTaskService;
    @Autowired
    private SceneTaskApi sceneTaskApi;
    @Autowired
    private LeakSqlService leakSqlService;
    @Autowired
    private DataSourceService dataSourceService;

    @PostMapping(value={"/start"})
    @ApiOperation(value="\u5f00\u59cb\u573a\u666f\u6d4b\u8bd5")
    @ModuleDef(moduleName="\u538b\u6d4b\u7ba1\u7406", subModuleName="\u538b\u6d4b\u573a\u666f", logMsgKey="message.pressure_test_scene.start")
    public WebResponse start(@RequestBody SceneActionParam param) {
        try {
            ResponseResult webResponse = this.sceneManageService.detailScene(param.getSceneId());
            if (Objects.isNull(webResponse.getData())) {
                OperationLogContextHolder.ignoreLog();
                throw ApiException.create((int)500, (String)"\u8be5\u538b\u6d4b\u573a\u666f\u4e0d\u5b58\u5728");
            }
            OperationLogContextHolder.operationType((String)"\u542f\u52a8");
            SceneManageWrapperResp sceneData = (SceneManageWrapperResp)webResponse.getData();
            OperationLogContextHolder.addVars((String)"sceneId", (String)String.valueOf(sceneData.getId()));
            OperationLogContextHolder.addVars((String)"sceneName", (String)sceneData.getPressureTestSceneName());
            OperationLogContextHolder.operationType((String)"\u542f\u52a8");
            List errorMsgList = this.checkVerifyTaskConfig(param, sceneData);
            if (CollectionUtils.isNotEmpty((Collection)errorMsgList)) {
                throw ApiException.create((int)500, (String)StringUtils.join((Iterable)errorMsgList, (String)"|"));
            }
            WebResponse startTaskResponse = this.sceneTaskService.startTask(param);
            if (!startTaskResponse.getSuccess().booleanValue()) {
                OperationLogContextHolder.ignoreLog();
            }
            if (startTaskResponse.getSuccess().booleanValue() && param.getLeakSqlEnable() != null && param.getLeakSqlEnable().booleanValue()) {
                LeakVerifyTaskStartRequest startRequest = new LeakVerifyTaskStartRequest();
                startRequest.setRefType(VerifyTypeEnum.SCENE.getCode());
                startRequest.setRefId(param.getSceneId());
                SceneManageIdReq req = new SceneManageIdReq();
                req.setId(param.getSceneId());
                ResponseResult response = this.sceneTaskApi.checkTask(req);
                SceneActionResp resp = (SceneActionResp)response.getData();
                startRequest.setReportId(resp.getReportId());
                startRequest.setTimeInterval(sceneData.getScheduleInterval());
                List businessActivityIds = sceneData.getBusinessActivityConfig().stream().map(SceneBusinessActivityRefBean::getBusinessActivityId).collect(Collectors.toList());
                startRequest.setBusinessActivityIds(businessActivityIds);
                this.verifyTaskService.start(startRequest);
            }
            return startTaskResponse;
        }
        catch (ApiException ex) {
            SceneActionDTO sceneStart = new SceneActionDTO();
            sceneStart.setMsg(Arrays.asList(StringUtils.split((String)ex.getMessage(), (String)"|")));
            return WebResponse.success((Object)sceneStart);
        }
    }

    @PostMapping(value={"/stop"})
    @ApiOperation(value="\u7ed3\u675f\u573a\u666f\u6d4b\u8bd5")
    @ModuleDef(moduleName="\u538b\u6d4b\u7ba1\u7406", subModuleName="\u538b\u6d4b\u573a\u666f", logMsgKey="message.pressure_test_scene.stop")
    public ResponseResult stop(@RequestBody SceneActionParam param) {
        ResponseResult webResponse = this.sceneManageService.detailScene(param.getSceneId());
        if (Objects.isNull(webResponse.getData())) {
            OperationLogContextHolder.ignoreLog();
            return ResponseResult.fail((String)"\u8be5\u538b\u6d4b\u573a\u666f\u4e0d\u5b58\u5728", null);
        }
        OperationLogContextHolder.operationType((String)"\u505c\u6b62");
        SceneManageWrapperDTO sceneData = (SceneManageWrapperDTO)JSON.parseObject((String)JSON.toJSONString((Object)webResponse.getData()), SceneManageWrapperDTO.class);
        OperationLogContextHolder.addVars((String)"sceneId", (String)String.valueOf(sceneData.getId()));
        OperationLogContextHolder.addVars((String)"sceneName", (String)sceneData.getPressureTestSceneName());
        ResponseResult webResponse2 = this.sceneTaskService.stopTask(param);
        if (webResponse2 == null || !webResponse2.getSuccess().booleanValue()) {
            OperationLogContextHolder.ignoreLog();
        }
        LeakVerifyTaskStopRequest stopRequest = new LeakVerifyTaskStopRequest();
        stopRequest.setRefType(VerifyTypeEnum.SCENE.getCode());
        stopRequest.setRefId(param.getSceneId());
        this.verifyTaskService.stop(stopRequest);
        return webResponse2;
    }

    @GetMapping(value={"/checkStartStatus"})
    @ApiOperation(value="\u68c0\u67e5\u542f\u52a8\u72b6\u6001")
    public ResponseResult<SceneActionResp> checkStartStatus(Long sceneId) {
        return this.sceneTaskService.checkStatus(sceneId);
    }

    @PutMapping(value={"/tps"})
    @ApiOperation(value="\u4fee\u6539\u8fd0\u884c\u4e2d")
    public void updateTaskTps(@Validated @RequestBody UpdateTpsRequest request) {
        this.sceneTaskService.updateTaskTps(request);
    }

    @GetMapping(value={"/queryTaskTps"})
    @ApiOperation(value="\u67e5\u8be2\u8fd0\u884c\u4e2d\u4fee\u6539\u4e4b\u540e\u7684tps")
    public ResponseResult<Long> queryTaskTps(@RequestParam Long reportId, @RequestParam Long sceneId) {
        Long totalTps = this.sceneTaskService.queryTaskTps(reportId, sceneId);
        return ResponseResult.success((Object)totalTps);
    }

    private List<String> checkVerifyTaskConfig(SceneActionParam param, SceneManageWrapperResp sceneData) {
        if (param.getLeakSqlEnable() != null && param.getLeakSqlEnable().booleanValue()) {
            if (Objects.isNull(sceneData.getScheduleInterval())) {
                return Collections.singletonList("\u8bf7\u5148\u914d\u7f6e\u6f0f\u6570\u9a8c\u8bc1\u65f6\u95f4\u95f4\u9694");
            }
            LeakSqlBatchRefsRequest refsRequest = new LeakSqlBatchRefsRequest();
            List businessActivityIds = sceneData.getBusinessActivityConfig().stream().map(SceneBusinessActivityRefBean::getBusinessActivityId).collect(Collectors.toList());
            refsRequest.setBusinessActivityIds(businessActivityIds);
            List verifyTaskConfigList = this.leakSqlService.getVerifyTaskConfig(refsRequest);
            if (CollectionUtils.isEmpty((Collection)verifyTaskConfigList)) {
                return Collections.singletonList("\u5173\u8054\u7684\u4e1a\u52a1\u6d3b\u52a8\u6682\u672a\u914d\u7f6e\u6f0f\u6570\u811a\u672c");
            }
            ArrayList errorDbMsgList = Lists.newArrayList();
            verifyTaskConfigList.forEach(verifyTaskConfig -> {
                DataSourceTestRequest testRequest = new DataSourceTestRequest();
                testRequest.setJdbcUrl(verifyTaskConfig.getJdbcUrl());
                testRequest.setUsername(verifyTaskConfig.getUsername());
                testRequest.setPassword(verifyTaskConfig.getPassword());
                testRequest.setType(verifyTaskConfig.getType());
                String msg = this.dataSourceService.testConnection(testRequest);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    errorDbMsgList.add(msg);
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)errorDbMsgList)) {
                return errorDbMsgList.stream().sorted().collect(Collectors.toList());
            }
            ArrayList errorSqlMsgList = Lists.newArrayList();
            verifyTaskConfigList.forEach(verifyTaskConfig -> {
                SqlTestRequest testRequest = new SqlTestRequest();
                testRequest.setDatasourceId(verifyTaskConfig.getDatasourceId());
                testRequest.setSqls(verifyTaskConfig.getSqls());
                String msg = this.leakSqlService.testSqlConnection(testRequest);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    if (msg.contains(",")) {
                        errorSqlMsgList.addAll(Arrays.asList(msg.split(",")));
                    } else {
                        errorSqlMsgList.add(msg);
                    }
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)errorSqlMsgList)) {
                return errorSqlMsgList.stream().sorted().collect(Collectors.toList());
            }
        }
        return null;
    }
}

