/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.scenemanage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.pamirs.tro.entity.domain.dto.scenemanage.SceneManageWrapperDTO;
import com.pamirs.tro.entity.domain.vo.scenemanage.FlowVO;
import com.pamirs.tro.entity.domain.vo.scenemanage.SceneBusinessActivityRefVO;
import com.pamirs.tro.entity.domain.vo.scenemanage.SceneManageIdVO;
import com.pamirs.tro.entity.domain.vo.scenemanage.SceneManageQueryVO;
import com.pamirs.tro.entity.domain.vo.scenemanage.SceneManageWrapperVO;
import com.pamirs.tro.entity.domain.vo.scenemanage.SceneScriptRefVO;
import io.shulie.tro.cloud.open.resp.strategy.StrategyResp;
import io.shulie.tro.common.beans.annotation.ModuleDef;
import io.shulie.tro.common.beans.response.ResponseResult;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.request.scenemanage.SceneSchedulerDeleteRequest;
import io.shulie.tro.web.app.response.leakcheck.LeakSqlRefsResponse;
import io.shulie.tro.web.app.service.scenemanage.SceneManageService;
import io.shulie.tro.web.app.service.scenemanage.SceneSchedulerTaskService;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.shulie.tro.web.auth.api.exception.TroAuthException;
import io.shulie.tro.web.common.domain.WebResponse;
import io.shulie.tro.web.common.util.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/scenemanage"})
@Api(tags={"\u538b\u6d4b\u573a\u666f\u7ba1\u7406"})
public class SceneManageController {
    @Autowired
    private SceneManageService sceneManageService;
    @Autowired
    private SceneSchedulerTaskService sceneSchedulerTaskService;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e\u538b\u6d4b\u573a\u666f")
    @ModuleDef(moduleName="\u538b\u6d4b\u7ba1\u7406", subModuleName="\u538b\u6d4b\u573a\u666f", logMsgKey="message.pressure_test_scene.create")
    @AuthVerification(moduleCode="pressureTestManage_pressureTestScene", needAuth=ActionTypeEnum.CREATE)
    public WebResponse add(@RequestBody @Valid SceneManageWrapperVO sceneVO) throws TroAuthException {
        OperationLogContextHolder.operationType((String)"\u65b0\u589e");
        OperationLogContextHolder.addVars((String)"sceneName", (String)sceneVO.getPressureTestSceneName());
        WebResponse checkResponse = this.sceneManageService.checkParam(sceneVO);
        if (!checkResponse.getSuccess().booleanValue()) {
            return checkResponse;
        }
        WebResponse webResponse = this.sceneManageService.addScene(sceneVO, RestContext.getUser() != null ? RestContext.getUser().getId() : null);
        if (!webResponse.getSuccess().booleanValue()) {
            OperationLogContextHolder.ignoreLog();
        }
        return webResponse;
    }

    @PutMapping
    @ApiOperation(value="\u4fee\u6539\u538b\u6d4b\u573a\u666f")
    @ModuleDef(moduleName="\u538b\u6d4b\u7ba1\u7406", subModuleName="\u538b\u6d4b\u573a\u666f", logMsgKey="message.pressure_test_scene.update")
    @AuthVerification(moduleCode="pressureTestManage_pressureTestScene", needAuth=ActionTypeEnum.UPDATE)
    public WebResponse update(@RequestBody @Valid SceneManageWrapperVO sceneVO) {
        WebResponse checkResponse = this.sceneManageService.checkParam(sceneVO);
        if (!checkResponse.getSuccess().booleanValue()) {
            OperationLogContextHolder.ignoreLog();
            return checkResponse;
        }
        ResponseResult oldData = this.sceneManageService.detailScene(sceneVO.getId());
        if (Objects.isNull(oldData.getData())) {
            OperationLogContextHolder.ignoreLog();
            return new WebResponse((Object)"\u8be5\u538b\u6d4b\u573a\u666f\u4e0d\u5b58\u5728");
        }
        SceneManageWrapperDTO oldSceneData = (SceneManageWrapperDTO)JsonUtil.json2bean((String)JsonUtil.bean2Json((Object)oldData.getData()), SceneManageWrapperDTO.class);
        String sceneName = Optional.ofNullable(sceneVO.getPressureTestSceneName()).orElse(oldSceneData.getPressureTestSceneName());
        OperationLogContextHolder.operationType((String)"\u7f16\u8f91");
        OperationLogContextHolder.addVars((String)"sceneId", (String)String.valueOf(oldSceneData.getId()));
        OperationLogContextHolder.addVars((String)"sceneName", (String)sceneName);
        Long userId = RestContext.getUser() != null ? RestContext.getUser().getId() : null;
        WebResponse updateResponse = this.sceneManageService.updateScene(sceneVO, userId);
        if (!updateResponse.getSuccess().booleanValue()) {
            return updateResponse;
        }
        String selectiveContent = this.compareChangeContent(sceneVO, oldSceneData);
        OperationLogContextHolder.addVars((String)"selectiveContent", (String)selectiveContent);
        if (!updateResponse.getSuccess().booleanValue()) {
            OperationLogContextHolder.ignoreLog();
        }
        return updateResponse;
    }

    private String compareChangeContent(SceneManageWrapperVO sceneVO, SceneManageWrapperDTO sceneData) {
        String selectiveContent = "";
        List currentBusinessActivityConfigList = sceneVO.getBusinessActivityConfig();
        currentBusinessActivityConfigList = currentBusinessActivityConfigList.stream().map(sceneBusinessActivityRefVO -> {
            SceneBusinessActivityRefVO tmpSceneBusinessActivityRefVO = new SceneBusinessActivityRefVO();
            tmpSceneBusinessActivityRefVO.setBusinessActivityName(sceneBusinessActivityRefVO.getBusinessActivityName());
            return tmpSceneBusinessActivityRefVO;
        }).collect(Collectors.toList());
        List sceneBusinessActivityRefDTOList = sceneData.getBusinessActivityConfig();
        List oldBusinessActivityConfigList = sceneBusinessActivityRefDTOList.stream().map(sceneBusinessActivityRefDTO -> {
            SceneBusinessActivityRefVO sceneBusinessActivityRefVO = new SceneBusinessActivityRefVO();
            sceneBusinessActivityRefVO.setBusinessActivityName(sceneBusinessActivityRefDTO.getBusinessActivityName());
            return sceneBusinessActivityRefVO;
        }).collect(Collectors.toList());
        if (!JSONObject.toJSONString(currentBusinessActivityConfigList).equals(JSONObject.toJSONString(oldBusinessActivityConfigList))) {
            List sceneBusinessActivityRefVOList = sceneVO.getBusinessActivityConfig();
            String businessActivityNames = sceneBusinessActivityRefVOList.stream().map(SceneBusinessActivityRefVO::getBusinessActivityName).collect(Collectors.joining(","));
            selectiveContent = selectiveContent + "\uff5c\u4e1a\u52a1\u6d3b\u52a8\u540d\u79f0\uff1a" + businessActivityNames;
        }
        List currentSceneScriptRefVOList = sceneVO.getUploadFile();
        currentSceneScriptRefVOList = currentSceneScriptRefVOList.stream().filter(sceneScriptRefVO -> 0 == sceneScriptRefVO.getIsDeleted()).map(sceneScriptRefVO -> {
            SceneScriptRefVO tmpSceneScriptRefVo = new SceneScriptRefVO();
            tmpSceneScriptRefVo.setFileName(sceneScriptRefVO.getFileName());
            tmpSceneScriptRefVo.setUploadTime(sceneScriptRefVO.getUploadTime());
            return tmpSceneScriptRefVo;
        }).collect(Collectors.toList());
        currentSceneScriptRefVOList.sort((o1, o2) -> {
            String o1FileName = o1.getFileName();
            String o2FileName = o2.getFileName();
            return o1FileName.compareTo(o2FileName);
        });
        List sceneScriptRefDTOList = sceneData.getUploadFile();
        List oldSceneScriptRefVOList = sceneScriptRefDTOList.stream().map(sceneScriptRefDTO -> {
            SceneScriptRefVO sceneScriptRefVO = new SceneScriptRefVO();
            sceneScriptRefVO.setFileName(sceneScriptRefDTO.getFileName());
            sceneScriptRefVO.setUploadTime(sceneScriptRefDTO.getUploadTime());
            return sceneScriptRefVO;
        }).collect(Collectors.toList());
        oldSceneScriptRefVOList.sort((o1, o2) -> {
            String o1FileName = o1.getFileName();
            String o2FileName = o2.getFileName();
            return o1FileName.compareTo(o2FileName);
        });
        if (!JSONObject.toJSONString(currentSceneScriptRefVOList).equals(JSONObject.toJSONString(oldSceneScriptRefVOList)) && CollectionUtils.isNotEmpty(currentSceneScriptRefVOList)) {
            String fileNames = currentSceneScriptRefVOList.stream().map(SceneScriptRefVO::getFileName).collect(Collectors.joining(","));
            selectiveContent = selectiveContent + "\uff5c\u538b\u6d4b\u6587\u4ef6\uff1a" + fileNames;
        }
        return selectiveContent;
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u538b\u6d4b\u573a\u666f")
    @ModuleDef(moduleName="\u538b\u6d4b\u7ba1\u7406", subModuleName="\u538b\u6d4b\u573a\u666f", logMsgKey="message.pressure_test_scene.delete")
    @AuthVerification(moduleCode="pressureTestManage_pressureTestScene", needAuth=ActionTypeEnum.DELETE)
    public WebResponse delete(@RequestBody @Valid SceneManageIdVO deleteVO) {
        ResponseResult webResponse = this.sceneManageService.detailScene(deleteVO.getId());
        if (Objects.isNull(webResponse.getData())) {
            OperationLogContextHolder.ignoreLog();
            return new WebResponse((Object)"\u8be5\u538b\u6d4b\u573a\u666f\u4e0d\u5b58\u5728");
        }
        OperationLogContextHolder.operationType((String)"\u5220\u9664");
        SceneManageWrapperDTO sceneData = (SceneManageWrapperDTO)JSON.parseObject((String)JSON.toJSONString((Object)webResponse.getData()), SceneManageWrapperDTO.class);
        OperationLogContextHolder.addVars((String)"sceneId", (String)String.valueOf(sceneData.getId()));
        OperationLogContextHolder.addVars((String)"sceneName", (String)sceneData.getPressureTestSceneName());
        WebResponse webResponse2 = this.sceneManageService.deleteScene(deleteVO);
        if (!webResponse2.getSuccess().booleanValue()) {
            OperationLogContextHolder.ignoreLog();
        }
        return webResponse2;
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u538b\u6d4b\u573a\u666f\u8be6\u60c5")
    @AuthVerification(moduleCode="pressureTestManage_pressureTestScene", needAuth=ActionTypeEnum.QUERY)
    public ResponseResult getDetail(@ApiParam(name="id", value="ID", required=true) Long id) {
        return this.sceneManageService.detailScene(id);
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u538b\u6d4b\u573a\u666f\u5217\u8868")
    @AuthVerification(moduleCode="pressureTestManage_pressureTestScene", needAuth=ActionTypeEnum.QUERY)
    public WebResponse getList(@ApiParam(name="current", value="\u9875\u7801", required=true) Integer current, @ApiParam(name="pageSize", value="\u9875\u5927\u5c0f", required=true) Integer pageSize, @ApiParam(name="customName", value="\u5ba2\u6237\u540d\u79f0") String customName, @ApiParam(name="customId", value="\u5ba2\u6237ID") Long customId, @ApiParam(name="sceneId", value="\u538b\u6d4b\u573a\u666fID") Long sceneId, @ApiParam(name="sceneName", value="\u538b\u6d4b\u573a\u666f\u540d\u79f0") String sceneName, @ApiParam(name="status", value="\u538b\u6d4b\u72b6\u6001") Integer status, @ApiParam(name="tagId", value="\u6807\u7b7eid") Long tagId, @ApiParam(name="lastPtStartTime", value="\u538b\u6d4b\u7ed3\u675f\u65f6\u95f4") String lastPtStartTime, @ApiParam(name="lastPtEndTime", value="\u538b\u6d4b\u7ed3\u675f\u65f6\u95f4") String lastPtEndTime) {
        SceneManageQueryVO queryVO = new SceneManageQueryVO();
        queryVO.setCurrent(current.intValue());
        queryVO.setCurrentPage(current);
        queryVO.setPageSize(pageSize);
        queryVO.setCustomName(customName);
        queryVO.setCustomId(customId);
        queryVO.setSceneId(sceneId);
        queryVO.setSceneName(sceneName);
        queryVO.setStatus(status);
        queryVO.setTagId(tagId);
        queryVO.setLastPtStartTime(lastPtStartTime);
        queryVO.setLastPtEndTime(lastPtEndTime);
        return this.sceneManageService.getPageList(queryVO);
    }

    @PostMapping(value={"/flow/calc"})
    @ApiOperation(value="\u6d41\u91cf\u8ba1\u7b97")
    public Response calcFlow(@RequestBody FlowVO vo) {
        return Response.success((Object)this.sceneManageService.calcFlow(vo));
    }

    @GetMapping(value={"/ipnum"})
    @ApiOperation(value="\u83b7\u53d6\u673a\u5668\u6570\u91cf\u8303\u56f4")
    public ResponseResult<StrategyResp> getIpNum(@ApiParam(name="concurrenceNum", value="\u5e76\u53d1\u6570\u91cf") @RequestParam(value="concurrenceNum", required=false) Integer concurrenceNum, @ApiParam(name="tpsNum", value="\u5e76\u53d1\u6570\u91cf") @RequestParam(value="tpsNum", required=false) Integer tpsNum) {
        return this.sceneManageService.getIpNum(concurrenceNum, tpsNum);
    }

    @DeleteMapping(value={"/scheduler"})
    @ApiOperation(value="\u53d6\u6d88\u5b9a\u65f6\u542f\u52a8")
    public void cancelSceneSchedulerPressure(@RequestBody SceneSchedulerDeleteRequest request) {
        this.sceneSchedulerTaskService.deleteBySceneId(request.getSceneId());
    }

    @GetMapping(value={"/{sceneId}"})
    public List<LeakSqlRefsResponse> getRefResponse(@Valid @NotNull @PathVariable Long sceneId) {
        return null;
    }
}

