/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.report;

import com.github.pagehelper.PageInfo;
import com.pamirs.tro.entity.domain.dto.report.ReportTraceQueryDTO;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.service.report.ReportRealTimeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/"})
@Api(tags={"\u5b9e\u51b5\u62a5\u544a"})
public class ReportRealTimeController {
    @Autowired
    private ReportRealTimeService reportRealTimeService;

    @GetMapping(value={"/report/realtime/link/list"})
    @ApiOperation(value="\u5b9e\u51b5\u94fe\u8def\u5217\u8868")
    private Response getLinkList(ReportTraceQueryDTO queryDTO) {
        if (queryDTO.getReportId() != null) {
            PageInfo reportLinkListByReportId = this.reportRealTimeService.getReportLinkListByReportId(queryDTO.getReportId(), queryDTO.getType(), queryDTO.getCurrentPage() + 1, queryDTO.getPageSize());
            return Response.success((PageInfo)reportLinkListByReportId);
        }
        if (queryDTO.getStartTime() != null) {
            PageInfo reportLinkList = this.reportRealTimeService.getReportLinkList(queryDTO.getSceneId(), queryDTO.getStartTime(), queryDTO.getType(), queryDTO.getCurrentPage() + 1, queryDTO.getPageSize());
            return Response.success((PageInfo)reportLinkList);
        }
        return Response.success((PageInfo)new PageInfo());
    }

    @GetMapping(value={"/report/link/detail"})
    @ApiOperation(value="\u94fe\u8def\u8be6\u60c5")
    private Response getLinkDetail(@RequestParam(value="traceId") String traceId, @RequestParam(value="id", defaultValue="0") Integer id) {
        Map rootMap = this.reportRealTimeService.getLinkDetail(traceId, id);
        return Response.success((Object)rootMap);
    }
}

