/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.report;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.pamirs.tro.entity.domain.dto.report.ApplicationDTO;
import com.pamirs.tro.entity.domain.dto.report.BottleneckInterfaceDTO;
import com.pamirs.tro.entity.domain.dto.report.MachineDetailDTO;
import com.pamirs.tro.entity.domain.dto.report.ReportCountDTO;
import com.pamirs.tro.entity.domain.dto.report.ReportDetailDTO;
import com.pamirs.tro.entity.domain.dto.report.ReportPradarLinkDTO;
import com.pamirs.tro.entity.domain.dto.report.RiskApplicationCountDTO;
import com.pamirs.tro.entity.domain.dto.report.RiskMacheineDTO;
import com.pamirs.tro.entity.domain.risk.ReportLinkDetail;
import com.pamirs.tro.entity.domain.vo.report.ReportLocalQueryParam;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.service.report.ReportLocalService;
import io.shulie.tro.web.app.service.report.ReportService;
import io.shulie.tro.web.app.service.risk.ProblemAnalysisService;
import io.shulie.tro.web.app.service.risk.util.DateUtil;
import io.shulie.tro.web.common.domain.WebResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mockito.internal.util.collections.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/"})
@Api(tags={"\u573a\u666f\u62a5\u544a\u6a21\u5757"}, value="\u573a\u666f\u62a5\u544a")
public class ReportLocalController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private ReportLocalService reportLocalService;
    @Autowired
    private ProblemAnalysisService problemAnalysisService;

    @GetMapping(value={"/report/count"})
    @ApiOperation(value="\u62a5\u544a\u6c47\u603b\u6570\u636e")
    public Response<ReportCountDTO> getReportCount(Long reportId) {
        return Response.success((Object)this.reportLocalService.getReportCount(reportId));
    }

    @GetMapping(value={"/report/bottleneckInterface/list"})
    @ApiOperation(value="\u74f6\u9888\u63a5\u53e3")
    public Response<List<BottleneckInterfaceDTO>> getBottleneckInterfaceList(Long reportId, Integer current, Integer pageSize) {
        ReportLocalQueryParam queryParam = new ReportLocalQueryParam();
        queryParam.setReportId(reportId);
        this.initPageParam(queryParam, current.intValue(), pageSize.intValue());
        return Response.success((PageInfo)this.reportLocalService.listBottleneckInterface(queryParam));
    }

    @GetMapping(value={"/report/risk/application"})
    @ApiOperation(value="\u98ce\u9669\u673a\u5668\u5de6\u4fa7\u5e94\u7528")
    public Response<RiskApplicationCountDTO> getRiskApplicationCount(Long reportId) {
        return Response.success((Object)this.reportLocalService.listRiskApplication(reportId));
    }

    @GetMapping(value={"/report/risk/machine/list"})
    @ApiOperation(value="\u98ce\u9669\u673a\u5668\u53f3\u4fa7\u5217\u8868")
    public Response<List<RiskMacheineDTO>> getRiskMacheine(Long reportId, String applicationName, Integer current, Integer pageSize) {
        ReportLocalQueryParam queryParam = new ReportLocalQueryParam();
        queryParam.setReportId(reportId);
        queryParam.setApplicationName(applicationName);
        this.initPageParam(queryParam, current.intValue(), pageSize.intValue());
        return Response.success((PageInfo)this.reportLocalService.listRiskMachine(queryParam));
    }

    @GetMapping(value={"/report/businessActivity/summary/list"})
    @ApiOperation(value="\u538b\u6d4b\u660e\u7ec6")
    public WebResponse getBusinessActivitySummaryList(Long reportId) {
        return this.reportService.querySummaryList(reportId);
    }

    @GetMapping(value={"/report/machine/detail"})
    @ApiOperation(value="\u6027\u80fd\u8be6\u60c5")
    public Response<MachineDetailDTO> getMachineDetail(Long reportId, String applicationName, String machineIp) {
        return Response.success((Object)this.reportLocalService.getMachineDetail(reportId, applicationName, machineIp));
    }

    @GetMapping(value={"/report/application/list"})
    @ApiOperation(value="\u5bb9\u91cf\u6c34\u4f4d\u5e94\u7528\u5217\u8868")
    public Response<List<ApplicationDTO>> getApplicationList(Long reportId, String applicationName) {
        if (StringUtils.isBlank((CharSequence)applicationName)) {
            applicationName = null;
        }
        return Response.success((Object)this.reportLocalService.listApplication(reportId, applicationName));
    }

    @GetMapping(value={"/report/application/trace/failedCount"})
    @ApiOperation(value="\u8bf7\u6c42\u6d41\u91cf\u660e\u7ec6\u5931\u8d25\u6b21\u6570")
    public Response<Long> getTraceFailedCount(Long reportId) {
        if (reportId == null) {
            return Response.fail((String)"\u62a5\u544aid\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        return Response.success((Object)this.reportLocalService.getTraceFailedCount(reportId));
    }

    @GetMapping(value={"/report/machine/list"})
    @ApiOperation(value="\u5bb9\u91cf\u6c34\u4f4d\u5e94\u7528\u673a\u5668\u5217\u8868")
    public Response<List<MachineDetailDTO>> getMachineList(Long reportId, String applicationName, Integer current, Integer pageSize) {
        ReportLocalQueryParam queryParam = new ReportLocalQueryParam();
        this.initPageParam(queryParam, current.intValue(), pageSize.intValue());
        queryParam.setReportId(reportId);
        queryParam.setApplicationName(applicationName);
        return Response.success((PageInfo)this.reportLocalService.listMachineDetail(queryParam));
    }

    @GetMapping(value={"/report/link/list"})
    @ApiOperation(value="\u94fe\u8def\u660e\u7ec6")
    public Response getReportLinkDTOList(Long reportId, Long businessActivityId) {
        ReportLinkDetail detail;
        long startTime;
        ReportPradarLinkDTO pradarLink = new ReportPradarLinkDTO();
        ArrayList lists = Lists.newArrayList();
        if (reportId != null && reportId == -1L) {
            return Response.success((Object)Lists.newArrayList());
        }
        WebResponse response = this.reportService.getReportByReportId(reportId);
        if (response == null || response.getData() == null) {
            return Response.fail((String)"500", (String)("Not Found Report, id=" + reportId), (Object[])new Object[0]);
        }
        ReportDetailDTO reportDetail = (ReportDetailDTO)JSON.parseObject((String)JSON.toJSONString((Object)response.getData()), ReportDetailDTO.class);
        long endTime = startTime = System.currentTimeMillis();
        if (reportDetail.getStartTime() != null) {
            startTime = DateUtil.parseSecondFormatter((String)reportDetail.getStartTime()).getTime();
        }
        if (reportDetail.getEndTime() != null) {
            endTime = reportDetail.getEndTime().getTime();
        }
        if ((detail = this.problemAnalysisService.queryLinkDetail(businessActivityId, Long.valueOf(startTime), Long.valueOf(endTime))) != null) {
            lists.add(detail);
        }
        this.calcOffset((List)lists, null);
        ReportLocalQueryParam queryParam = new ReportLocalQueryParam();
        queryParam.setReportId(reportId);
        queryParam.setCurrentPage(Integer.valueOf(0));
        queryParam.setPageSize(Integer.valueOf(200));
        Set bottleneckSet = Sets.newSet((Object[])new String[0]);
        PageInfo pageInfo = this.reportLocalService.listBottleneckInterface(queryParam);
        if (pageInfo != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            bottleneckSet.addAll(pageInfo.getList().stream().map(BottleneckInterfaceDTO::getInterfaceName).collect(Collectors.toSet()));
        }
        this.fillBottleneckFlag((List)lists, bottleneckSet);
        pradarLink.setDetails((List)lists);
        if (CollectionUtils.isNotEmpty((Collection)lists)) {
            BigDecimal totalRt = lists.stream().map(data -> BigDecimal.valueOf(data.getAvgRt())).reduce(BigDecimal.ZERO, BigDecimal::add);
            pradarLink.setTotalRT(Integer.valueOf(totalRt.intValue()));
        }
        return Response.success((Object)pradarLink);
    }

    private void initPageParam(ReportLocalQueryParam queryParam, int current, int pageSize) {
        if (current < 0) {
            current = 0;
        }
        if (pageSize < 0) {
            pageSize = 20;
        }
        queryParam.setCurrent(current);
        queryParam.setPageSize(Integer.valueOf(pageSize));
    }

    private void calcOffset(List<ReportLinkDetail> lists, Integer parentOffset) {
        if (CollectionUtils.isEmpty(lists)) {
            return;
        }
        if (parentOffset == null) {
            parentOffset = 0;
        }
        for (int i = 0; i < lists.size(); ++i) {
            ReportLinkDetail temp = lists.get(i);
            if (i == 0) {
                temp.setOffset(parentOffset);
            } else {
                ReportLinkDetail preTemp = lists.get(i - 1);
                temp.setOffset(Integer.valueOf(preTemp.getOffset() + preTemp.getAvgRt().intValue()));
            }
            this.calcOffset(temp.getChildren(), temp.getOffset());
        }
    }

    private void fillBottleneckFlag(List<ReportLinkDetail> lists, Set<String> bottleneckSet) {
        if (CollectionUtils.isEmpty(lists)) {
            return;
        }
        for (ReportLinkDetail dto : lists) {
            dto.setBottleneckFlag(Integer.valueOf(0));
            if (CollectionUtils.isEmpty(bottleneckSet)) continue;
            bottleneckSet.forEach(bottleneck -> {
                if (StringUtils.isBlank((CharSequence)bottleneck)) {
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getServiceName()) && dto.getServiceName().endsWith((String)bottleneck)) {
                    dto.setBottleneckFlag(Integer.valueOf(1));
                }
            });
            this.fillBottleneckFlag(dto.getChildren(), bottleneckSet);
        }
    }
}

