/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.report;

import com.pamirs.tro.entity.domain.vo.report.ReportQueryParam;
import com.pamirs.tro.entity.domain.vo.report.ReportTrendQueryParam;
import com.pamirs.tro.entity.domain.vo.sla.WarnQueryParam;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.output.report.ReportJtlDownloadOutput;
import io.shulie.tro.web.app.response.report.ReportJtlDownloadResponse;
import io.shulie.tro.web.app.service.report.ReportService;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.shulie.tro.web.common.domain.WebResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/"})
@Api(tags={"\u573a\u666f\u62a5\u544a\u6a21\u5757"})
public class ReportController {
    @Autowired
    private ReportService reportService;

    @GetMapping(value={"report/listReport"})
    @ApiOperation(value="\u62a5\u544a\u5217\u8868")
    @AuthVerification(moduleCode="pressureTestManage_pressureTestReport", needAuth=ActionTypeEnum.QUERY)
    public WebResponse listReport(ReportQueryParam reportQuery) {
        return this.reportService.listReport(reportQuery);
    }

    @GetMapping(value={"report/getReportByReportId"})
    @ApiOperation(value="\u62a5\u544a\u8be6\u60c5")
    @ApiImplicitParam(name="reportId", value="\u62a5\u544aID")
    public WebResponse getReportByReportId(Long reportId) {
        return this.reportService.getReportByReportId(reportId);
    }

    @GetMapping(value={"report/queryReportTrend"})
    @ApiOperation(value="\u62a5\u544a\u94fe\u8def\u8d8b\u52bf")
    public WebResponse queryReportTrend(ReportTrendQueryParam reportTrendQuery) {
        return this.reportService.queryReportTrend(reportTrendQuery);
    }

    @GetMapping(value={"report/tempReportDetail"})
    @ApiOperation(value="\u5b9e\u51b5\u62a5\u544a")
    @ApiImplicitParam(name="sceneId", value="\u573a\u666fID")
    @AuthVerification(moduleCode="pressureTestManage_pressureTestScene", needAuth=ActionTypeEnum.START_STOP)
    public WebResponse tempReportDetail(Long sceneId) {
        return this.reportService.tempReportDetail(sceneId);
    }

    @GetMapping(value={"/report/queryTempReportTrend"})
    @ApiOperation(value="\u5b9e\u51b5\u62a5\u544a\u94fe\u8def\u8d8b\u52bf")
    public WebResponse queryTempReportTrend(ReportTrendQueryParam reportTrendQuery) {
        return this.reportService.queryTempReportTrend(reportTrendQuery);
    }

    @GetMapping(value={"/report/listWarn"})
    @ApiOperation(value="\u8b66\u544a\u5217\u8868")
    public WebResponse listWarn(WarnQueryParam param) {
        return this.reportService.listWarn(param);
    }

    @GetMapping(value={"/report/queryReportActivityByReportId"})
    @ApiOperation(value="\u62a5\u544a\u7684\u4e1a\u52a1\u6d3b\u52a8")
    public WebResponse queryReportActivityByReportId(Long reportId) {
        return this.reportService.queryReportActivityByReportId(reportId);
    }

    @GetMapping(value={"/report/queryReportActivityBySceneId"})
    @ApiOperation(value="\u62a5\u544a\u7684\u4e1a\u52a1\u6d3b\u52a8")
    public WebResponse queryReportActivityBySceneId(Long sceneId) {
        return this.reportService.queryReportActivityBySceneId(sceneId);
    }

    @GetMapping(value={"/report/getJtlDownLoadUrl"})
    @ApiOperation(value="\u83b7\u53d6jtl\u6587\u4ef6\u4e0b\u8f7d\u8def\u5f84")
    @AuthVerification(moduleCode="scriptManage", needAuth=ActionTypeEnum.DOWNLOAD)
    public ReportJtlDownloadResponse getJtlDownLoadUrl(@RequestParam Long reportId) {
        ReportJtlDownloadOutput output = this.reportService.getJtlDownLoadUrl(reportId);
        ReportJtlDownloadResponse response = new ReportJtlDownloadResponse();
        BeanUtils.copyProperties((Object)output, (Object)response);
        return response;
    }
}

