/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.preventcheat;

import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.entity.domain.vo.TApplicationMntConfigVo;
import io.shulie.tro.web.app.service.ApplicationMntConfigService;
import io.swagger.annotations.Api;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e94\u7528\u914d\u7f6e\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/"})
public class ApplicationMntConfigController {
    private final Logger LOGGER = LoggerFactory.getLogger(ApplicationMntConfigController.class);
    @Autowired
    private ApplicationMntConfigService applicationMntConfigService;

    @PostMapping(value={"/preventcheat/applicationConfig/queryApplicationConfigPage"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryApplicationConfigPage(@RequestBody Map<String, Object> paramMap) {
        try {
            return ResponseOk.create((Object)this.applicationMntConfigService.queryApplicationConfigPage(paramMap));
        }
        catch (Exception e) {
            this.LOGGER.error("ApplicationMntConfigController.queryApplicationConfigPage \u67e5\u8be2\u914d\u7f6e\u5206\u9875\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.API_TRO_CONFCENTER_APPLICATION_CONFIG_PAGE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.API_TRO_CONFCENTER_APPLICATION_CONFIG_PAGE_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"/preventcheat/applicationConfig/queryConfig"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryConfig(@RequestParam(value="applicationName") String applicationName) {
        try {
            return ResponseOk.create((Object)this.applicationMntConfigService.queryConfig(applicationName));
        }
        catch (Exception e) {
            this.LOGGER.error("ApplicationMntConfigController.updateApplicationConfig \u67e5\u8be2\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.API_TRO_CONFCENTER_APPLICATION_CONFIG_UPDATE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.API_TRO_CONFCENTER_APPLICATION_CONFIG_UPDATE_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"/preventcheat/applicationConfig/updateApplicationConfigBatch"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> updateApplicationConfigBatch(@RequestBody @Valid TApplicationMntConfigVo vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1050100401, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.applicationMntConfigService.updateConfigBatch(vo);
            return ResponseOk.create((Object)"\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            this.LOGGER.error("ApplicationMntConfigController.updateApplicationConfigBatch \u6279\u91cf\u66f4\u65b0\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.API_TRO_CONFCENTER_APPLICATION_CONFIG_UPDATE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.API_TRO_CONFCENTER_APPLICATION_CONFIG_UPDATE_EXCEPTION.getErrorMessage());
        }
    }
}

