/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.preventcheat;

import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.constant.TRODictTypeEnum;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.entity.domain.vo.TUploadInterfaceVo;
import io.shulie.tro.web.app.service.ApplicationInfoUploadService;
import io.shulie.tro.web.app.service.ConfCenterService;
import io.swagger.annotations.Api;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"ApplicationInfoUpload"})
@RestController
@RequestMapping(value={"/api/"})
public class ApplicationInfoUploadController {
    private final Logger LOGGER = LoggerFactory.getLogger(ApplicationInfoUploadController.class);
    @Autowired
    private ApplicationInfoUploadService applicationInfoUploadService;
    @Autowired
    private ConfCenterService confCenterService;

    @PostMapping(value={"/preventcheat/applicationInfo/uploadInfo"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> applicationInfoUpload(@RequestBody TUploadInterfaceVo uploadInterfaceVo) {
        try {
            this.applicationInfoUploadService.saveApplicationInfoUpload(uploadInterfaceVo);
            return ResponseOk.create((Object)"\u4e0a\u4f20\u6210\u529f");
        }
        catch (Exception e) {
            this.LOGGER.error("ApplicationInfoUploadController.applicationInfoUpload \u4e0a\u4f20\u4fe1\u606f\u5931\u8d25 {}", (Throwable)e);
            return ResponseError.create((String)"\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @PostMapping(value={"/preventcheat/applicationInfo/queryInfoPage"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> applicationInfoUploadQueryPage(@RequestBody Map<String, Object> paramMap) {
        try {
            return ResponseOk.create((Object)this.applicationInfoUploadService.queryApplicationPage(paramMap));
        }
        catch (Exception e) {
            this.LOGGER.error("ApplicationInfoUploadController.applicationInfoUploadQueryPage \u67e5\u8be2\u5206\u9875\u4fe1\u606f\u5931\u8d25 {}", (Throwable)e);
            return ResponseError.create((String)"\u67e5\u8be2\u5206\u9875\u4fe1\u606f\u5931\u8d25");
        }
    }

    @GetMapping(value={"/preventcheat/applicationInfo/queryInfoType"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryInfoType() {
        try {
            return ResponseOk.create((Object)this.confCenterService.queryDicList(TRODictTypeEnum.UPLOAD_INFO_TYPE));
        }
        catch (Exception e) {
            this.LOGGER.error("ApplicationInfoUploadController.queryInfoType \u67e5\u8be2\u4e0a\u4f20\u4fe1\u606f\u7c7b\u578b{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_LINKTYPE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_LINKTYPE_EXCEPTION.getErrorMessage());
        }
    }
}

