/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.pressurecontrol;

import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.constant.PressureOperateEnum;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import io.shulie.tro.web.app.service.PressureReadyService;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u538b\u6d4b\u51c6\u5907\u6a21\u5757\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/"})
public class PMCheckController {
    private final Logger LOGGER = LoggerFactory.getLogger(PMCheckController.class);
    @Autowired
    @Qualifier(value="ScriptThreadPool")
    protected ThreadPoolExecutor runShellTaskExecutor;
    @Autowired
    private PressureReadyService pressureReadyService;

    @PostMapping(value={"/pressureready/pmcheck/query/checklist"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryChecklist(@RequestBody Map<String, Object> paramMap) {
        try {
            return ResponseOk.create((Object)this.pressureReadyService.queryChecklist(paramMap));
        }
        catch (Exception e) {
            this.LOGGER.error("PMCheckController.queryChecklist \u67e5\u8be2\u538b\u6d4b\u68c0\u6d4b\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.PMCHECK_QUERY_CHECKLIST_EXCEPTION.getErrorCode(), (String)TROErrorEnum.PMCHECK_QUERY_CHECKLIST_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"/pressureready/pmcheck/check/shadowlib"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryCheckShadowlib(@RequestParam(value="applicationId") String applicationId) {
        try {
            if (StringUtils.isEmpty((CharSequence)applicationId)) {
                return ResponseError.create((int)TROErrorEnum.PMCHECK_QUERY_CHECKSHADOWLIB_PARAMLACK.getErrorCode(), (String)TROErrorEnum.PMCHECK_QUERY_CHECKSHADOWLIB_PARAMLACK.getErrorMessage());
            }
            return ResponseOk.create(this.pressureReadyService.queryCheckShadowlib(applicationId).call());
        }
        catch (Exception e) {
            this.LOGGER.error("PMCheckController.queryCheckShadowlib \u5f71\u5b50\u5e93\u6574\u4f53\u540c\u6b65\u68c0\u6d4b\u67e5\u8be2\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.PMCHECK_QUERY_CHECKSHADOWLIB_EXCEPTION.getErrorCode(), (String)TROErrorEnum.PMCHECK_QUERY_CHECKSHADOWLIB_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"/pressureready/pmcheck/check/wlist"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryCheckWList(@RequestParam(value="applicationId") String applicationId) {
        try {
            return ResponseOk.create(this.pressureReadyService.queryCheckWList(applicationId).call());
        }
        catch (Exception e) {
            this.LOGGER.error("PMCheckController.queryCheckWList \u767d\u540d\u5355\u68c0\u6d4b\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.PMCHECK_QUERY_CHECKWLIST_EXCEPTION.getErrorCode(), (String)TROErrorEnum.PMCHECK_QUERY_CHECKWLIST_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"/pressureready/pmcheck/check/cache"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryCheckCache(@RequestParam(value="applicationId") String applicationId) {
        try {
            return ResponseOk.create(this.pressureReadyService.queryCheckCache(applicationId).call());
        }
        catch (Exception e) {
            this.LOGGER.error("PMCheckController.queryCheckCache \u7f13\u5b58\u9884\u70ed\u68c0\u6d4b\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.PMCHECK_QUERY_CHECKCACHE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.PMCHECK_QUERY_CHECKCACHE_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"/pressureready/pmcheck/check/batchcheck"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> batchCheck(@RequestParam(value="applicationIds") String applicationIds) {
        try {
            return ResponseOk.create((Object)this.pressureReadyService.batchCheck(applicationIds));
        }
        catch (TROModuleException e) {
            this.LOGGER.error("PMCheckController.batchCheck {}" + e.getMessage(), (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("PMCheckController.batchCheck \u6279\u91cf\u68c0\u6d4b\u5931\u8d25{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.PMCHECK_QUERY_BATCHCHECK_EXCEPTION.getErrorCode(), (String)TROErrorEnum.PMCHECK_QUERY_BATCHCHECK_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"/pressureready/pmcheck/debug/switch"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> debugSwitch(@RequestBody List<Map<String, Object>> switchList) {
        try {
            this.pressureReadyService.debugSwitch(switchList, PressureOperateEnum.PRESSURE_CHECK_DEBUG_SWITCH);
            return ResponseOk.create((Object)"\u8c03\u8bd5\u5f00\u5173\u5df2\u5f00\u542f");
        }
        catch (Exception e) {
            this.LOGGER.error("DataBuildController.debugSwitch \u8c03\u8bd5\u5f00\u5173\u5f00\u542f\u5931\u8d25{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.BUILDDATA_DEBUG_SWITCH_FAIL.getErrorCode(), (String)TROErrorEnum.BUILDDATA_DEBUG_SWITCH_FAIL.getErrorMessage());
        }
    }
}

