/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.pressurecontrol;

import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.constant.PressureOperateEnum;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import io.shulie.tro.web.app.service.PressureReadyService;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u6784\u5efa\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/"})
public class DataBuildController {
    private final Logger LOGGER = LoggerFactory.getLogger(DataBuildController.class);
    @Autowired
    private PressureReadyService pressureReadyService;

    @PostMapping(value={"/pressureready/builddata/query/buildinfo"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryBuildinfo(@RequestBody Map<String, Object> paramMap) {
        try {
            return ResponseOk.create((Object)this.pressureReadyService.queryBuildinfo(paramMap));
        }
        catch (Exception e) {
            this.LOGGER.error("DataBuildController.queryBuildinfo \u67e5\u8be2\u6784\u5efa\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.BUILDDATA_QUERY_BUILDINFO_EXCEPTION.getErrorCode(), (String)TROErrorEnum.BUILDDATA_QUERY_BUILDINFO_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"/pressureready/builddata/update/scriptstatus"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> updateScriptExcuteStatus(@RequestBody Map<String, Object> map) {
        if (map == null || map.isEmpty() || StringUtils.isEmpty((CharSequence)MapUtils.getString(map, (Object)"applicationId"))) {
            return ResponseError.create((int)TROErrorEnum.BUILDDATA_UPDATE_SCRIPTSTATUS_PARAMLACK.getErrorCode(), (String)TROErrorEnum.BUILDDATA_UPDATE_SCRIPTSTATUS_PARAMLACK.getErrorMessage());
        }
        try {
            this.pressureReadyService.updateScriptExcuteStatus(map);
            return ResponseOk.create((Object)"succeed");
        }
        catch (Exception e) {
            this.LOGGER.error("DataBuildController.updateScriptExcuteStatus \u65b0\u589e\u811a\u672c\u6267\u884c\u72b6\u6001\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.BUILDDATA_UPDATE_SCRIPTSTATUS_EXCEPTION.getErrorCode(), (String)TROErrorEnum.BUILDDATA_UPDATE_SCRIPTSTATUS_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"/pressureready/builddata/query/scriptbuildstatus"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryScriptExcuteStatus(@RequestParam(value="applicationId") String applicationId, @RequestParam(value="scriptType") String scriptType) {
        try {
            if (StringUtils.isEmpty((CharSequence)scriptType) || StringUtils.isEmpty((CharSequence)applicationId)) {
                return ResponseError.create((int)TROErrorEnum.BUILDDATA_QUERY_SCRIPTSTATUS_PARAMLACK.getErrorCode(), (String)TROErrorEnum.BUILDDATA_QUERY_SCRIPTSTATUS_PARAMLACK.getErrorMessage());
            }
            return ResponseOk.create((Object)this.pressureReadyService.queryScriptExcuteStatus(applicationId, scriptType));
        }
        catch (Exception e) {
            this.LOGGER.error("DataBuildController.queryScriptExcuteStatus \u67e5\u8be2\u811a\u672c\u6267\u884c\u72b6\u6001\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.BUILDDATA_QUERY_SCRIPTSTATUS_EXCEPTION.getErrorCode(), (String)TROErrorEnum.BUILDDATA_QUERY_SCRIPTSTATUS_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"/pressureready/builddata/execute/batchclean"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> batchClean(@RequestParam(value="applicationIds") String applicationIds) {
        try {
            this.pressureReadyService.batchClean(applicationIds);
            return ResponseOk.create((Object)"\u6279\u91cf\u6e05\u7406\u6b63\u5728\u6267\u884c,\u8bf7\u7b49\u5f85...");
        }
        catch (Exception e) {
            this.LOGGER.error("DataBuildController.batchClean \u6279\u91cf\u6e05\u7406\u6570\u636e\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.BUILDDATA_QUERY_BATCHCLEAN_EXCEPTION.getErrorCode(), (String)TROErrorEnum.BUILDDATA_QUERY_BATCHCLEAN_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"/pressureready/builddata/execute/script"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> executeScript(@RequestBody Map<String, Object> paraMap) {
        try {
            this.pressureReadyService.executeScriptPreCheck(paraMap);
            return ResponseOk.create((Object)"\u811a\u672c\u6b63\u5728\u6267\u884c,\u8bf7\u7b49\u5f85......");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("DataBuildController.executeScript \u8be5\u5e94\u7528\u6ca1\u6709\u7f13\u5b58\u4e0d\u7528\u6267\u884c\u7f13\u5b58\u811a\u672c{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("DataBuildController.executeScript \u6267\u884c\u811a\u672c\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.BUILDDATA_EXECUTE_SCRIPT_EXCEPTION.getErrorCode(), (String)TROErrorEnum.BUILDDATA_EXECUTE_SCRIPT_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"/pressureready/builddata/debug/switch"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> debugSwitch(@RequestBody List<Map<String, Object>> switchList) {
        try {
            this.pressureReadyService.debugSwitch(switchList, PressureOperateEnum.DATA_BUILD_DEBUG_SWITCH);
            return ResponseOk.create((Object)"\u8c03\u8bd5\u5f00\u5173\u5df2\u5f00\u542f");
        }
        catch (Exception e) {
            this.LOGGER.error("DataBuildController.debugSwitch \u8c03\u8bd5\u5f00\u5173\u5f00\u542f\u5931\u8d25{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.BUILDDATA_DEBUG_SWITCH_FAIL.getErrorCode(), (String)TROErrorEnum.BUILDDATA_DEBUG_SWITCH_FAIL.getErrorMessage());
        }
    }
}

