/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.pradar;

import io.shulie.tro.common.beans.annotation.ModuleDef;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.request.pradar.PradarZKConfigUpdateRequest;
import io.shulie.tro.web.app.response.pradar.PradarZKConfigResponse;
import io.shulie.tro.web.app.service.pradar.PradarConfigService;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/pradar/switch"})
@Api(tags={"PradarSwitch"}, value="pradar\u5f00\u5173\u3001\u914d\u7f6e")
@RestController
public class PradarConfigController {
    @Autowired
    PradarConfigService pradarConfigService;

    @ApiOperation(value="\u83b7\u53d6\u914d\u7f6e\u5217\u8868")
    @GetMapping(value={"/list"})
    @AuthVerification(moduleCode="configCenter_bigDataConfig", needAuth=ActionTypeEnum.QUERY)
    public PagingList<PradarZKConfigResponse> pageActivities() {
        List configList = this.pradarConfigService.getConfigList();
        return PagingList.of((List)configList, (long)configList.size());
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="PRADAR\u914d\u7f6e\u4fee\u6539")
    @ModuleDef(moduleName="PRADAR", subModuleName="pradar ZK \u914d\u7f6e", logMsgKey="pradar.config.update")
    @AuthVerification(moduleCode="configCenter_bigDataConfig", needAuth=ActionTypeEnum.UPDATE)
    public void updateActivity(@Validated @RequestBody PradarZKConfigUpdateRequest request) {
        OperationLogContextHolder.operationType((String)"\u7f16\u8f91");
        this.pradarConfigService.updateConfig(request.getId(), request.getValue());
    }
}

