/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.pmassist;

import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.constant.MQEnum;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.entity.domain.entity.TEbmProducer;
import com.pamirs.tro.entity.domain.entity.TRocketmqProducer;
import io.shulie.tro.web.app.service.MqProducerService;
import io.shulie.tro.web.app.service.MqProducerWithScriptService;
import io.swagger.annotations.Api;
import java.util.Map;
import javax.validation.Valid;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"MQ\u865a\u62df\u751f\u4ea7\u6d88\u606f\u63a5\u53e3\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/"})
public class MqProducerController {
    private final Logger LOGGER = LoggerFactory.getLogger(MqProducerController.class);
    @Autowired
    private MqProducerService mqProducerService;
    @Autowired
    private MqProducerWithScriptService mqProducerWithScriptService;

    @PostMapping(value={"/assist/produce/ebm/mqmsg"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> ebmProduceMsg(@RequestBody Map<String, Object> paraMap) {
        String mqType = MapUtils.getString(paraMap, (Object)"msgType");
        mqType = "1".equals(mqType) ? MQEnum.ESB.toString() : MQEnum.IBM.toString();
        paraMap.put("msgType", mqType);
        try {
            this.mqProducerWithScriptService.executeStartEbmScript(paraMap);
            return ResponseOk.create((Object)(mqType + "\u6b63\u5728\u751f\u4ea7\u6d88\u606f,\u8bf7\u7b49\u5f85......"));
        }
        catch (TROModuleException e) {
            this.LOGGER.error("MqProducerController.esbOrIBMProduceMsg \u542f\u52a8\u6d88\u8d39\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)(mqType + e.getErrorMessage()));
        }
        catch (Exception e) {
            this.LOGGER.error("MqProducerController.esbOrIBMProduceMsg \u542f\u52a8\u6d88\u8d39\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQPRODUCER_ESB_OR_IBM_EXCEPTION.getErrorCode(), (String)(mqType + TROErrorEnum.ASSIST_MQPRODUCER_ESB_OR_IBM_EXCEPTION.getErrorMessage()));
        }
    }

    @PostMapping(value={"/assist/produce/rocketmq/mqmsg"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> rocketMqProduceMsg(@RequestBody Map<String, Object> paraMap) {
        try {
            this.mqProducerWithScriptService.executeStartRocketmqScript(paraMap);
            return ResponseOk.create((Object)(MQEnum.ROCKETMQ.toString() + "\u6b63\u5728\u751f\u4ea7\u6d88\u606f,\u8bf7\u7b49\u5f85......"));
        }
        catch (Exception e) {
            this.LOGGER.error("MqProducerController.rocketMqProduceMsg \u542f\u52a8\u6d88\u8d39\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"/assist/produce/mqmsg/stop"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> stopMqProduceMsg(@RequestParam(value="mqType") String mqType, @RequestParam(value="id") String id) {
        try {
            this.mqProducerWithScriptService.stopMq(mqType, id);
            return ResponseOk.create((Object)"\u6b63\u5728\u505c\u6b62\u751f\u4ea7\u6d88\u606f,\u8bf7\u7b49\u5f85......");
        }
        catch (Exception e) {
            this.LOGGER.error("MqProducerController.stopMqProduceMsg \u505c\u6b62\u751f\u4ea7\u6d88\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQPRODUCER_STOP_PRODUCE_MSQ_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQPRODUCER_STOP_PRODUCE_MSQ_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"/assist/produce/mqmsg/ebm/add"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> addEsb(@RequestBody @Valid TEbmProducer tEbmProducer, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1050300401, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        String msgType = tEbmProducer.getMsgType();
        msgType = "1".equals(msgType) ? MQEnum.ESB.toString() : MQEnum.IBM.toString();
        try {
            this.mqProducerService.saveEbm(tEbmProducer);
            return ResponseOk.create((Object)"success");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("MqProducerController.addEsb " + msgType + e.getErrorMessage());
            return ResponseError.create((int)e.getErrorCode(), (String)(msgType + e.getErrorMessage()));
        }
        catch (Exception e) {
            this.LOGGER.error("MqProducerController.addEsb \u4fdd\u5b58MQ\u6d88\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQPRODUCER_EBM_SAVE_EXCEPTION.getErrorCode(), (String)(msgType + TROErrorEnum.ASSIST_MQPRODUCER_EBM_SAVE_EXCEPTION.getErrorMessage()));
        }
    }

    @PostMapping(value={"/assist/produce/mqmsg/ebm/update"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> updateEsb(@RequestBody @Valid TEbmProducer tEbmProducer, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1050300601, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        String msgType = tEbmProducer.getMsgType();
        msgType = "1".equals(msgType) ? MQEnum.ESB.toString() : MQEnum.IBM.toString();
        try {
            this.mqProducerService.updateEbm(tEbmProducer);
            return ResponseOk.create((Object)"success");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("MqProducerController.updateEsb " + msgType + e.getErrorMessage());
            return ResponseError.create((int)e.getErrorCode(), (String)(msgType + e.getErrorMessage()));
        }
        catch (Exception e) {
            this.LOGGER.error("MqProducerController.updateEsb \u4fee\u6539" + msgType + "\u751f\u4ea7\u6d88\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQPRODUCER_EBM_UPDATE_EXCEPTION.getErrorCode(), (String)(msgType + TROErrorEnum.ASSIST_MQPRODUCER_EBM_UPDATE_EXCEPTION.getErrorMessage()));
        }
    }

    @GetMapping(value={"/assist/produce/mqmsg/ebm/del"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> deteletEsbOrIbm(@RequestParam(value="tepIds") String tepIds) {
        if (StringUtils.isEmpty((CharSequence)tepIds)) {
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQPRODUCER_ESB_AND_IBM_DELETE_PARAM_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQPRODUCER_ESB_AND_IBM_DELETE_PARAM_EXCEPTION.getErrorMessage());
        }
        try {
            this.mqProducerService.deteletEsbOrIbm(tepIds);
            return ResponseOk.create((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            this.LOGGER.error("MqProducerController.deteletEsbOrIbm \u5220\u9664ESB\u548cIBM\u751f\u4ea7\u6d88\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQPRODUCER_ESB_AND_IBM_DELETE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQPRODUCER_ESB_AND_IBM_DELETE_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"/assist/produce/mqmsg/ebm/querylist"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryEsbAndIbmList(@RequestBody Map<String, Object> paramMap) {
        try {
            return ResponseOk.create((Object)this.mqProducerService.queryEsbAndIbmList(paramMap));
        }
        catch (Exception e) {
            this.LOGGER.error("MqProducerController.queryEsbAndIbmList \u67e5\u8be2ESB/IBM\u751f\u4ea7\u6d88\u606f\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQPRODUCER_ESB_AND_IBM_QUERY_LIST_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQPRODUCER_ESB_AND_IBM_QUERY_LIST_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"/assist/produce/mqmsg/ebm/querybyid"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryEsbOrIbmDetail(@RequestParam(value="tepId") String tepId) {
        try {
            return ResponseOk.create((Object)this.mqProducerService.queryEsbOrIbmDetail(tepId));
        }
        catch (Exception e) {
            this.LOGGER.error("MqProducerController.queryEsbOrIbmDetail \u67e5\u8be2ESB/IBM\u751f\u4ea7\u6d88\u606f\u8be6\u60c5\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQPRODUCER_ESB_OR_IBM_QUERY_DETAIL_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQPRODUCER_ESB_OR_IBM_QUERY_DETAIL_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"/assist/produce/mqmsg/rocketmq/add"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> addRocketmq(@RequestBody @Valid TRocketmqProducer tRocketmqProducer, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1050300201, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.mqProducerService.addRocketmq(tRocketmqProducer);
            return ResponseOk.create((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("MqProducerController.addRocketmq " + e.getErrorMessage());
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("MqProducerController.addRocketmq \u4fdd\u5b58\u6d88\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"/assist/produce/mqmsg/rocketmq/update"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> updateRocketmq(@RequestBody @Valid TRocketmqProducer tRocketmqProducer, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1050300201, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.mqProducerService.updateRocketmq(tRocketmqProducer);
            return ResponseOk.create((Object)"\u4fee\u6539\u6210\u529f");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("MqProducerController.updateRocketmq " + e.getErrorMessage());
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("MqProducerController.updateRocketmq \u4fee\u6539\u6d88\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_UPDATE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_UPDATE_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"/assist/produce/mqmsg/rocketmq/del"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> deteletRocketMq(@RequestParam(value="trpIds") String trpIds) {
        if (StringUtils.isEmpty((CharSequence)trpIds)) {
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_DELETE_PARAM_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_DELETE_PARAM_EXCEPTION.getErrorMessage());
        }
        try {
            this.mqProducerService.deteletRocketMq(trpIds);
            return ResponseOk.create((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            this.LOGGER.error("MqProducerController.deteletRocketMq \u5220\u9664ROCKETMQ\u751f\u4ea7\u6d88\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_DELETE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_DELETE_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"/assist/produce/mqmsg/rocketmq/querylist"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryRocketmqList(@RequestBody Map<String, Object> paramMap) {
        try {
            return ResponseOk.create((Object)this.mqProducerService.queryRocketmqList(paramMap));
        }
        catch (Exception e) {
            this.LOGGER.error("MqProducerController.queryRocketmqList \u67e5\u8be2ROCKETMQ\u751f\u4ea7\u6d88\u606f\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_QUERY_LIST_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_QUERY_LIST_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"/assist/produce/mqmsg/rocketmq/querybyid"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryRocketeMqDetail(@RequestParam(value="trpId") String trpId) {
        try {
            return ResponseOk.create((Object)this.mqProducerService.queryRocketeMqDetail(trpId));
        }
        catch (Exception e) {
            this.LOGGER.error("MqProducerController.queryRocketeMqDetail \u67e5\u8be2ROCKETMQ\u751f\u4ea7\u6d88\u606f\u8be6\u60c5\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_QUERY_DETAIL_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQPRODUCER_ROCKETMQ_QUERY_DETAIL_EXCEPTION.getErrorMessage());
        }
    }
}

