/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.pmassist;

import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.constant.TRODictTypeEnum;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.entity.domain.entity.TMqMsg;
import io.shulie.tro.web.app.service.ConfCenterService;
import io.shulie.tro.web.app.service.MqConsumerService;
import io.swagger.annotations.Api;
import java.util.Map;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"MQ\u865a\u62df\u6d88\u8d39\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/"})
public class MqConsumerController {
    private final Logger LOGGER = LoggerFactory.getLogger(MqConsumerController.class);
    @Autowired
    private MqConsumerService mqConsumerService;
    @Autowired
    private ConfCenterService confCenterService;

    @PostMapping(value={"/assist/startconsumer"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> executeStartConsumerScript(@RequestBody Map<String, Object> paraMap) {
        try {
            this.mqConsumerService.executeStartConsumerScript(paraMap);
            return ResponseOk.create((Object)"\u542f\u52a8\u6d88\u8d39,\u8bf7\u7b49\u5f85......");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("PressureMeasurementAssistController.executeStartConsumerScript esbcode\u4e0d\u7b26\u5408\u8981\u6c42{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("PressureMeasurementAssistController.executeStartConsumerScript \u542f\u52a8\u6d88\u8d39\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_START_CONSUMER_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_START_CONSUMER_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"/assist/stopconsumer"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> executeStopConsumerScript(@RequestBody Map<String, Object> paraMap) {
        try {
            this.mqConsumerService.asyncStopConsumerScript(paraMap);
            return ResponseOk.create((Object)"\u505c\u6b62\u6d88\u8d39,\u8bf7\u7b49\u5f85......");
        }
        catch (Exception e) {
            this.LOGGER.error("PressureMeasurementAssistController.executeStopConsumerScript \u505c\u6b62\u6d88\u8d39\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_STOP_CONSUMER_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_STOP_CONSUMER_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"/assist/mqmsg/add"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> addMqMsg(@RequestBody @Valid TMqMsg tMqMsg, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1050100301, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.mqConsumerService.addMqMsg(tMqMsg);
            return ResponseOk.create((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("PressureMeasurementAssistController.addMqMsg " + e.getErrorMessage());
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("PressureMeasurementAssistController.addMqMsg \u4fdd\u5b58MQ\u6d88\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQMSG_SAVE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQMSG_SAVE_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"/assist/mqmsg/update"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> updateMqMsg(@RequestBody @Valid TMqMsg tMqMsg, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1050100401, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.mqConsumerService.updateMqMsg(tMqMsg);
            return ResponseOk.create((Object)"\u4fee\u6539\u6210\u529f");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("PressureMeasurementAssistController.updateMqMsg " + e.getErrorMessage());
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("PressureMeasurementAssistController.updateMqMsg \u4fee\u6539MQ\u6d88\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQMSG_UPDATE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQMSG_UPDATE_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"/assist/mqmsg/delete"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> deteletMqMsg(@RequestParam(value="msgIds") String msgIds) {
        if (StringUtils.isEmpty((CharSequence)msgIds)) {
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQMSG_MQMSGID_IS_EMPTY_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQMSG_MQMSGID_IS_EMPTY_EXCEPTION.getErrorMessage());
        }
        try {
            this.mqConsumerService.batchDeleteMqMsg(msgIds);
            return ResponseOk.create((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            this.LOGGER.error("PressureMeasurementAssistController.deteletMqMsg \u5220\u9664MQ\u6d88\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQMSG_DELETE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQMSG_DELETE_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"/assist/mqmsg/query/list"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryMqMsgList(@RequestBody Map<String, Object> paramMap) {
        try {
            return ResponseOk.create((Object)this.mqConsumerService.queryMqMsgList(paramMap));
        }
        catch (Exception e) {
            this.LOGGER.error("PressureMeasurementAssistController.queryMqMsgList \u67e5\u8be2MQ\u6d88\u606f\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQMSG_QUERY_MQMSG_LIST_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQMSG_QUERY_MQMSG_LIST_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"/assist/mqmsg/query"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryMqMsgDetail(@RequestParam(value="msgId") String msgId) {
        try {
            return ResponseOk.create((Object)this.mqConsumerService.queryMqMsgDetail(msgId));
        }
        catch (Exception e) {
            this.LOGGER.error("PressureMeasurementAssistController.queryMqMsgDetail \u67e5\u8be2MQ\u6d88\u606f\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQMSG_QUERY_MQMSG_DETAIL_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQMSG_QUERY_MQMSG_DETAIL_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"/assist/mqmsg/query/type"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryMqMsgTypeDict() {
        try {
            return ResponseOk.create((Object)this.confCenterService.queryDicList(TRODictTypeEnum.MQMSG));
        }
        catch (Exception e) {
            this.LOGGER.error("PressureMeasurementAssistController.queryMqMsgTypeDict  \u67e5\u8be2\u6d88\u606f\u7c7b\u578b\u5b57\u5178\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.ASSIST_MQMSG_QUERY_MQMSG_TYPE_DICT_EXCEPTION.getErrorCode(), (String)TROErrorEnum.ASSIST_MQMSG_QUERY_MQMSG_TYPE_DICT_EXCEPTION.getErrorMessage());
        }
    }
}

