/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.pmassist;

import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.exception.TROModuleException;
import io.shulie.tro.web.app.service.FileUploadService;
import io.swagger.annotations.Api;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6587\u4ef6\u7684\u4e0a\u4f20\u4e0b\u8f7d"})
@RestController
@RequestMapping(value={"/api/"})
public class FileUploadController {
    private final Logger LOGGER = LoggerFactory.getLogger(FileUploadController.class);
    @Autowired
    private FileUploadService fileUploadService;

    @PostMapping(value={"/assist/dbconf/sql/upload"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> fileupload(@RequestParam(value="file") MultipartFile file) {
        try {
            if (file.isEmpty()) {
                return ResponseError.create((String)"\u6587\u4ef6\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            }
            return ResponseOk.create((Object)this.fileUploadService.executeFile(file));
        }
        catch (TROModuleException e) {
            this.LOGGER.error("FileUploadController.fileupload" + e.getErrorMessage(), (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            return ResponseError.create((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @PostMapping(value={"/assist/dbconf/sql/batch/upload"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> batchFileUpload(MultipartFile[] files) {
        try {
            return ResponseOk.create((Object)this.fileUploadService.batchUploadFile(files));
        }
        catch (TROModuleException e) {
            this.LOGGER.error("FileUploadController.batchFileUpload" + e.getErrorMessage(), (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("FileUploadController.batchFileUpload" + e.getMessage(), (Throwable)e);
            return ResponseError.create((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @GetMapping(value={"/assist/dbconf/sql/download"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> downloadFile(@RequestParam(value="file") String fileName, HttpServletResponse response) throws IOException {
        try {
            this.fileUploadService.downloadFile(fileName, response);
            return ResponseOk.create((Object)"\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("FileUploadController.downloadFile" + e.getMessage(), (Throwable)e);
            return ResponseOk.create((Object)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
        }
    }
}

