/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.openapi;

import com.pamirs.tro.entity.domain.dto.report.MachineDetailDTO;
import com.pamirs.tro.entity.domain.vo.report.ReportQueryParam;
import com.pamirs.tro.entity.domain.vo.report.ReportTrendQueryParam;
import com.pamirs.tro.entity.domain.vo.sla.WarnQueryParam;
import io.shulie.tro.utils.json.JsonHelper;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.controller.openapi.converter.ReportOpenApiConverter;
import io.shulie.tro.web.app.controller.openapi.request.report.ReportQueryOpenApiReq;
import io.shulie.tro.web.app.controller.openapi.request.report.ReportTrendQueryOpenApiReq;
import io.shulie.tro.web.app.controller.openapi.request.report.WarnQueryOpenApiReq;
import io.shulie.tro.web.app.controller.openapi.response.report.BusinessActivityOpenApiResp;
import io.shulie.tro.web.app.controller.openapi.response.report.ReportDetailOpenApiResp;
import io.shulie.tro.web.app.controller.openapi.response.report.ReportOpenApiResp;
import io.shulie.tro.web.app.controller.openapi.response.report.ReportTrendOpenApiResp;
import io.shulie.tro.web.app.controller.openapi.response.report.WarnDetailOpenApiResp;
import io.shulie.tro.web.app.service.report.ReportLocalService;
import io.shulie.tro.web.app.service.report.ReportService;
import io.shulie.tro.web.common.domain.WebResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-api/v01/"})
@Api(tags={"\u573a\u666f\u62a5\u544a\u6a21\u5757"})
public class ReportOpenApi {
    @Autowired
    private ReportService reportService;
    @Autowired
    private ReportLocalService reportLocalService;

    @GetMapping(value={"report/listReport"})
    @ApiOperation(value="\u62a5\u544a\u5217\u8868")
    public Response<List<ReportOpenApiResp>> listReport(ReportQueryOpenApiReq reportQueryOpenApiReq) {
        ReportQueryParam reportQuery = ReportOpenApiConverter.INSTANCE.ofReportQueryOpenApiReq(reportQueryOpenApiReq);
        WebResponse webResponse = this.reportService.listReport(reportQuery);
        return Response.success((Object)this.ofListReportOpenApiResp(webResponse.getData()));
    }

    @GetMapping(value={"report/getReportByReportId"})
    @ApiOperation(value="\u62a5\u544a\u8be6\u60c5")
    @ApiImplicitParam(name="reportId", value="\u62a5\u544aID")
    public Response<ReportDetailOpenApiResp> getReportByReportId(Long reportId) {
        WebResponse reportByReportId = this.reportService.getReportByReportId(reportId);
        return Response.success((Object)this.ofReportDetailOpenApiResp(reportByReportId.getData()));
    }

    @GetMapping(value={"report/queryReportTrend"})
    @ApiOperation(value="\u62a5\u544a\u94fe\u8def\u8d8b\u52bf")
    public Response<ReportTrendOpenApiResp> queryReportTrend(ReportTrendQueryOpenApiReq reportTrendQueryOpenApiReq) {
        ReportTrendQueryParam reportTrendQuery = ReportOpenApiConverter.INSTANCE.ofReportTrendQueryOpenApiReq(reportTrendQueryOpenApiReq);
        WebResponse webResponse = this.reportService.queryReportTrend(reportTrendQuery);
        return Response.success((Object)this.ofReportTrendOpenApiResp(webResponse.getData()));
    }

    @GetMapping(value={"/report/listWarn"})
    @ApiOperation(value="\u8b66\u544a\u5217\u8868")
    public Response<List<WarnDetailOpenApiResp>> listWarn(WarnQueryOpenApiReq warnQueryOpenApiReq) {
        WarnQueryParam param = ReportOpenApiConverter.INSTANCE.ofWarnQueryParam(warnQueryOpenApiReq);
        WebResponse webResponse = this.reportService.listWarn(param);
        return Response.success((Object)this.ofListWarnDetailOpenApiResp(webResponse.getData()));
    }

    @GetMapping(value={"/report/queryReportActivityByReportId"})
    @ApiOperation(value="\u62a5\u544a\u7684\u4e1a\u52a1\u6d3b\u52a8")
    public Response<List<BusinessActivityOpenApiResp>> queryReportActivityByReportId(Long reportId) {
        WebResponse webResponse = this.reportService.queryReportActivityByReportId(reportId);
        return Response.success((Object)ReportOpenApiConverter.INSTANCE.ofLsitBusinessActivityOpenApiResp((List)webResponse.getData()));
    }

    @GetMapping(value={"/report/queryReportActivityBySceneId"})
    @ApiOperation(value="\u62a5\u544a\u7684\u4e1a\u52a1\u6d3b\u52a8")
    public Response<List<BusinessActivityOpenApiResp>> queryReportActivityBySceneId(Long sceneId) {
        WebResponse webResponse = this.reportService.queryReportActivityBySceneId(sceneId);
        return Response.success((Object)ReportOpenApiConverter.INSTANCE.ofLsitBusinessActivityOpenApiResp((List)webResponse.getData()));
    }

    @GetMapping(value={"/report/machine/detail"})
    @ApiOperation(value="\u6027\u80fd\u8be6\u60c5")
    public MachineDetailDTO getMachineDetail(Long reportId, String applicationName, String machineIp) {
        return this.reportLocalService.getMachineDetail(reportId, applicationName, machineIp);
    }

    private ReportDetailOpenApiResp ofReportDetailOpenApiResp(Object data) {
        if (data == null) {
            return null;
        }
        String s = JsonHelper.bean2Json((Object)data);
        return (ReportDetailOpenApiResp)JsonHelper.json2Bean((String)s, ReportDetailOpenApiResp.class);
    }

    private ReportTrendOpenApiResp ofReportTrendOpenApiResp(Object data) {
        if (data == null) {
            return null;
        }
        String s = JsonHelper.bean2Json((Object)data);
        return (ReportTrendOpenApiResp)JsonHelper.json2Bean((String)s, ReportTrendOpenApiResp.class);
    }

    private List<ReportOpenApiResp> ofListReportOpenApiResp(Object data) {
        if (data == null) {
            return null;
        }
        String s = JsonHelper.bean2Json((Object)data);
        return JsonHelper.json2List((String)s, ReportOpenApiResp.class);
    }

    private List<WarnDetailOpenApiResp> ofListWarnDetailOpenApiResp(Object data) {
        if (data == null) {
            return null;
        }
        String s = JsonHelper.bean2Json((Object)data);
        return JsonHelper.json2List((String)s, WarnDetailOpenApiResp.class);
    }
}

