/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.openapi;

import com.pamirs.tro.entity.domain.dto.linkmanage.BusinessFlowDto;
import com.pamirs.tro.entity.domain.vo.linkmanage.queryparam.BusinessQueryVo;
import com.pamirs.tro.entity.domain.vo.linkmanage.queryparam.SceneQueryVo;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.controller.openapi.converter.LinkManageOpenApiConverter;
import io.shulie.tro.web.app.controller.openapi.response.linkmanage.BusinessActiveViewListOpenApiResp;
import io.shulie.tro.web.app.controller.openapi.response.linkmanage.BusinessFlowOpenApiResp;
import io.shulie.tro.web.app.controller.openapi.response.linkmanage.BusinessLinkOpenApiResp;
import io.shulie.tro.web.app.controller.openapi.response.linkmanage.SceneOpenApiResp;
import io.shulie.tro.web.app.controller.openapi.response.linkmanage.SystemProcessViewListOpenApiResp;
import io.shulie.tro.web.app.controller.openapi.response.linkmanage.TechLinkOpenApiResp;
import io.shulie.tro.web.app.response.linkmanage.BusinessLinkResponse;
import io.shulie.tro.web.app.service.linkManage.LinkManageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-api/v01/"})
@Api(tags={"linkmanage"}, value="\u94fe\u8def\u6807\u6ce8")
public class LinkManageOpenApi {
    @Autowired
    private LinkManageService linkManageService;
    @Value(value="${link.graph.enable:false}")
    private boolean graphEable;

    @GetMapping(value={"/link/tech/linkManage"})
    @ApiOperation(value="\u7cfb\u7edf\u6d41\u7a0b\u5217\u8868\u67e5\u8be2\u63a5\u53e3")
    public Response<List<SystemProcessViewListOpenApiResp>> gettechLinksViwList(@ApiParam(name="linkName", value="\u7cfb\u7edf\u6d41\u7a0b\u540d\u5b57") String linkName, @ApiParam(name="entrance", value="\u5165\u53e3") String entrance, @ApiParam(name="ischange", value="\u662f\u5426\u53d8\u66f4") String ischange, @ApiParam(name="middleWareType", value="\u4e2d\u95f4\u4ef6\u7c7b\u578b") String middleWareType, @ApiParam(name="middleWareName", value="\u4e2d\u95f4\u4ef6\u540d\u79f0") String middleWareName, @ApiParam(name="middleWareVersion", value="\u4e2d\u95f4\u4ef6\u7248\u672c") String middleWareVersion, Integer current, Integer pageSize) {
        return Response.success();
    }

    @GetMapping(value={"/link/tech/linkManage/detail"})
    @ApiOperation(value="\u4ece\u672c\u5730\u6570\u636e\u5e93\u67e5\u8be2\u7cfb\u7edf\u6d41\u7a0b\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3")
    public Response<TechLinkOpenApiResp> fetchTechLinkDetail(@RequestParam(value="id") @ApiParam(name="id", value="\u7cfb\u7edf\u6d41\u7a0b\u4e3b\u952e") String id) {
        return Response.success();
    }

    @GetMapping(value={"/link/business/manage"})
    @ApiOperation(value="\u4e1a\u52a1\u6d3b\u52a8\u5217\u8868\u67e5\u8be2")
    public Response<List<BusinessActiveViewListOpenApiResp>> getBussisnessLinks(@ApiParam(name="businessLinkName", value="\u4e1a\u52a1\u6d3b\u52a8\u540d\u5b57") String businessLinkName, @ApiParam(name="entrance", value="\u5165\u53e3") String entrance, @ApiParam(name="ischange", value="\u662f\u5426\u53d8\u66f4") String ischange, @ApiParam(name="domain", value="\u4e1a\u52a1\u57df") String domain, @ApiParam(name="middleWareType", value="\u4e2d\u95f4\u4ef6\u7c7b\u578b") String middleWareType, @ApiParam(name="middleWareName", value="\u4e2d\u95f4\u4ef6\u540d\u79f0") String middleWareName, @ApiParam(name="middleWareVersion", value="\u4e2d\u95f4\u4ef6\u7248\u672c\u53f7") String middleWareVersion, @ApiParam(name="systemProcessName", value="\u7cfb\u7edf\u6d41\u7a0b\u540d\u5b57") String systemProcessName, Integer current, Integer pageSize) {
        BusinessQueryVo vo = new BusinessQueryVo();
        vo.setBusinessLinkName(businessLinkName);
        vo.setEntrance(entrance);
        vo.setIschange(ischange);
        vo.setDomain(domain);
        vo.setMiddleWareType(middleWareType);
        vo.setMiddleWareName(middleWareName);
        vo.setTechLinkName(systemProcessName);
        vo.setVersion(middleWareVersion);
        vo.setCurrentPage(current);
        vo.setPageSize(pageSize);
        Response bussisnessLinks = this.linkManageService.getBussisnessLinks(vo);
        return Response.success((Object)LinkManageOpenApiConverter.INSTANCE.ofListBusinessActiveViewListOpenApiResp((List)bussisnessLinks.getData()));
    }

    @GetMapping(value={"/link/business/manage/detail"})
    @ApiOperation(value="\u4e1a\u52a1\u6d3b\u52a8\u8be6\u60c5\u67e5\u8be2")
    public Response<BusinessLinkOpenApiResp> getBussisnessLinkDetail(@ApiParam(name="id", value="\u4e1a\u52a1\u6d3b\u52a8\u4e3b\u952e") @RequestParam(value="id") String id) {
        try {
            BusinessLinkResponse businessLinkResponse = this.linkManageService.getBussisnessLinkDetail(id);
            return Response.success((Object)LinkManageOpenApiConverter.INSTANCE.ofBusinessLinkOpenApiResp(businessLinkResponse));
        }
        catch (Exception e) {
            return Response.fail((String)"0", (String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    @GetMapping(value={"/link/scene/manage"})
    @ApiOperation(value="\u4e1a\u52a1\u6d41\u7a0b\u5217\u8868\u67e5\u8be2")
    public Response<List<SceneOpenApiResp>> getScenes(@ApiParam(name="sceneId", value="\u573a\u666fid") Long sceneId, @ApiParam(name="sceneName", value="\u4e1a\u52a1\u6d41\u7a0b\u540d\u5b57") String sceneName, @ApiParam(name="entrance", value="\u5165\u53e3") String entrance, @ApiParam(name="ischange", value="\u662f\u5426\u53d8\u66f4") String ischange, @ApiParam(name="businessName", value="\u4e1a\u52a1\u6d3b\u52a8\u540d") String businessName, @ApiParam(name="middleWareType", value="\u4e2d\u95f4\u4ef6\u7c7b\u578b") String middleWareType, @ApiParam(name="middleWareName", value="\u4e2d\u95f4\u4ef6\u540d\u5b57") String middleWareName, @ApiParam(name="middleWareVersion", value="\u4e2d\u95f4\u4ef6\u7248\u672c") String middleWareVersion, Integer current, Integer pageSize) {
        SceneQueryVo vo = new SceneQueryVo();
        vo.setSceneId(sceneId);
        vo.setSceneName(sceneName);
        vo.setEntrace(entrance);
        vo.setIschanged(ischange);
        vo.setBusinessName(businessName);
        vo.setMiddleWareType(middleWareType);
        vo.setMiddleWareName(middleWareName);
        vo.setMiddleWareVersion(middleWareVersion);
        vo.setCurrentPage(current);
        vo.setPageSize(pageSize);
        Response scenes = this.linkManageService.getScenes(vo);
        return Response.success((Object)LinkManageOpenApiConverter.INSTANCE.ofListSceneOpenApiResp((List)scenes.getData()));
    }

    @GetMapping(value={"/link/scene/tree/detail"})
    @ApiOperation(value="\u4e1a\u52a1\u6d41\u7a0b\u6811\u8be6\u60c5\u83b7\u53d6")
    public Response<BusinessFlowOpenApiResp> getBusinessFlowDetail(@NotNull String id) {
        try {
            BusinessFlowDto dto = this.linkManageService.getBusinessFlowDetail(id);
            return Response.success((Object)LinkManageOpenApiConverter.INSTANCE.ofBusinessFlowOpenApiResp(dto));
        }
        catch (Exception e) {
            return Response.fail((String)"0", (String)e.getMessage(), null);
        }
    }
}

