/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.openapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Maps;
import io.shulie.tro.web.amdb.bean.common.EntranceTypeEnum;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.controller.openapi.request.activity.ActivityCreateApiRequest;
import io.shulie.tro.web.app.controller.openapi.response.activity.ActivityCreateApiResponse;
import io.shulie.tro.web.data.mapper.mysql.BusinessLinkManageTableMapper;
import io.shulie.tro.web.data.mapper.mysql.LinkManageTableMapper;
import io.shulie.tro.web.data.model.mysql.BusinessLinkManageTableEntity;
import io.shulie.tro.web.data.model.mysql.LinkManageTableEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-api/v01//activities"})
public class ActivityOpenApi {
    @Resource
    private LinkManageTableMapper linkManageTableMapper;
    @Resource
    private BusinessLinkManageTableMapper businessLinkManageTableMapper;
    public static final Long CUSTOMER_ID = 1L;

    @PostMapping(value={"/create"})
    @Transactional(rollbackFor={Throwable.class})
    public Response<ActivityCreateApiResponse> createActivity(@Valid @RequestBody ActivityCreateApiRequest request) {
        String[] fixedPrefix;
        String entranceName1 = request.getEntranceName();
        for (String prefix : fixedPrefix = new String[]{"https://", "http://"}) {
            if (!entranceName1.startsWith(prefix)) continue;
            entranceName1 = entranceName1.replace(prefix, "");
        }
        request.setEntranceName(entranceName1);
        ActivityCreateApiResponse activityCreateApiResponse = new ActivityCreateApiResponse();
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        String activityName = request.getActivityName();
        String entranceName = this.buildEntrance(request.getApplicationName(), request.getEntranceMethod(), request.getEntranceName());
        lambdaQueryWrapper.eq(BusinessLinkManageTableEntity::getEntrace, (Object)entranceName);
        List businessLinkManageTableEntities = this.businessLinkManageTableMapper.selectList((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)businessLinkManageTableEntities)) {
            activityCreateApiResponse.setActivityId(((BusinessLinkManageTableEntity)businessLinkManageTableEntities.get(0)).getLinkId());
            activityCreateApiResponse.setActivityName(((BusinessLinkManageTableEntity)businessLinkManageTableEntities.get(0)).getLinkName());
            return Response.success((Object)activityCreateApiResponse);
        }
        lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BusinessLinkManageTableEntity::getLinkName, (Object)activityName);
        businessLinkManageTableEntities = this.businessLinkManageTableMapper.selectList((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)businessLinkManageTableEntities)) {
            activityName = activityName + System.currentTimeMillis();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("serviceName", (Object)request.getApplicationName());
        jsonObject.put("applicationName", (Object)request.getApplicationName());
        LinkManageTableEntity linkManageTableEntity = new LinkManageTableEntity();
        linkManageTableEntity.setLinkName(activityName);
        linkManageTableEntity.setEntrace(entranceName);
        linkManageTableEntity.setChangeBefore(jsonObject.toJSONString());
        linkManageTableEntity.setChangeAfter(null);
        linkManageTableEntity.setChangeRemark(null);
        linkManageTableEntity.setIsChange(Integer.valueOf(0));
        linkManageTableEntity.setIsJob(Integer.valueOf(0));
        linkManageTableEntity.setCustomerId(CUSTOMER_ID);
        linkManageTableEntity.setUserId(request.getUserId());
        linkManageTableEntity.setIsDeleted(Integer.valueOf(0));
        linkManageTableEntity.setApplicationName(request.getApplicationName());
        linkManageTableEntity.setChangeType(Integer.valueOf(0));
        linkManageTableEntity.setCanDelete(Integer.valueOf(0));
        linkManageTableEntity.setFeatures(this.buildFeature(request.getEntranceMethod(), request.getEntranceName()));
        this.linkManageTableMapper.insert((Object)linkManageTableEntity);
        BusinessLinkManageTableEntity businessLinkManageTableEntity = new BusinessLinkManageTableEntity();
        businessLinkManageTableEntity.setLinkName(activityName);
        businessLinkManageTableEntity.setEntrace(entranceName);
        businessLinkManageTableEntity.setRelatedTechLink(String.valueOf(linkManageTableEntity.getLinkId()));
        businessLinkManageTableEntity.setLinkLevel(request.getActivityLevel());
        businessLinkManageTableEntity.setIsChange(Integer.valueOf(0));
        businessLinkManageTableEntity.setIsCore(request.getIsCore());
        businessLinkManageTableEntity.setIsDeleted(Integer.valueOf(0));
        businessLinkManageTableEntity.setCustomerId(CUSTOMER_ID);
        businessLinkManageTableEntity.setUserId(request.getUserId());
        businessLinkManageTableEntity.setBusinessDomain(request.getBusinessDomain());
        businessLinkManageTableEntity.setCanDelete(Integer.valueOf(0));
        this.businessLinkManageTableMapper.insert((Object)businessLinkManageTableEntity);
        if (null != businessLinkManageTableEntity.getLinkId() && null != linkManageTableEntity.getLinkId()) {
            LinkManageTableEntity linkManageUpdateEntity = new LinkManageTableEntity();
            linkManageUpdateEntity.setLinkId(linkManageTableEntity.getLinkId());
            linkManageUpdateEntity.setCanDelete(Integer.valueOf(1));
            this.linkManageTableMapper.updateById((Object)linkManageUpdateEntity);
        }
        activityCreateApiResponse.setActivityId(businessLinkManageTableEntity.getLinkId());
        activityCreateApiResponse.setActivityName(businessLinkManageTableEntity.getLinkName());
        return Response.success((Object)activityCreateApiResponse);
    }

    private String buildEntrance(String applicationName, String entranceMethod, String entranceName) {
        return applicationName + "|" + entranceMethod.toUpperCase() + "|" + entranceName + "|0";
    }

    private String buildFeature(String entranceMethod, String entranceName) {
        HashMap features = Maps.newHashMap();
        features.put("serverMiddlewareType", EntranceTypeEnum.HTTP.getType());
        features.put("extend", "");
        features.put("rpcType", "0");
        features.put("method", entranceMethod);
        features.put("serviceName", entranceName);
        return JSON.toJSONString((Object)features);
    }
}

