/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.linkmanage.node;

import com.pamirs.tro.entity.domain.vo.linkmanage.EntranceVo;
import io.shulie.tro.web.app.controller.linkmanage.node.BTree;
import java.util.Comparator;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BTree<K, V> {
    private static final int DEFAULT_T = 2;
    private static Logger logger = LoggerFactory.getLogger(BTree.class);
    private BTreeNode<K, V> root;
    private int t = 2;
    private int minKeySize = this.t - 1;
    private int maxKeySize = 2 * this.t - 1;
    private Comparator<K> kComparator;

    public BTree() {
        this.root = new BTreeNode(null);
        this.root.setLeaf(true);
    }

    public BTree(int t) {
        this();
        this.t = t;
        this.minKeySize = t - 1;
        this.maxKeySize = 2 * t - 1;
    }

    public BTree(Comparator<K> kComparator) {
        this.root = new BTreeNode(kComparator);
        this.root.setLeaf(true);
        this.kComparator = kComparator;
    }

    public BTree(Comparator<K> kComparator, int t) {
        this(kComparator);
        this.t = t;
        this.minKeySize = t - 1;
        this.maxKeySize = 2 * t - 1;
    }

    public static void main(String[] args) {
        BTree btree2 = new BTree();
        EntranceVo vo1 = new EntranceVo();
        vo1.setEntrance("1111");
        btree2.insert((Object)"1", (Object)vo1);
        EntranceVo vo2 = new EntranceVo();
        vo1.setEntrance("222");
        btree2.insert((Object)"2", (Object)vo1);
        EntranceVo vo3 = new EntranceVo();
        vo1.setEntrance("222");
        btree2.insert((Object)"3", (Object)vo1);
        EntranceVo vo12 = new EntranceVo();
        vo1.setEntrance("1.222");
        btree2.insert((Object)"1", (Object)vo12);
        EntranceVo vo13 = new EntranceVo();
        vo1.setEntrance("1.222");
        btree2.insert((Object)"2", (Object)vo13);
        System.out.println("----------------------");
        btree2.output();
    }

    int compare(K key1, K key2) {
        return this.kComparator == null ? ((Comparable)key1).compareTo(key2) : this.kComparator.compare(key1, key2);
    }

    public V search(K key) {
        return (V)this.search(this.root, key);
    }

    private V search(BTreeNode<K, V> node, K key) {
        SearchResult result = node.searchKey(key);
        if (result.isExist()) {
            return (V)result.getValue();
        }
        if (node.isLeaf()) {
            return null;
        }
        this.search(node.childAt(result.getIndex()), key);
        return null;
    }

    private void splitNode(BTreeNode<K, V> parentNode, BTreeNode<K, V> childNode, int index) {
        int i;
        assert (childNode.size() == this.maxKeySize);
        BTreeNode siblingNode = new BTreeNode(this.kComparator);
        siblingNode.setLeaf(childNode.isLeaf());
        for (int i2 = 0; i2 < this.minKeySize; ++i2) {
            siblingNode.addEntry(childNode.entryAt(this.t + i2));
        }
        Entry entry = childNode.entryAt(this.t - 1);
        for (i = this.maxKeySize - 1; i >= this.t - 1; --i) {
            childNode.removeEntry(i);
        }
        if (!childNode.isLeaf()) {
            for (i = 0; i < this.minKeySize + 1; ++i) {
                siblingNode.addChild(childNode.childAt(this.t + i));
            }
            for (i = this.maxKeySize; i >= this.t; --i) {
                childNode.removeChild(i);
            }
        }
        parentNode.insertEntry(entry, index);
        parentNode.insertChild(siblingNode, index + 1);
    }

    private boolean insertNotFull(BTreeNode<K, V> node, Entry<K, V> entry) {
        assert (node.size() < this.maxKeySize);
        if (node.isLeaf()) {
            return node.insertEntry(entry);
        }
        SearchResult result = node.searchKey(entry.getKey());
        if (result.isExist()) {
            return false;
        }
        BTreeNode childNode = node.childAt(result.getIndex());
        if (childNode.size() == 2 * this.t - 1) {
            this.splitNode(node, childNode, result.getIndex());
            if (this.compare(entry.getKey(), node.entryAt(result.getIndex()).getKey()) > 0) {
                childNode = node.childAt(result.getIndex() + 1);
            }
        }
        return this.insertNotFull(childNode, entry);
    }

    public boolean insert(K key, V value) {
        if (this.root.size() == this.maxKeySize) {
            BTreeNode newRoot = new BTreeNode(this.kComparator);
            newRoot.setLeaf(false);
            newRoot.addChild(this.root);
            this.splitNode(newRoot, this.root, 0);
            this.root = newRoot;
        }
        return this.insertNotFull(this.root, new Entry(key, value));
    }

    private V putNotFull(BTreeNode<K, V> node, Entry<K, V> entry) {
        assert (node.size() < this.maxKeySize);
        if (node.isLeaf()) {
            return (V)node.putEntry(entry);
        }
        SearchResult result = node.searchKey(entry.getKey());
        if (result.isExist()) {
            return (V)node.putEntry(entry);
        }
        BTreeNode childNode = node.childAt(result.getIndex());
        if (childNode.size() == 2 * this.t - 1) {
            this.splitNode(node, childNode, result.getIndex());
            if (this.compare(entry.getKey(), node.entryAt(result.getIndex()).getKey()) > 0) {
                childNode = node.childAt(result.getIndex() + 1);
            }
        }
        return (V)this.putNotFull(childNode, entry);
    }

    public V put(K key, V value) {
        if (this.root.size() == this.maxKeySize) {
            BTreeNode newRoot = new BTreeNode(this.kComparator);
            newRoot.setLeaf(false);
            newRoot.addChild(this.root);
            this.splitNode(newRoot, this.root, 0);
            this.root = newRoot;
        }
        return (V)this.putNotFull(this.root, new Entry(key, value));
    }

    public Entry<K, V> delete(K key) {
        return this.delete(this.root, key);
    }

    private Entry<K, V> delete(BTreeNode<K, V> node, K key) {
        assert (node.size() >= this.t || node == this.root);
        SearchResult result = node.searchKey(key);
        if (result.isExist()) {
            int i;
            if (node.isLeaf()) {
                return node.removeEntry(result.getIndex());
            }
            BTreeNode leftChildNode = node.childAt(result.getIndex());
            if (leftChildNode.size() >= this.t) {
                node.removeEntry(result.getIndex());
                node.insertEntry(leftChildNode.entryAt(leftChildNode.size() - 1), result.getIndex());
                return this.delete(leftChildNode, leftChildNode.entryAt(leftChildNode.size() - 1).getKey());
            }
            BTreeNode rightChildNode = node.childAt(result.getIndex() + 1);
            if (rightChildNode.size() >= this.t) {
                node.removeEntry(result.getIndex());
                node.insertEntry(rightChildNode.entryAt(0), result.getIndex());
                return this.delete(rightChildNode, rightChildNode.entryAt(0).getKey());
            }
            Entry deletedEntry = node.removeEntry(result.getIndex());
            node.removeChild(result.getIndex() + 1);
            leftChildNode.addEntry(deletedEntry);
            for (i = 0; i < rightChildNode.size(); ++i) {
                leftChildNode.addEntry(rightChildNode.entryAt(i));
            }
            if (!rightChildNode.isLeaf()) {
                for (i = 0; i <= rightChildNode.size(); ++i) {
                    leftChildNode.addChild(rightChildNode.childAt(i));
                }
            }
            return this.delete(leftChildNode, key);
        }
        if (node.isLeaf()) {
            logger.info("The key: " + key + " isn't in this BTree.");
            return null;
        }
        BTreeNode childNode = node.childAt(result.getIndex());
        if (childNode.size() >= this.t) {
            return this.delete(childNode, key);
        }
        BTreeNode siblingNode = null;
        int siblingIndex = -1;
        if (result.getIndex() < node.size() && node.childAt(result.getIndex() + 1).size() >= this.t) {
            siblingNode = node.childAt(result.getIndex() + 1);
            siblingIndex = result.getIndex() + 1;
        }
        if (siblingNode == null && result.getIndex() > 0 && node.childAt(result.getIndex() - 1).size() >= this.t) {
            siblingNode = node.childAt(result.getIndex() - 1);
            siblingIndex = result.getIndex() - 1;
        }
        if (siblingNode != null) {
            if (siblingIndex < result.getIndex()) {
                childNode.insertEntry(node.entryAt(siblingIndex), 0);
                node.removeEntry(siblingIndex);
                node.insertEntry(siblingNode.entryAt(siblingNode.size() - 1), siblingIndex);
                siblingNode.removeEntry(siblingNode.size() - 1);
                if (!siblingNode.isLeaf()) {
                    childNode.insertChild(siblingNode.childAt(siblingNode.size()), 0);
                    siblingNode.removeChild(siblingNode.size());
                }
            } else {
                childNode.insertEntry(node.entryAt(result.getIndex()), childNode.size() - 1);
                node.removeEntry(result.getIndex());
                node.insertEntry(siblingNode.entryAt(0), result.getIndex());
                siblingNode.removeEntry(0);
                if (!siblingNode.isLeaf()) {
                    childNode.addChild(siblingNode.childAt(0));
                    siblingNode.removeChild(0);
                }
            }
            return this.delete(childNode, key);
        }
        if (result.getIndex() < node.size()) {
            int i;
            BTreeNode rightSiblingNode = node.childAt(result.getIndex() + 1);
            childNode.addEntry(node.entryAt(result.getIndex()));
            node.removeEntry(result.getIndex());
            node.removeChild(result.getIndex() + 1);
            for (i = 0; i < rightSiblingNode.size(); ++i) {
                childNode.addEntry(rightSiblingNode.entryAt(i));
            }
            if (!rightSiblingNode.isLeaf()) {
                for (i = 0; i <= rightSiblingNode.size(); ++i) {
                    childNode.addChild(rightSiblingNode.childAt(i));
                }
            }
        } else {
            int i;
            BTreeNode leftSiblingNode = node.childAt(result.getIndex() - 1);
            childNode.insertEntry(node.entryAt(result.getIndex() - 1), 0);
            node.removeEntry(result.getIndex() - 1);
            node.removeChild(result.getIndex() - 1);
            for (i = leftSiblingNode.size() - 1; i >= 0; --i) {
                childNode.insertEntry(leftSiblingNode.entryAt(i), 0);
            }
            if (!leftSiblingNode.isLeaf()) {
                for (i = leftSiblingNode.size(); i >= 0; --i) {
                    childNode.insertChild(leftSiblingNode.childAt(i), 0);
                }
            }
        }
        if (node == this.root && node.size() == 0) {
            this.root = childNode;
        }
        return this.delete(childNode, key);
    }

    public void output() {
        LinkedList<BTreeNode> queue = new LinkedList<BTreeNode>();
        queue.offer(this.root);
        while (!queue.isEmpty()) {
            int i;
            BTreeNode node = (BTreeNode)queue.poll();
            for (i = 0; i < node.size(); ++i) {
                System.out.print(node.entryAt(i) + " |");
            }
            System.out.println();
            if (node.isLeaf()) continue;
            for (i = 0; i <= node.size(); ++i) {
                queue.offer(node.childAt(i));
            }
        }
    }
}

