/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.linkmanage;

import cn.hutool.core.bean.BeanUtil;
import com.github.pagehelper.PageInfo;
import com.pamirs.tro.entity.domain.query.whitelist.WhiteListCreateListVO;
import com.pamirs.tro.entity.domain.query.whitelist.WhiteListOperateVO;
import com.pamirs.tro.entity.domain.query.whitelist.WhiteListQueryVO;
import io.shulie.tro.common.beans.annotation.ModuleDef;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.input.whitelist.WhitelistUpdatePartAppNameInput;
import io.shulie.tro.web.app.request.WhiteListDeleteRequest;
import io.shulie.tro.web.app.request.whitelist.WhiteListUpdateRequest;
import io.shulie.tro.web.app.request.whitelist.WhitelistUpdatePartAppNameRequest;
import io.shulie.tro.web.app.response.whitelist.WhitelistStringResponse;
import io.shulie.tro.web.app.service.linkManage.WhiteListService;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.shulie.tro.web.common.vo.whitelist.WhiteListVO;
import io.shulie.tro.web.common.vo.whitelist.WhitelistPartVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/"})
@Api(tags={"\u767d\u540d\u5355\u7ba1\u7406\u63a5\u53e3"}, value="\u767d\u540d\u5355\u7ba1\u7406\u63a5\u53e3")
public class WhiteListConfigController {
    private static final Logger log = LoggerFactory.getLogger(WhiteListConfigController.class);
    @Autowired
    private WhiteListService whiteListService;

    @ApiOperation(value="\u767d\u540d\u5355\u6dfb\u52a0\u63a5\u53e3")
    @PostMapping(value={"/application/whitelist"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u767d\u540d\u5355", logMsgKey="message.white_list.create")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.CREATE)
    public Response<Void> saveWhitelist(@RequestBody WhiteListCreateListVO vo) {
        OperationLogContextHolder.operationType((String)"\u65b0\u589e");
        OperationLogContextHolder.addVars((String)"interface", (String)(vo.getInterfaceList() + ""));
        OperationLogContextHolder.addVars((String)"interfaceType", (String)(vo.getInterfaceType() == 1 ? "HTTP" : (vo.getInterfaceType() == 2 ? "DUBBO" : "RABBITMQ")));
        if (CollectionUtils.isEmpty((Collection)vo.getInterfaceList())) {
            return Response.success();
        }
        this.whiteListService.saveWhitelist(vo);
        return Response.success();
    }

    @ApiOperation(value="\uff08\u6279\u91cf\uff09\u52a0\u5165/\u53d6\u6d88\u767d\u540d\u5355\u63a5\u53e3")
    @PutMapping(value={"/application/whitelist"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u767d\u540d\u5355", logMsgKey="message.white_list.add_remove")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.ENABLE_DISABLE)
    public Response<Void> operateWhitelist(@RequestBody @Valid WhiteListOperateVO vo) {
        OperationLogContextHolder.operationType((String)(vo.getType() == 0 ? "\u79fb\u9664" : "\u52a0\u5165"));
        ArrayList interfaceName = new ArrayList();
        if (null != vo.getIds()) {
            vo.getIds().forEach(id -> {
                String[] splits = id.split("@@");
                interfaceName.add(splits[0]);
            });
        }
        OperationLogContextHolder.addVars((String)"interface", (String)(interfaceName + ""));
        this.whiteListService.operateWhitelist(vo);
        return Response.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u767d\u540d\u5355\u63a5\u53e3")
    @GetMapping(value={"/application/whitelist"})
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.QUERY)
    public Response<List<WhiteListVO>> listWhitelist(WhiteListQueryVO vo) {
        return Response.success((PageInfo)this.whiteListService.queryWhitelist(vo));
    }

    @PutMapping(value={"/application/whitelist/update"})
    @ApiOperation(value="\u7f16\u8f91\u767d\u540d\u5355\u63a5\u53e3")
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u767d\u540d\u5355", logMsgKey="message.white_list.update")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.UPDATE)
    public Response<Void> updateWhitelist(@Validated @RequestBody WhiteListUpdateRequest request) {
        OperationLogContextHolder.operationType((String)"\u7f16\u8f91");
        this.whiteListService.updateWhitelist(request);
        return Response.success();
    }

    @ApiOperation(value="\u5220\u9664\u767d\u540d\u5355\u63a5\u53e3")
    @DeleteMapping(value={"/application/whitelist"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u767d\u540d\u5355", logMsgKey="message.white_list.delete")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.DELETE)
    public Response<Void> deleteWhitelist(@RequestBody @Valid WhiteListDeleteRequest request) {
        OperationLogContextHolder.operationType((String)"\u5220\u9664");
        this.whiteListService.deleteWhitelist(request);
        return Response.success();
    }

    @ApiOperation(value="\u5c40\u90e8\u751f\u6548\u5e94\u7528\u6570\u636e")
    @GetMapping(value={"/application/part"})
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.QUERY)
    public WhitelistPartVO getPart(@RequestParam(value="wlistId") Long wlistId) {
        return this.whiteListService.getPart(wlistId);
    }

    @ApiOperation(value="\u90e8\u5206\u751f\u6548")
    @PostMapping(value={"/application/part"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u767d\u540d\u5355", logMsgKey="message.white_list.update")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.UPDATE)
    public WhitelistStringResponse part(@RequestBody WhitelistUpdatePartAppNameRequest request) {
        WhitelistUpdatePartAppNameInput input = new WhitelistUpdatePartAppNameInput();
        BeanUtil.copyProperties((Object)request, (Object)input, (String[])new String[0]);
        this.whiteListService.part(input);
        return new WhitelistStringResponse("\u751f\u6548\u5e94\u7528\u4fdd\u5b58\u6210\u529f");
    }

    @ApiOperation(value="\u5168\u5c40\u751f\u6548")
    @GetMapping(value={"/application/global"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u767d\u540d\u5355", logMsgKey="message.white_list.update")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.UPDATE)
    public WhitelistStringResponse global(@RequestParam(value="wlistId") Long wlistId) {
        this.whiteListService.global(wlistId);
        return new WhitelistStringResponse("\u5168\u5c40\u751f\u6548\u6210\u529f");
    }
}

