/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.linkmanage;

import com.pamirs.tro.entity.domain.dto.linkmanage.BusinessActiveIdAndNameDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.MiddleWareNameDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.SystemProcessIdAndNameDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.linkstatistics.LinkHistoryInfoDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.linkstatistics.LinkRemarkDto;
import com.pamirs.tro.entity.domain.dto.linkmanage.linkstatistics.LinkRemarkmiddleWareDto;
import com.pamirs.tro.entity.domain.entity.linkmanage.MiddleWareDistinctVo;
import com.pamirs.tro.entity.domain.entity.linkmanage.statistics.StatisticsQueryVo;
import com.pamirs.tro.entity.domain.vo.linkmanage.MiddleWareEntity;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.response.linkmanage.BusinessActivityNameResponse;
import io.shulie.tro.web.app.service.linkManage.LinkManageService;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/"})
@Api(tags={"linkmanage"}, value="\u94fe\u8def\u6807\u6ce8")
@Deprecated
public class LinkManageController {
    @Autowired
    private LinkManageService linkManageService;

    @GetMapping(value={"/link/statistic"})
    @ApiOperation(value="\u94fe\u8def\u7edf\u8ba1")
    public Response<LinkRemarkDto> getstatisticsInfo() {
        LinkRemarkDto dto = this.linkManageService.getstatisticsInfo();
        return Response.success((Object)dto);
    }

    @GetMapping(value={"/link/statistic/middleware"})
    @ApiOperation(value="\u94fe\u8def\u7edf\u8ba1\u4e2d\u95f4\u4ef6\u4fe1\u606f\u67e5\u8be2")
    public Response<List<LinkRemarkmiddleWareDto>> getMiddleWareInfo(StatisticsQueryVo vo) {
        return this.linkManageService.getMiddleWareInfo(vo);
    }

    @GetMapping(value={"/link/statistic/chart"})
    @ApiOperation(value="\u8d8b\u52bf\u56fe\u62c9\u53d6\u63a5\u53e3")
    public Response<LinkHistoryInfoDto> getChart() {
        LinkHistoryInfoDto dto = this.linkManageService.getChart();
        return Response.success((Object)dto);
    }

    @GetMapping(value={"/link/linkmanage/middleware"})
    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5e93\u4e2d\u6240\u6709\u4e2d\u95f4\u4ef6\u7c7b\u578b")
    public Response<List<MiddleWareEntity>> getAllMiddleWareTypeList() {
        try {
            List list = this.linkManageService.getAllMiddleWareTypeList();
            return Response.success((Object)list);
        }
        catch (Exception e) {
            return Response.fail((String)"0", (String)e.getMessage(), null);
        }
    }

    @GetMapping(value={"/link/tech/linkmanage/all"})
    @ApiOperation(value="\u7cfb\u7edf\u6d41\u7a0b\u540d\u5b57\u548cid\u7684\u6a21\u7cca\u641c\u7d22,\u4e0d\u4f20\u6570\u636e\u5219\u5168\u90e8\u641c\u7d22")
    @AuthVerification(moduleCode="systemFlow", needAuth=ActionTypeEnum.QUERY)
    public Response<List<SystemProcessIdAndNameDto>> systemProcessFuzzSearch(@ApiParam(name="systemProcessName", value="\u7cfb\u7edf\u6d41\u7a0b\u540d\u5b57") String systemProcessName) {
        try {
            List dto = this.linkManageService.ggetAllSystemProcess(systemProcessName);
            return Response.success((Object)dto);
        }
        catch (Exception e) {
            return Response.fail((String)"0", (String)e.getMessage(), null);
        }
    }

    @GetMapping(value={"/link/tech/linkmanage/canRelate/all"})
    @ApiOperation(value="\u7cfb\u7edf\u6d41\u7a0b\u540d\u5b57\u548cid\u7684\u6a21\u7cca\u641c\u7d22,\u4e0d\u4f20\u6570\u636e\u5219\u5168\u90e8\u641c\u7d22")
    public Response<List<SystemProcessIdAndNameDto>> systemProcessFuzzSearch2(@ApiParam(name="systemProcessName", value="\u7cfb\u7edf\u6d41\u7a0b\u540d\u5b57") String systemProcessName) {
        try {
            List dto = this.linkManageService.getAllSystemProcessCanrelateBusiness(systemProcessName);
            return Response.success((Object)dto);
        }
        catch (Exception e) {
            return Response.fail((String)"0", (String)e.getMessage(), null);
        }
    }

    @GetMapping(value={"/link/entrance"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u5165\u53e3")
    public Response<List<String>> entranceFuzzSerach(@ApiParam(name="entrance", value="\u5165\u53e3\u540d") String entrance) {
        try {
            List result = this.linkManageService.entranceFuzzSerach(entrance);
            return Response.success((Object)result);
        }
        catch (Exception e) {
            return Response.fail((String)"0", (String)e.getMessage(), null);
        }
    }

    @GetMapping(value={"/link/bussinessActive"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u4e1a\u52a1\u6d3b\u52a8\u540d\u5b57\u548cid")
    @AuthVerification(moduleCode="businessActivity", needAuth=ActionTypeEnum.QUERY)
    public Response<List<BusinessActiveIdAndNameDto>> bussinessActiveNameFuzzSearch(@ApiParam(name="bussinessActiveName", value="\u4e1a\u52a1\u6d3b\u52a8\u540d\u5b57") String bussinessActiveName) {
        try {
            List result = this.linkManageService.businessActiveNameFuzzSearch(bussinessActiveName);
            return Response.success((Object)result);
        }
        catch (Exception e) {
            return Response.fail((String)"0", (String)e.getMessage(), null);
        }
    }

    @GetMapping(value={"/link/business/manage/getBusinessActiveByFlowId"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0bid\u83b7\u53d6\u6240\u6709\u7684\u4e1a\u52a1\u6d3b\u52a8\u540d\u5b57\u548cid")
    public List<BusinessActivityNameResponse> getBusinessActiveByFlowId(Long businessFlowId) {
        return this.linkManageService.getBusinessActiveByFlowId(businessFlowId);
    }

    @PostMapping(value={"/link/scene/middlewares"})
    @ApiOperation(value="\u4e1a\u52a1\u6d41\u7a0b\u9875\u9762\u7684\u4e2d\u95f4\u4ef6\u53bb\u91cd")
    public Response<List<MiddleWareEntity>> businessProcessMiddleWares(@ApiParam(name="vo", value="\u4e1a\u52a1\u6d3b\u52a8\u4e3b\u952e\u96c6\u5408") @RequestBody MiddleWareDistinctVo vo) {
        try {
            List ids = vo.getIds();
            List lists = this.linkManageService.businessProcessMiddleWares(ids);
            return Response.success((Object)lists);
        }
        catch (Exception e) {
            return Response.fail((String)"0", (String)e.getMessage(), null);
        }
    }

    @GetMapping(value={"/link/midlleWare/cascade"})
    @ApiOperation(value="\u4e2d\u95f4\u4ef6\u7ea7\u8054\u5173\u7cfb\u62c9\u53d6")
    public Response<List<MiddleWareNameDto>> cascadeMiddleWareNameAndVersion(@ApiParam(name="middleWareType", value="\u4e2d\u95f4\u4ef6\u7c7b\u578b") String middleWareType) {
        try {
            List dtos = this.linkManageService.cascadeMiddleWareNameAndVersion(middleWareType);
            return Response.success((Object)dtos);
        }
        catch (Exception e) {
            return Response.fail((String)"0", (String)e.getMessage(), null);
        }
    }

    @GetMapping(value={"/link/middleWare/name"})
    @ApiOperation(value="\u4e2d\u95f4\u4ef6\u540d\u5b57\u53bb\u91cd")
    public Response<List<MiddleWareNameDto>> getDistinctMiddleWareName() {
        try {
            List dtos = this.linkManageService.getDistinctMiddleWareName();
            return Response.success((Object)dtos);
        }
        catch (Exception e) {
            return Response.failByType((String)"0", (String)e.getMessage(), null);
        }
    }
}

