/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.linkmanage;

import com.pamirs.tro.entity.domain.entity.LinkGuardEntity;
import com.pamirs.tro.entity.domain.query.LinkGuardQueryParam;
import com.pamirs.tro.entity.domain.vo.guardmanage.LinkGuardVo;
import io.shulie.tro.common.beans.annotation.ModuleDef;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.service.linkManage.LinkGuardService;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/console"})
@Api(tags={"\u6321\u677f\u914d\u7f6e"}, value="\u6321\u677f\u914d\u7f6e")
public class LinkGuardController {
    @Autowired
    private LinkGuardService linkGuardService;

    @ApiOperation(value="\u6321\u677f\u6dfb\u52a0\u63a5\u53e3")
    @PostMapping(value={"/link/guard/guardmanage"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u51fa\u53e3\u6321\u677f", logMsgKey="message.outlet_baffle.create")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.CREATE)
    public Response storetechLink(@RequestBody LinkGuardVo vo) {
        if (StringUtils.isNotBlank((CharSequence)vo.getRemark()) && vo.getRemark().length() > 200) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.GUARD_PARAM_ERROR, (Object)"\u5907\u6ce8\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7200\u5b57\u7b26");
        }
        OperationLogContextHolder.operationType((String)"\u65b0\u589e");
        OperationLogContextHolder.addVars((String)"classMethodName", (String)vo.getMethodInfo());
        return this.linkGuardService.addGuard(vo);
    }

    @GetMapping(value={"/link/guard/guardmanage"})
    @ApiOperation(value="\u6321\u677f\u5217\u8868\u67e5\u8be2\u63a5\u53e3")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.QUERY)
    public Response<List<LinkGuardVo>> gettGuardList(@ApiParam(name="applicationName", value="\u7cfb\u7edf\u540d\u5b57") @RequestParam(value="applicationName", required=false) String applicationName, @ApiParam(name="id", value="\u6321\u677fid") @RequestParam(value="id", required=false) Long id, @ApiParam(name="applicationId", value="\u7cfb\u7edfid") @RequestParam(value="applicationId", required=false) String applicationId, Integer current, Integer pageSize) {
        LinkGuardQueryParam param = new LinkGuardQueryParam();
        param.setId(id);
        param.setApplicationName(applicationName);
        param.setApplicationId(applicationId);
        param.setCurrentPage(current);
        param.setPageSize(pageSize);
        return this.linkGuardService.selectByExample(param);
    }

    @GetMapping(value={"/link/guard/guardmanage/all"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5f00\u542f\u7684\u6321\u677f")
    public Response<List<LinkGuardEntity>> getAllEnableGuard() {
        return this.linkGuardService.selectAll();
    }

    @GetMapping(value={"/link/guard/guardmanage/info"})
    @ApiOperation(value="\u6321\u677f\u8be6\u60c5\u63a5\u53e3")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.QUERY)
    public Response<LinkGuardVo> gettGuardInfo(@ApiParam(name="id", value="\u6321\u677fid") @RequestParam(value="id", required=true) Long id) {
        if (id == null) {
            return Response.fail((String)"0", (String)"id \u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        return this.linkGuardService.getById(id);
    }

    @ApiOperation(value="\u4fee\u6539\u6321\u677f\u63a5\u53e3")
    @PutMapping(value={"/link/guard/guardmanage"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u51fa\u53e3\u6321\u677f", logMsgKey="message.outlet_baffle.update")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.UPDATE)
    public Response modifyGuard(@RequestBody @ApiParam(name="vo", value="\u6321\u677f\u5165\u53c2\u5bf9\u8c61") LinkGuardVo vo) {
        if (StringUtils.isNotBlank((CharSequence)vo.getRemark()) && vo.getRemark().length() > 200) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.GUARD_PARAM_ERROR, (Object)"\u5907\u6ce8\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc7200\u5b57\u7b26");
        }
        OperationLogContextHolder.operationType((String)"\u7f16\u8f91");
        OperationLogContextHolder.addVars((String)"classMethodName", (String)vo.getMethodInfo());
        return this.linkGuardService.updateGuard(vo);
    }

    @ApiOperation(value="\u5220\u9664\u6321\u677f\u63a5\u53e3")
    @RequestMapping(value={"/link/guard/guardmanage"}, method={RequestMethod.DELETE})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u51fa\u53e3\u6321\u677f", logMsgKey="message.outlet_baffle.delete")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.DELETE)
    public Response deleteGuard(@RequestBody LinkGuardVo vo) {
        OperationLogContextHolder.operationType((String)"\u5220\u9664");
        LinkGuardVo linkGuardVo = this.linkGuardVo(vo.getId());
        if (null == linkGuardVo) {
            return Response.fail((String)"\u8be5\u6321\u677f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        OperationLogContextHolder.addVars((String)"classMethodName", (String)linkGuardVo.getMethodInfo());
        return this.linkGuardService.deleteById(vo.getId());
    }

    @ApiOperation(value="\u5f00\u542f\u3001\u5173\u95ed\u6321\u677f\u63a5\u53e3")
    @PutMapping(value={"/link/guard/guardmanage/switch"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u51fa\u53e3\u6321\u677f", logMsgKey="message.outlet_baffle.enable_disable")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.ENABLE_DISABLE)
    public Response guard(@RequestBody LinkGuardVo vo) {
        OperationLogContextHolder.operationType((String)(vo.getIsEnable() != false ? "\u542f\u7528" : "\u7981\u7528"));
        LinkGuardVo linkGuardVo = this.linkGuardVo(vo.getId());
        if (null == linkGuardVo) {
            return Response.fail((String)"\u8be5\u6321\u677f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        OperationLogContextHolder.addVars((String)"classMethodName", (String)linkGuardVo.getMethodInfo());
        return this.linkGuardService.enableGuard(vo.getId(), vo.getIsEnable());
    }

    private LinkGuardVo linkGuardVo(Long id) {
        Response linkGuardVo = this.linkGuardService.getById(id);
        if (null == linkGuardVo) {
            return null;
        }
        LinkGuardVo data = (LinkGuardVo)linkGuardVo.getData();
        return data;
    }
}

