/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.linkmanage;

import com.pamirs.tro.common.enums.ds.DbTypeEnum;
import com.pamirs.tro.entity.dao.confcenter.TApplicationMntDao;
import com.pamirs.tro.entity.dao.user.TUserMapper;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import com.pamirs.tro.entity.domain.entity.simplify.AppBusinessTableInfo;
import com.pamirs.tro.entity.domain.entity.user.User;
import com.pamirs.tro.entity.domain.query.agent.AppBusinessTableQuery;
import io.shulie.tro.common.beans.annotation.ModuleDef;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.request.application.ApplicationDsCreateRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsDeleteRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsEnableRequest;
import io.shulie.tro.web.app.request.application.ApplicationDsUpdateRequest;
import io.shulie.tro.web.app.response.application.ApplicationDsDetailResponse;
import io.shulie.tro.web.app.service.dsManage.DsService;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/"})
@Api(tags={"\u5f71\u5b50\u5e93\u8868\u7ba1\u7406"}, value="\u5f71\u5b50\u5e93\u8868\u7ba1\u7406")
public class DsController {
    private static final Logger log = LoggerFactory.getLogger(DsController.class);
    @Value(value="${application.ds.config.is.new.version: false}")
    private Boolean isNewVersion;
    private static final String DATABASE = "\u5f71\u5b50\u5e93 URL\uff1a";
    private static final String TABLE = "\u5f71\u5b50\u8868 URL\uff1a";
    private static final String SERVER = "\u5f71\u5b50server URL\uff1a";
    @Autowired
    private DsService dsService;
    @Resource
    private TApplicationMntDao applicationMntDao;
    @Resource
    private TUserMapper TUserMapper;

    @ApiOperation(value="\u5f71\u5b50\u5e93\u8868\u6dfb\u52a0\u63a5\u53e3")
    @PostMapping(value={"link/ds/manage"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u5f71\u5b50\u5e93\u8868", logMsgKey="message.shadow_database_table.create", opTypes="\u65b0\u589e")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.CREATE)
    public Response dsAdd(@RequestBody ApplicationDsCreateRequest createRequest) {
        return this.dsService.dsAdd(createRequest);
    }

    @ApiOperation(value="\u5f71\u5b50\u5e93\u8868\u6dfb\u52a0\u63a5\u53e3-\u8001\u7248\u672c")
    @PostMapping(value={"link/ds/manage/old"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u5f71\u5b50\u5e93\u8868", logMsgKey="message.shadow_database_table.create", opTypes="\u65b0\u589e")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.CREATE)
    public Response dsAddOld(@RequestBody ApplicationDsCreateRequest createRequest) {
        createRequest.setOldVersion(true);
        return this.dsAdd(createRequest);
    }

    @ApiOperation(value="\u52a0\u5bc6\u6570\u636e\u5e93\u6570\u636e\u6e90\u914d\u7f6e")
    @PostMapping(value={"link/ds/manage/secure/init"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u5f71\u5b50\u5e93\u8868", logMsgKey="message.shadow_database_table.update", opTypes="\u7f16\u8f91")
    public Response secureInit() {
        return this.dsService.secureInit();
    }

    @ApiOperation(value="\u67e5\u8be2\u5f71\u5b50\u5e93\u8868\u914d\u7f6e")
    @GetMapping(value={"link/ds/manage"})
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.QUERY)
    public Response dsQuery(@RequestParam(value="applicationId", required=true) Long applicationId) {
        return this.dsService.dsQuery(applicationId);
    }

    @ApiOperation(value="\u5f71\u5b50\u5e93\u8868\u914d\u7f6e\u8be6\u60c5")
    @GetMapping(value={"link/ds/manage/detail"})
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.UPDATE)
    public Response dsQueryDetail(@RequestParam(value="id") Long dsId) {
        return this.dsService.dsQueryDetail(dsId, false);
    }

    @ApiOperation(value="\u5f71\u5b50\u5e93\u8868\u914d\u7f6e\u8be6\u60c5-\u8001\u7248\u672c")
    @GetMapping(value={"link/ds/manage/detail/old"})
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.UPDATE)
    public Response dsQueryDetailOld(@RequestParam(value="id", required=true) Long id) {
        return this.dsService.dsQueryDetail(id, true);
    }

    @ApiOperation(value="\u4fee\u6539\u5f71\u5b50\u5e93\u8868\u914d\u7f6e")
    @PutMapping(value={"link/ds/manage"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u5f71\u5b50\u5e93\u8868", logMsgKey="message.shadow_database_table.update", opTypes="\u7f16\u8f91")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.UPDATE)
    public Response dsUpdate(@RequestBody ApplicationDsUpdateRequest updateRequest) {
        return this.dsService.dsUpdate(updateRequest);
    }

    @ApiOperation(value="\u4fee\u6539\u5f71\u5b50\u5e93\u8868\u914d\u7f6e-\u8001\u7248\u672c")
    @PutMapping(value={"link/ds/manage/old"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u5f71\u5b50\u5e93\u8868", logMsgKey="message.shadow_database_table.update")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.UPDATE)
    public Response dsUpdateOld(@RequestBody ApplicationDsUpdateRequest updateRequest) {
        updateRequest.setOldVersion(true);
        return this.dsUpdate(updateRequest);
    }

    @ApiOperation(value="\u542f\u7528\u7981\u7528\u5f71\u5b50\u5e93\u8868\u914d\u7f6e")
    @PutMapping(value={"link/ds/enable"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u5f71\u5b50\u5e93\u8868", logMsgKey="message.shadow_database_table.enable_disable")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.ENABLE_DISABLE)
    public Response enableConfig(@RequestBody ApplicationDsEnableRequest enableRequest) {
        OperationLogContextHolder.operationType((String)(Integer.valueOf(0).equals(enableRequest.getStatus()) ? "\u542f\u7528" : "\u7981\u7528"));
        Response response = this.dsService.dsQueryDetail(enableRequest.getId(), false);
        if (null == response) {
            return Response.fail((String)"\u5f71\u5b50\u5e93\u8868\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationDsDetailResponse data = (ApplicationDsDetailResponse)response.getData();
        return this.dsService.enableConfig(enableRequest);
    }

    @ApiOperation(value="\u5220\u9664\u5f71\u5b50\u5e93\u8868\u914d\u7f6e")
    @RequestMapping(value={"link/ds/manage"}, method={RequestMethod.DELETE})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u5f71\u5b50\u5e93\u8868", logMsgKey="message.shadow_database_table.delete", opTypes="\u5220\u9664")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.DELETE)
    public Response dsDelete(@RequestBody ApplicationDsDeleteRequest deleteRequest) {
        Response response = this.dsService.dsQueryDetail(deleteRequest.getId(), false);
        if (!response.getSuccess().booleanValue()) {
            return response;
        }
        ApplicationDsDetailResponse data = (ApplicationDsDetailResponse)response.getData();
        return this.dsService.dsDelete(deleteRequest);
    }

    @ApiOperation(value="agent\u4e0a\u4f20\u5f71\u5b50\u8868")
    @PostMapping(value={"link/ds/agent/report"})
    public Response reportTable(@RequestBody Map<String, Set<String>> requestMap, @RequestParam(value="appName") String appName) {
        if (null == requestMap || requestMap.size() < 1) {
            return Response.fail((String)"\u8bf7\u6c42\u6570\u636enull", (Object[])new Object[0]);
        }
        User user = this.TUserMapper.queryByKey(RestContext.getTenantUserKey());
        if (null == user) {
            return Response.fail((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        TApplicationMnt tApplicationMnt = this.applicationMntDao.queryApplicationinfoByNameTenant(appName, user.getId());
        if (null == tApplicationMnt) {
            return Response.fail((String)"\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        try {
            for (Map.Entry<String, Set<String>> entry : requestMap.entrySet()) {
                StringBuilder tablesBuilder = new StringBuilder();
                String url = entry.getKey();
                for (String table : entry.getValue()) {
                    tablesBuilder.append(table).append(",");
                }
                String table = tablesBuilder.toString();
                if (table.contains(",")) {
                    table = table.substring(0, table.length() - 1);
                }
                ApplicationDsCreateRequest createRequest = new ApplicationDsCreateRequest();
                createRequest.setApplicationId(Long.valueOf(tApplicationMnt.getApplicationId()));
                createRequest.setApplicationName(tApplicationMnt.getApplicationName());
                createRequest.setDbType(DbTypeEnum.DB.getCode());
                createRequest.setDsType(Integer.valueOf(1));
                createRequest.setConfig(table);
                createRequest.setUrl(url);
                this.dsService.dsAdd(createRequest);
                AppBusinessTableInfo info = new AppBusinessTableInfo();
                info.setUrl(url);
                info.setTableName(table);
                info.setApplicationId(Long.valueOf(tApplicationMnt.getApplicationId()));
                info.setUserId(user.getId());
                this.dsService.addBusiness(info);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
        return Response.success();
    }

    @ApiOperation(value="\u67e5\u8be2agent\u4e0a\u4f20\u4e1a\u52a1\u8868\u4fe1\u606f")
    @GetMapping(value={"link/ds/business/query"})
    public Response queryPage(@RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="applicationId") Long applicationId) {
        try {
            AppBusinessTableQuery query = new AppBusinessTableQuery();
            query.setPageNum(pageNum.intValue());
            query.setPageSize(pageSize.intValue());
            query.setApplicationId(applicationId);
            return this.dsService.queryPageBusiness(query);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
    }
}

