/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.linkmanage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pamirs.tro.entity.dao.dict.TDictionaryDataMapper;
import com.pamirs.tro.entity.domain.dto.linkmanage.mapping.EnumResult;
import com.pamirs.tro.entity.domain.dto.linkmanage.mapping.HttpTypeEnumMapping;
import com.pamirs.tro.entity.domain.dto.linkmanage.mapping.LinkChangeEnumMapping;
import com.pamirs.tro.entity.domain.dto.linkmanage.mapping.LinkChangeTypeEnumMapping;
import com.pamirs.tro.entity.domain.dto.linkmanage.mapping.LinkLevelEnumMapping;
import com.pamirs.tro.entity.domain.dto.linkmanage.mapping.LinkTypeEnumMapping;
import com.pamirs.tro.entity.domain.dto.linkmanage.mapping.fastdebug.DebugHttpTypeEnumMapping;
import com.pamirs.tro.entity.domain.dto.linkmanage.mapping.fastdebug.DebugRequestTypeEnumMapping;
import com.pamirs.tro.entity.domain.vo.TDictionaryVo;
import io.shulie.tro.web.app.constant.BizOpConstants;
import io.shulie.tro.web.data.dao.user.TroResourceDAO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DictionaryCache {
    private static Map<String, List<EnumResult>> dicMap = Maps.newHashMap();
    @Resource
    private TDictionaryDataMapper tDictionaryDataMapper;
    @Autowired
    private TroResourceDAO troResourceDAO;

    public static EnumResult getObjectByParam(String key, Integer valueCode) {
        return DictionaryCache.getObjectByParam((String)key, (String)String.valueOf(valueCode));
    }

    public static EnumResult getObjectByParamByLabel(String key, String label) {
        if (key == null || label == null) {
            return null;
        }
        List dataList = (List)dicMap.get(key);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return null;
        }
        return dataList.stream().filter(data -> data.getLabel().equals(label)).findFirst().orElse(null);
    }

    public static EnumResult getObjectByParam(String key, String valueCode) {
        if (key == null || valueCode == null) {
            return null;
        }
        List dataList = (List)dicMap.get(key);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return null;
        }
        EnumResult result = dataList.stream().filter(data -> data.getValue().equals(valueCode)).findFirst().orElse(null);
        if (result == null) {
            // empty if block
        }
        return result;
    }

    @PostConstruct
    public void initDictionary() {
        dicMap.put("link_level", LinkLevelEnumMapping.neededEnumResults());
        dicMap.put("isCore", LinkTypeEnumMapping.neededEnumResults());
        dicMap.put("isChange", LinkChangeEnumMapping.neededEnumResults());
        dicMap.put("changeType", LinkChangeTypeEnumMapping.neededEnumResults());
        dicMap.put("http_type", HttpTypeEnumMapping.neededEnumResults());
        dicMap.put("DEBUG_REQUEST_TYPE", DebugHttpTypeEnumMapping.neededEnumResults());
        dicMap.put("DEBUG_HTTP_TYPE", DebugRequestTypeEnumMapping.neededEnumResults());
        this.fillDictFromDB();
    }

    @PostConstruct
    public void initMenu() {
        List resourceMenuResultList = this.troResourceDAO.selectAuthConfigMenu();
        if (CollectionUtils.isNotEmpty((Collection)resourceMenuResultList)) {
            resourceMenuResultList.forEach(menuResult -> BizOpConstants.modelNameMap.put(menuResult.getCode(), menuResult.getName()));
        }
    }

    private void fillDictFromDB() {
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("valueActive", "Y");
        List voList = this.tDictionaryDataMapper.queryDictionaryList((Map)paramMap);
        if (CollectionUtils.isEmpty((Collection)voList)) {
            return;
        }
        Map<String, List<TDictionaryVo>> groupMap = voList.stream().collect(Collectors.groupingBy(TDictionaryVo::getTypeAlias));
        groupMap.forEach((key, value) -> {
            ArrayList resultList = Lists.newArrayList();
            value.forEach(data -> {
                EnumResult result = new EnumResult();
                try {
                    result.setNum(Integer.valueOf(Integer.parseInt(data.getValueOrder())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                result.setLabel(data.getValueName());
                result.setValue(data.getValueCode());
                result.setDisable(Boolean.valueOf("N".equalsIgnoreCase(data.getValueActive())));
                resultList.add(result);
            });
            dicMap.put(key, resultList);
        });
    }

    public Map<String, List<EnumResult>> getDicMap() {
        return dicMap;
    }
}

