/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.linkmanage;

import io.shulie.tro.common.beans.annotation.ModuleDef;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.exception.entity.ExceptionReadable;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.exception.ExceptionCode;
import io.shulie.tro.web.app.exception.TroWebException;
import io.shulie.tro.web.app.input.blacklist.BlacklistCreateInput;
import io.shulie.tro.web.app.input.blacklist.BlacklistSearchInput;
import io.shulie.tro.web.app.input.blacklist.BlacklistUpdateInput;
import io.shulie.tro.web.app.output.blacklist.BlacklistOutput;
import io.shulie.tro.web.app.request.blacklist.BlacklistBatchDeleteRequest;
import io.shulie.tro.web.app.request.blacklist.BlacklistBatchEnableRequest;
import io.shulie.tro.web.app.request.blacklist.BlacklistCreateRequest;
import io.shulie.tro.web.app.request.blacklist.BlacklistDeleteRequest;
import io.shulie.tro.web.app.request.blacklist.BlacklistEnableRequest;
import io.shulie.tro.web.app.request.blacklist.BlacklistSearchRequest;
import io.shulie.tro.web.app.request.blacklist.BlacklistUpdateRequest;
import io.shulie.tro.web.app.response.blacklist.BlacklistDetailResponse;
import io.shulie.tro.web.app.response.blacklist.BlacklistStringResponse;
import io.shulie.tro.web.app.service.blacklist.BlacklistService;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.shulie.tro.web.common.enums.blacklist.BlacklistEnableEnum;
import io.shulie.tro.web.common.enums.blacklist.BlacklistTypeEnum;
import io.shulie.tro.web.common.vo.blacklist.BlacklistVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u65b0\u7248\u9ed1\u540d\u5355\u63a5\u53e3"}, value="\u9ed1\u540d\u5355")
@RestController
@RequestMapping(value={"/api/application/blacklist"})
public class BlacklistConfigController {
    @Autowired
    private BlacklistService blacklistService;

    @ApiOperation(value="\u6dfb\u52a0\u9ed1\u540d\u5355\u63a5\u53e3")
    @PostMapping(value={""}, produces={"application/json;charset=UTF-8"})
    @ModuleDef(moduleName="\u914d\u7f6e\u4e2d\u5fc3", subModuleName="\u9ed1\u540d\u5355", logMsgKey="message.blacklist.create")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.CREATE)
    public BlacklistStringResponse add(@RequestBody @Valid BlacklistCreateRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getRedisKey()) || StringUtils.isBlank((CharSequence)request.getRedisKey().trim())) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.BLACKLIST_ADD_ERROR, (Object)"\u4e0d\u5141\u8bb8\u586b\u5199\u7a7a\u9ed1\u540d\u5355");
        }
        OperationLogContextHolder.operationType((String)"\u65b0\u589e");
        OperationLogContextHolder.addVars((String)"blacklistType", (String)BlacklistTypeEnum.getDescByType((Integer)0));
        OperationLogContextHolder.addVars((String)"blacklistValue", (String)request.getRedisKey());
        BlacklistCreateInput input = new BlacklistCreateInput();
        BeanUtils.copyProperties((Object)request, (Object)input);
        this.blacklistService.insert(input);
        return new BlacklistStringResponse("\u65b0\u589e\u6210\u529f");
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u9ed1\u540d\u5355\u5217\u8868")
    @GetMapping(value={"/list"}, produces={"application/json;charset=UTF-8"})
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.QUERY)
    public PagingList<BlacklistVO> pageList(BlacklistSearchRequest request) {
        BlacklistSearchInput input = new BlacklistSearchInput();
        BeanUtils.copyProperties((Object)request, (Object)input);
        return this.blacklistService.pageList(input);
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u9ed1\u540d\u5355\u8be6\u60c5\u63a5\u53e3")
    @GetMapping(value={""}, produces={"application/json;charset=UTF-8"})
    public BlacklistDetailResponse querySingleById(@RequestParam(value="id") Long id) {
        BlacklistDetailResponse response = new BlacklistDetailResponse();
        BlacklistOutput output = this.blacklistService.selectById(id);
        if (output == null) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.BLACKLIST_SEARCH_ERROR, (Object)"\u672a\u67e5\u5230\u8be5id");
        }
        BeanUtils.copyProperties((Object)output, (Object)response);
        return response;
    }

    @ApiOperation(value="\u6839\u636eid\u66f4\u65b0\u9ed1\u540d\u5355\u63a5\u53e3")
    @PutMapping(value={""}, produces={"application/json;charset=UTF-8"})
    @ModuleDef(moduleName="\u914d\u7f6e\u4e2d\u5fc3", subModuleName="\u9ed1\u540d\u5355", logMsgKey="message.blacklist.update")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.UPDATE)
    public BlacklistStringResponse update(@RequestBody BlacklistUpdateRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getRedisKey()) || StringUtils.isBlank((CharSequence)request.getRedisKey().trim())) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.BLACKLIST_UPDATE_ERROR, (Object)"\u4e0d\u5141\u8bb8\u586b\u5199\u7a7a\u9ed1\u540d\u5355");
        }
        OperationLogContextHolder.operationType((String)"\u7f16\u8f91");
        OperationLogContextHolder.addVars((String)"blacklistType", (String)BlacklistTypeEnum.getDescByType((Integer)0));
        OperationLogContextHolder.addVars((String)"blacklistValue", (String)request.getRedisKey().trim());
        BlacklistUpdateInput input = new BlacklistUpdateInput();
        BeanUtils.copyProperties((Object)request, (Object)input);
        input.setRedisKey(input.getRedisKey().trim());
        this.blacklistService.update(input);
        return new BlacklistStringResponse("\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="\u6839\u636eid\u542f\u7528\u7981\u7528\u9ed1\u540d\u5355\u63a5\u53e3")
    @PutMapping(value={"/enable"}, produces={"application/json;charset=UTF-8"})
    @ModuleDef(moduleName="\u914d\u7f6e\u4e2d\u5fc3", subModuleName="\u9ed1\u540d\u5355", logMsgKey="message.blacklist.action")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.ENABLE_DISABLE)
    public BlacklistStringResponse enable(@RequestBody @Valid BlacklistEnableRequest request) {
        String operationType = BlacklistEnableEnum.ENABLE.getStatus().equals(request.getUseYn()) ? "\u542f\u7528" : "\u7981\u7528";
        OperationLogContextHolder.operationType((String)operationType);
        BlacklistUpdateInput input = new BlacklistUpdateInput();
        BeanUtils.copyProperties((Object)request, (Object)input);
        this.blacklistService.enable(input);
        return new BlacklistStringResponse(operationType + "\u6210\u529f");
    }

    @ApiOperation(value="\u6279\u91cf\u542f\u7528\u7981\u7528\u9ed1\u540d\u5355\u63a5\u53e3")
    @PutMapping(value={"list/enable"}, produces={"application/json;charset=UTF-8"})
    @ModuleDef(moduleName="\u914d\u7f6e\u4e2d\u5fc3", subModuleName="\u9ed1\u540d\u5355", logMsgKey="message.blacklist.batch.action")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.ENABLE_DISABLE)
    public BlacklistStringResponse listEnable(@RequestBody BlacklistBatchEnableRequest request) {
        String operationType = BlacklistEnableEnum.ENABLE.getStatus().equals(request.getUseYn()) ? "\u542f\u7528" : "\u7981\u7528";
        this.blacklistService.batchEnable(request.getIds(), request.getUseYn());
        return new BlacklistStringResponse("\u6279\u91cf" + operationType + "\u6210\u529f");
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u9ed1\u540d\u5355\u63a5\u53e3")
    @DeleteMapping(value={"/list"}, produces={"application/json;charset=UTF-8"})
    @ModuleDef(moduleName="\u914d\u7f6e\u4e2d\u5fc3", subModuleName="\u9ed1\u540d\u5355", logMsgKey="message.blacklist.batch.delete")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.DELETE)
    public BlacklistStringResponse batchDelete(@RequestBody @Valid BlacklistBatchDeleteRequest request) {
        if (request.getIds() == null || request.getIds().size() == 0) {
            throw new TroWebException((ExceptionReadable)ExceptionCode.BLACKLIST_DELETE_ERROR, (Object)"id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OperationLogContextHolder.operationType((String)"\u5220\u9664");
        this.blacklistService.batchDelete(request.getIds());
        return new BlacklistStringResponse("\u6279\u91cf\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u5355\u4e2a\u5220\u9664\u9ed1\u540d\u5355\u63a5\u53e3")
    @DeleteMapping(value={""}, produces={"application/json;charset=UTF-8"})
    @ModuleDef(moduleName="\u914d\u7f6e\u4e2d\u5fc3", subModuleName="\u9ed1\u540d\u5355", logMsgKey="message.blacklist.delete")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.DELETE)
    public BlacklistStringResponse delete(@RequestBody @Valid BlacklistDeleteRequest request) {
        OperationLogContextHolder.operationType((String)"\u5220\u9664");
        this.blacklistService.delete(request.getId());
        return new BlacklistStringResponse("\u5220\u9664\u6210\u529f");
    }
}

