/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.linkmanage;

import com.pamirs.tro.entity.domain.vo.entracemanage.ApiCreateVo;
import com.pamirs.tro.entity.domain.vo.entracemanage.ApiDeleteVo;
import com.pamirs.tro.entity.domain.vo.entracemanage.ApiUpdateVo;
import com.pamirs.tro.entity.domain.vo.entracemanage.EntranceApiVo;
import io.shulie.tro.common.beans.annotation.ModuleDef;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.service.linkManage.ApplicationApiService;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.shulie.tro.web.common.vo.application.ApplicationApiManageVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/"})
@Api(tags={"applicationApi"}, value="\u5e94\u7528api")
public class ApplicationApiController {
    @Autowired
    private ApplicationApiService apiService;

    @ApiOperation(value="storm\u62c9\u53d6api")
    @GetMapping(value={"/api/pull"})
    public Response pull(@RequestParam(value="appName", required=false) String appName) {
        try {
            return this.apiService.pullApi(appName);
        }
        catch (Exception e) {
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/api/get"})
    @AuthVerification(moduleCode="configCenter_entryRule", needAuth=ActionTypeEnum.QUERY)
    public Response query(@ApiParam(name="applicationName", value="\u5e94\u7528\u540d") String applicationName, @ApiParam(name="api", value="\u5165\u53e3\u540d") String api, Integer current, Integer pageSize) {
        EntranceApiVo vo = new EntranceApiVo();
        vo.setApplicationName(applicationName);
        vo.setApi(api);
        vo.setPageSize(pageSize);
        vo.setCurrentPage(current);
        try {
            return this.apiService.query(vo);
        }
        catch (Exception e) {
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/api/delete"})
    @ModuleDef(moduleName="\u914d\u7f6e\u4e2d\u5fc3", subModuleName="\u5165\u53e3\u89c4\u5219", logMsgKey="message.entryrule.delete")
    @AuthVerification(moduleCode="configCenter_entryRule", needAuth=ActionTypeEnum.DELETE)
    public Response delete(@RequestBody ApiDeleteVo vo) {
        OperationLogContextHolder.operationType((String)"\u5220\u9664");
        Response response = this.apiService.queryDetail(vo.getId());
        ApplicationApiManageVO apiManageDto = (ApplicationApiManageVO)response.getData();
        if (Objects.isNull(apiManageDto)) {
            return Response.fail((String)"\u5165\u53e3\u89c4\u5219\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        OperationLogContextHolder.addVars((String)"applicationName", (String)apiManageDto.getApplicationName());
        OperationLogContextHolder.addVars((String)"entryApi", (String)apiManageDto.getApi());
        try {
            return this.apiService.delete(vo.getId());
        }
        catch (Exception e) {
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PutMapping(value={"/api/update"})
    @ModuleDef(moduleName="\u914d\u7f6e\u4e2d\u5fc3", subModuleName="\u5165\u53e3\u89c4\u5219", logMsgKey="message.entryrule.update")
    @AuthVerification(moduleCode="configCenter_entryRule", needAuth=ActionTypeEnum.UPDATE)
    public Response update(@RequestBody ApiUpdateVo vo) {
        OperationLogContextHolder.operationType((String)"\u7f16\u8f91");
        try {
            return this.apiService.update(vo);
        }
        catch (Exception e) {
            if (e.getMessage().contains("Duplicate")) {
                return Response.fail((String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u5165\u53e3", (Object[])new Object[0]);
            }
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/api/add"})
    @ModuleDef(moduleName="\u914d\u7f6e\u4e2d\u5fc3", subModuleName="\u5165\u53e3\u89c4\u5219", logMsgKey="message.entryrule.create")
    @AuthVerification(moduleCode="configCenter_entryRule", needAuth=ActionTypeEnum.CREATE)
    public Response add(@RequestBody ApiCreateVo vo) {
        OperationLogContextHolder.operationType((String)"\u65b0\u589e");
        OperationLogContextHolder.addVars((String)"applicationName", (String)vo.getApplicationName());
        OperationLogContextHolder.addVars((String)"entryApi", (String)vo.getApi());
        try {
            return this.apiService.create(vo);
        }
        catch (Exception e) {
            if (e.getMessage().contains("Duplicate")) {
                return Response.fail((String)"\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0", (Object[])new Object[0]);
            }
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/api/getDetail"})
    @AuthVerification(moduleCode="configCenter_entryRule", needAuth=ActionTypeEnum.QUERY)
    public Response queryDetail(@RequestParam(value="id") String id) {
        try {
            return this.apiService.queryDetail(id);
        }
        catch (Exception e) {
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
    }
}

