/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.leakverify;

import com.pamirs.tro.entity.domain.entity.user.User;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.request.leakverify.LeakVerifyTaskRunWithoutSaveRequest;
import io.shulie.tro.web.app.request.leakverify.LeakVerifyTaskStartRequest;
import io.shulie.tro.web.app.request.leakverify.LeakVerifyTaskStopRequest;
import io.shulie.tro.web.app.response.leakverify.LeakVerifyTaskResultResponse;
import io.shulie.tro.web.app.service.VerifyTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/leak/verify"})
@Api(tags={"\u6f0f\u6570\u9a8c\u8bc1\u4efb\u52a1\u7ba1\u7406"})
public class LeakVerifyTaskController {
    private static final Logger log = LoggerFactory.getLogger(LeakVerifyTaskController.class);
    @Autowired
    private VerifyTaskService verifyTaskService;

    @PostMapping(value={"/start"})
    @ApiOperation(value="\u5f00\u59cb\u5468\u671f\u6027\u9a8c\u8bc1\u4efb\u52a1")
    public void start(@RequestBody LeakVerifyTaskStartRequest startRequest) {
        User user = RestContext.getUser();
        if (Objects.isNull(user) || user.getUserType() != 0) {
            log.error("\u7528\u6237\u4e3a\u7a7a\u6216\u7528\u6237\u7c7b\u578b\u975e\u7ba1\u7406\u5458\uff0c\u5f00\u542f\u9a8c\u8bc1\u4efb\u52a1\u5931\u8d25");
            return;
        }
        this.verifyTaskService.start(startRequest);
    }

    @PostMapping(value={"/stop"})
    @ApiOperation(value="\u505c\u6b62\u5468\u671f\u6027\u9a8c\u8bc1\u4efb\u52a1")
    public void stop(@RequestBody LeakVerifyTaskStopRequest stopRequest) {
        User user = RestContext.getUser();
        if (Objects.isNull(user) || user.getUserType() != 0) {
            log.error("\u7528\u6237\u4e3a\u7a7a\u6216\u7528\u6237\u7c7b\u578b\u975e\u7ba1\u7406\u5458\uff0c\u505c\u6b62\u9a8c\u8bc1\u4efb\u52a1\u5931\u8d25");
            return;
        }
        this.verifyTaskService.stop(stopRequest);
    }

    @PostMapping(value={"/run"})
    @ApiOperation(value="\u8fd0\u884c\u5355\u6b21\u9a8c\u8bc1\u4efb\u52a1")
    public LeakVerifyTaskResultResponse run(@RequestBody LeakVerifyTaskRunWithoutSaveRequest runRequest) {
        User user = RestContext.getUser();
        if (Objects.isNull(user) || user.getUserType() != 0) {
            log.error("\u7528\u6237\u4e3a\u7a7a\u6216\u7528\u6237\u7c7b\u578b\u975e\u7ba1\u7406\u5458\uff0c\u8fd0\u884c\u9a8c\u8bc1\u4efb\u52a1\u5931\u8d25");
            return null;
        }
        return this.verifyTaskService.runWithoutResultSave(runRequest);
    }

    @GetMapping(value={"/query"})
    @ApiOperation(value="\u67e5\u770b\u6240\u6709\u9a8c\u8bc1\u4efb\u52a1")
    public Set<String> queryVerifyTask() {
        User user = RestContext.getUser();
        if (Objects.isNull(user) || user.getUserType() != 0) {
            log.error("\u7528\u6237\u4e3a\u7a7a\u6216\u7528\u6237\u7c7b\u578b\u975e\u7ba1\u7406\u5458\uff0c\u67e5\u770b\u9a8c\u8bc1\u4efb\u52a1\u5931\u8d25");
            return null;
        }
        return this.verifyTaskService.queryVerifyTask();
    }
}

