/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.file;

import com.pamirs.tro.entity.domain.dto.file.FileDTO;
import com.pamirs.tro.entity.domain.vo.file.FileDeleteVO;
import io.shulie.tro.utils.file.FileManagerHelper;
import io.shulie.tro.utils.json.JsonHelper;
import io.shulie.tro.web.common.domain.WebRequest;
import io.shulie.tro.web.common.domain.WebResponse;
import io.shulie.tro.web.common.http.HttpWebClient;
import io.shulie.tro.web.common.util.FileUtil;
import io.shulie.tro.web.common.vo.FileWrapperVO;
import io.shulie.tro.web.diff.api.DiffFileApi;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/file"})
@Api(tags={"\u6587\u4ef6\u7ba1\u7406"})
public class FileController {
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    @Autowired
    private HttpWebClient httpWebClient;
    @Autowired
    private DiffFileApi fileApi;
    @Value(value="${file.upload.user.data.dir:/data/tmp}")
    private String fileDir;

    @PostMapping(value={"/upload"})
    @ApiOperation(value="\u6587\u4ef6\u4e0a\u4f20")
    public WebResponse upload(List<MultipartFile> file) {
        if (file == null || file.size() == 0) {
            return WebResponse.fail((String)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        FileWrapperVO wrapperVO = new FileWrapperVO();
        wrapperVO.setFile(FileUtil.convertMultipartFileList(file));
        wrapperVO.setRequestUrl("/api/file/upload");
        wrapperVO.setHttpMethod(HttpMethod.POST);
        WebResponse webResponse = this.httpWebClient.requestFile(wrapperVO);
        FileUtil.deleteTempFile(file);
        return webResponse;
    }

    @PostMapping(value={"/attachment/upload"})
    @ApiOperation(value="\u6587\u4ef6\u4e0a\u4f20")
    public WebResponse uploadAttachment(List<MultipartFile> file) {
        if (file == null || file.size() == 0) {
            return WebResponse.fail((String)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        FileWrapperVO wrapperVO = new FileWrapperVO();
        wrapperVO.setFile(FileUtil.convertMultipartFileList(file));
        wrapperVO.setRequestUrl("/api/file/upload");
        wrapperVO.setHttpMethod(HttpMethod.POST);
        WebResponse webResponse = this.httpWebClient.requestFile(wrapperVO);
        FileUtil.deleteTempFile(file);
        String jsonString = JsonHelper.bean2Json((Object)webResponse.getData());
        List dtoList = JsonHelper.json2List((String)jsonString, FileDTO.class);
        if (CollectionUtils.isNotEmpty((Collection)dtoList)) {
            for (FileDTO fileDTO : dtoList) {
                fileDTO.setFileType(Integer.valueOf(2));
            }
        }
        return WebResponse.success((Object)dtoList);
    }

    @DeleteMapping
    @ApiOperation(value="\u6587\u4ef6\u5220\u9664")
    public WebResponse delete(@RequestBody FileDeleteVO vo) {
        if (vo.getUploadId() == null) {
            return WebResponse.fail((String)"\u5220\u9664\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        vo.setRequestUrl("/api/file");
        vo.setHttpMethod(HttpMethod.DELETE);
        return this.httpWebClient.request((WebRequest)vo);
    }

    @ApiOperation(value="\u6587\u4ef6\u4e0b\u8f7d")
    @GetMapping(value={"/downloadFileByPath"})
    public void downloadFileByPath(@RequestParam(value="filePath") String filePath, HttpServletResponse response) {
        try {
            if (!this.filePathValidate(filePath)) {
                log.warn("\u975e\u6cd5\u4e0b\u8f7d\u8def\u5f84\u6587\u4ef6\uff0c\u7981\u6b62\u4e0b\u8f7d\uff1a{}", (Object)filePath);
                return;
            }
            if (new File(filePath).exists()) {
                ServletOutputStream outputStream = response.getOutputStream();
                Files.copy(Paths.get(filePath, new String[0]), (OutputStream)outputStream);
                response.setContentType("application/octet-stream");
                String saveName = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.length());
                response.setHeader("Content-Disposition", "attachment;filename=" + new String(saveName.getBytes("UTF-8"), "iso-8859-1"));
            }
            FileManagerHelper.deleteFilesByPath((String)filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean filePathValidate(String filePath) {
        List arrayList = this.init();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!filePath.startsWith((String)arrayList.get(i))) continue;
            return true;
        }
        return false;
    }

    private List<String> init() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.fileDir);
        return arrayList;
    }
}

