/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.confcenter;

import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.entity.domain.entity.TSecondLinkMnt;
import io.shulie.tro.web.app.service.TSecondLinkMntService;
import io.swagger.annotations.Api;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e8c\u7ea7\u94fe\u8def\u7ba1\u7406\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/"})
public class SecondLinkMntController {
    private final Logger LOGGER = LoggerFactory.getLogger(SecondLinkMntController.class);
    @Autowired
    private TSecondLinkMntService secondLinkService;

    @PostMapping(value={"confcenter/secondlinkmnt/add/link"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> saveSecondLink(@RequestBody @Valid TSecondLinkMnt secondLinkMnt, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1010300101, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.secondLinkService.saveSecondLink(secondLinkMnt);
            return ResponseOk.create((Object)"succeed");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("SecondLinkMntController.saveSecondLink \u6dfb\u52a0\u4e8c\u7ea7\u94fe\u8def\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("SecondLinkMntController.saveSecondLink \u6dfb\u52a0\u4e8c\u7ea7\u94fe\u8def\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_ADD_SECOND_LINK_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_ADD_SECOND_LINK_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/secondlinkmnt/query/linklist"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryLinkList(@RequestParam(value="linkName") String linkName, @RequestParam(value="baseLinkName") String baseLinkName, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        try {
            return ResponseOk.create((Object)this.secondLinkService.queryLinkList(linkName, baseLinkName, pageNum, pageSize));
        }
        catch (TROModuleException e) {
            this.LOGGER.error("SecondLinkMntController.queryLinkList \u67e5\u8be2\u4e8c\u7ea7\u94fe\u8def\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("SecondLinkMntController.queryLinkList \u67e5\u8be2\u4e8c\u7ea7\u94fe\u8def\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_SECOND_LINKLIST_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_SECOND_LINKLIST_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/secondlinkmnt/query/linkinfo"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryLinkByLinkId(@RequestParam(value="linkId") String linkId) {
        try {
            return ResponseOk.create((Object)this.secondLinkService.queryLinkMapByLinkId(linkId));
        }
        catch (TROModuleException e) {
            this.LOGGER.error("SecondLinkMntController.queryLinkByLinkId \u67e5\u8be2\u4e8c\u7ea7\u94fe\u8def\u8be6\u60c5\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("SecondLinkMntController.queryLinkByLinkId \u67e5\u8be2\u4e8c\u7ea7\u94fe\u8def\u8be6\u60c5\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_SECOND_LINKDETAIL_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_SECOND_LINKDETAIL_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/secondlinkmnt/delete/link"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> deleteLinkByLinkIds(@RequestParam(value="linkIds") String linkIds) {
        try {
            this.secondLinkService.deleteLinkByLinkIds(linkIds);
            return ResponseOk.create((Object)"succeed");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("SecondLinkMntController.deleteLinkByLinkIds \u5220\u9664\u94fe\u8def\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("SecondLinkMntController.deleteLinkByLinkIds \u5220\u9664\u94fe\u8def\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_DELETE_SECOND_LINK_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_DELETE_SECOND_LINK_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"confcenter/secondlinkmnt/update/linkinfo"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> updateLinkinfo(@RequestBody @Valid TSecondLinkMnt secondLinkMnt, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1010300101, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.secondLinkService.updateLinkinfo(secondLinkMnt);
            return ResponseOk.create((Object)"succeed");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("SecondLinkMntController.updateLinkinfo \u6dfb\u52a0\u94fe\u8def\u7684\u670d\u52a1\u7f3a\u5931{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("SecondLinkMntController.updateLinkinfo \u67e5\u8be2\u94fe\u8def\u7b49\u7ea7\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_UPDATE_SECOND_LINKINFO_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_UPDATE_SECOND_LINKINFO_EXCEPTION.getErrorMessage());
        }
    }
}

