/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.confcenter;

import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.entity.domain.entity.TPressureTimeRecord;
import io.shulie.tro.web.app.service.PressureTimeRecordService;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PressureTimeRecord"})
@RestController
@RequestMapping(value={"/api/"})
public class PressureTimeRecordController {
    Logger logger = LoggerFactory.getLogger(PressureTimeRecordController.class);
    @Autowired
    private PressureTimeRecordService pressureTimeRecordService;

    @RequestMapping(value={"confcenter/pressureTime/add"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> savePressureTimeRecord(@RequestBody TPressureTimeRecord pressureTimeRecord) {
        try {
            this.pressureTimeRecordService.savePressureTimeRecord(pressureTimeRecord);
            return ResponseOk.create((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (TROModuleException e) {
            this.logger.error("PressureTimeRecordController.savePressureTimeRecord \u4fdd\u5b58\u538b\u6d4b\u5f00\u59cb\u65f6\u95f4\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.logger.error("PressureTimeRecordController.savePressureTimeRecord \u4fdd\u5b58\u538b\u6d4b\u5f00\u59cb\u65f6\u95f4\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.PRESSURE_TIME_RECORD_SAVE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.PRESSURE_TIME_RECORD_SAVE_EXCEPTION.getErrorMessage());
        }
    }

    @RequestMapping(value={"confcenter/pressureTime/update"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> updatePressureTimeRecord(@RequestBody TPressureTimeRecord pressureTimeRecord) {
        try {
            this.pressureTimeRecordService.updatePressureTimeRecord(pressureTimeRecord);
            return ResponseOk.create((Object)"\u66f4\u65b0\u6210\u529f");
        }
        catch (TROModuleException e) {
            this.logger.error("PressureTimeRecordController.updatePressureTimeRecord \u66f4\u65b0\u538b\u6d4b\u7ed3\u675f\u65f6\u95f4\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.logger.error("PressureTimeRecordController.updatePressureTimeRecord \u66f4\u65b0\u538b\u6d4b\u7ed3\u675f\u65f6\u95f4\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.PRESSURE_TIME_RECORD_UPDATE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.PRESSURE_TIME_RECORD_UPDATE_EXCEPTION.getErrorMessage());
        }
    }

    @RequestMapping(value={"confcenter/pressureTime/query"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryLatestPressureTime() {
        try {
            TPressureTimeRecord pressureTimeRecord = this.pressureTimeRecordService.queryLatestPressureTime();
            return ResponseOk.create((Object)pressureTimeRecord);
        }
        catch (TROModuleException e) {
            this.logger.error("PressureTimeRecordController.queryLatestPressureTime \u67e5\u8be2\u6700\u65b0\u7684\u538b\u6d4b\u65f6\u95f4\u8bb0\u5f55\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.logger.error("PressureTimeRecordController.queryLatestPressureTime \u67e5\u8be2\u6700\u65b0\u7684\u538b\u6d4b\u65f6\u95f4\u8bb0\u5f55\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.PRESSURE_TIME_RECORD_QUERY_LATEST_EXCEPTION.getErrorCode(), (String)TROErrorEnum.PRESSURE_TIME_RECORD_QUERY_LATEST_EXCEPTION.getErrorMessage());
        }
    }
}

