/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.confcenter;

import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.entity.domain.vo.bottleneck.BottleCountVo;
import com.pamirs.tro.entity.domain.vo.bottleneck.BottleNeckDetailVo;
import io.shulie.tro.web.app.service.LinkBottleneckService;
import io.shulie.tro.web.app.service.LinkTopologyInfoService;
import io.swagger.annotations.Api;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u94fe\u8def\u62d3\u6251\u56fe\u63a5\u53e3\u7c7b"})
@RestController
@RequestMapping(value={"/api/"})
public class LinkTopologyController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkTopologyController.class);
    @Autowired
    private LinkTopologyInfoService linkTopologyInfoService;
    @Autowired
    private LinkBottleneckService linkBottleneckService;

    @PostMapping(value={"confcenter/linkTopology/importExcel"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> importExel(@Param(value="excel") MultipartFile excel) {
        try {
            this.linkTopologyInfoService.importExcelData(excel);
            return ResponseOk.create((Object)"\u4e0a\u4f20\u6210\u529f");
        }
        catch (TROModuleException e) {
            LOGGER.error("LinkTopologyController.importExcel" + e.getMessage(), (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            LOGGER.error("LinkTopologyController.importExcel \u4e0a\u4f20excel\u5931\u8d25 {}", (Throwable)e);
            return ResponseError.create((String)"\u4e0a\u4f20excel\u5931\u8d25");
        }
    }

    @GetMapping(value={"confcenter/linkTopology/queryLinkGroup"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryLinkTopologyByLinkGroup(@Param(value="linkGroup") String linkGroup, @Param(value="secondLinkId") String secondLinkId) {
        try {
            return ResponseOk.create((Object)this.linkTopologyInfoService.queryLinkTopologyByLinkGroup(linkGroup, secondLinkId));
        }
        catch (TROModuleException e) {
            LOGGER.error("LinkTopologyController.queryLinkTopologyByLinkGroup" + e.getMessage(), (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            LOGGER.error("LinkTopologyController.queryLinkTopologyByLinkGroup \u67e5\u8be2\u5931\u8d25 {}", (Throwable)e);
            return ResponseError.create((String)"\u83b7\u53d6\u5931\u8d25");
        }
    }

    @GetMapping(value={"confcenter/linkTopology/query/linkBottleSummary"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryLinkBottleSummary() {
        try {
            BottleCountVo bottleCountVo = this.linkTopologyInfoService.queryLinkBottleSummary();
            return ResponseOk.create((Object)bottleCountVo);
        }
        catch (Exception e) {
            LOGGER.error("LinkTopologyController.queryLinkBottleSummary \u67e5\u8be2\u5e94\u7528\u74f6\u9888\u6570\u91cf\u7edf\u8ba1\u5f02\u5e38 {}", (Throwable)e);
            return ResponseError.create((String)e.getMessage());
        }
    }

    @PostMapping(value={"confcenter/linkTopology/query/linkBottleDetail"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryLinkBottleDetail(@RequestBody Map<String, Object> paramMap) {
        try {
            BottleNeckDetailVo bottleNeckDetail = this.linkTopologyInfoService.queryLinkBottleDetail(paramMap);
            return ResponseOk.create((Object)bottleNeckDetail);
        }
        catch (Exception e) {
            LOGGER.error("LinkTopologyController.queryLinkBottleDetail \u67e5\u8be2\u5e94\u7528\u74f6\u9888\u8be6\u60c5\u5f02\u5e38 {}", (Throwable)e);
            return ResponseError.create((String)e.getMessage());
        }
    }
}

