/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.confcenter;

import com.google.common.collect.Maps;
import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.constant.TRODictTypeEnum;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.entity.domain.vo.TLinkServiceMntVo;
import io.shulie.tro.web.app.service.ConfCenterService;
import io.shulie.tro.web.app.utils.ExcelUtil;
import io.swagger.annotations.Api;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u94fe\u8def\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/"})
public class LinkMntController {
    private final Logger LOGGER = LoggerFactory.getLogger(LinkMntController.class);
    @Autowired
    private ConfCenterService confCenterService;

    @PostMapping(value={"confcenter/linkmnt/add/link"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> saveBasicLink(@RequestBody @Valid TLinkServiceMntVo tLinkServiceMntVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1010300101, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.confCenterService.saveLink(tLinkServiceMntVo);
            return ResponseOk.create((Object)"succeed");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("BasicLinkMntController.saveBasicLink \u8be5\u57fa\u7840\u94fe\u8def\u540d\u79f0\u5df2\u7ecf\u5b58\u5728,\u8bf7\u52ff\u91cd\u65b0\u6dfb\u52a0 {}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("BasicLinkMntController.saveBasicLink \u6dfb\u52a0\u57fa\u7840\u94fe\u8def\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_ADD_LINK_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_ADD_LINK_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"confcenter/linkmnt/query/linklist"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryBasicLinkList(@RequestBody Map<String, Object> paramMap) {
        try {
            return ResponseOk.create((Object)this.confCenterService.queryBasicLinkList(paramMap));
        }
        catch (Exception e) {
            this.LOGGER.error("BasicLinkMntController.queryBasicLinkList \u67e5\u8be2\u94fe\u8def\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_LINKLIST_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_LINKLIST_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/linkmnt/download/linklist"})
    public void downloadLinkList(HttpServletResponse response, String applicationName, String interfaceName, String linkName, String linkRank, String linkType, String principalNo, String applicationIds) {
        try {
            HashMap paramMap = Maps.newHashMap();
            paramMap.put("applicationName", applicationName);
            paramMap.put("interfaceName", interfaceName);
            paramMap.put("linkName", linkName);
            paramMap.put("linkRank", linkRank);
            paramMap.put("linkType", linkType);
            paramMap.put("principalNo", principalNo);
            if (StringUtils.isNotBlank((CharSequence)applicationIds)) {
                paramMap.put("applicationIds", Arrays.asList(applicationIds.split(",")));
            }
            paramMap.put("pageSize", -1);
            new ExcelUtil().export(response, this.confCenterService.queryBasicLinkListDownload((Map)paramMap), null, "\u94fe\u8def\u7ba1\u7406");
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @PostMapping(value={"confcenter/linkmnt/upload/linklist"})
    public ResponseEntity<Object> batchUploadLinkList(@RequestParam(value="file") MultipartFile[] files) throws Exception {
        try {
            new ExcelUtil().verify(files);
            this.confCenterService.batchUploadLinkList(files);
            return ResponseOk.create((Object)"succeed");
        }
        catch (TROModuleException e) {
            return ResponseError.create((int)500, (String)e.getErrorMessage());
        }
        catch (Exception e) {
            return ResponseError.create((int)500, (String)e.getMessage());
        }
    }

    @GetMapping(value={"confcenter/linkmnt/query/linkinfo"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryLinkByLinkId(@RequestParam(value="linkId") String linkId) {
        try {
            TLinkServiceMntVo queryLinkByLinkId = this.confCenterService.queryLinkByLinkId(linkId);
            return ResponseOk.create((Object)queryLinkByLinkId);
        }
        catch (Exception e) {
            this.LOGGER.error("BasicLinkMntController.queryLinkByLinkId \u67e5\u8be2\u94fe\u8def\u8be6\u60c5\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_LINKDETAIL_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_LINKDETAIL_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/linkmnt/delete/link"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> deleteBasicLinkByLinkIds(@RequestParam(value="linkIds") String linkIds) {
        try {
            if (StringUtils.isEmpty((CharSequence)linkIds)) {
                return ResponseError.create((int)TROErrorEnum.CONFCENTER_DELETE_LINK_PARAMLACK.getErrorCode(), (String)TROErrorEnum.CONFCENTER_DELETE_LINK_PARAMLACK.getErrorMessage());
            }
            String diableDeleteBasicLink = this.confCenterService.deleteLinkByLinkIds(linkIds);
            if (StringUtils.isNotEmpty((CharSequence)diableDeleteBasicLink)) {
                return ResponseError.create((String)("\u8be5\u57fa\u7840\u94fe\u8def{" + diableDeleteBasicLink + "}\u5728\u4e8c\u7ea7\u94fe\u8def\u4f7f\u7528\u4e0d\u5141\u8bb8\u5220\u9664"));
            }
            return ResponseOk.create((Object)"succeed");
        }
        catch (Exception e) {
            this.LOGGER.error("BasicLinkMntController.deleteLinkByLinkIds \u5220\u9664\u94fe\u8def\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_DELETE_LINK_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_DELETE_LINK_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/linkmnt/query/linkrank"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryLinkRankList() {
        try {
            return ResponseOk.create((Object)this.confCenterService.queryDicList(TRODictTypeEnum.LINKRANK));
        }
        catch (Exception e) {
            this.LOGGER.error("BasicLinkMntController.queryLinkRankList \u67e5\u8be2\u94fe\u8def\u7b49\u7ea7\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_LINKRANK_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_LINKRANK_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"confcenter/linkmnt/update/linkinfo"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> updateLinkinfo(@RequestBody @Valid TLinkServiceMntVo tLinkServiceMntVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1010300101, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.confCenterService.updateLinkInfo(tLinkServiceMntVo);
            return ResponseOk.create((Object)"succeed");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("BasicLinkMntController.updateLinkinfo \u6dfb\u52a0\u94fe\u8def\u7684\u670d\u52a1\u7f3a\u5931{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("BasicLinkMntController.updateLinkinfo \u66f4\u65b0\u94fe\u8def\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_UPDATE_LINKINFO_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_UPDATE_LINKINFO_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/linkmnt/delete/linkinterface"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> deleteLinkInterfaceByLinkServiceId(@RequestParam(value="linkServiceIds") String linkServiceIds) {
        try {
            if (StringUtils.isEmpty((CharSequence)linkServiceIds)) {
                return ResponseError.create((int)TROErrorEnum.CONFCENTER_DELETE_LINKSERVICE_PARAMLACK.getErrorCode(), (String)TROErrorEnum.CONFCENTER_DELETE_LINKSERVICE_PARAMLACK.getErrorMessage());
            }
            this.confCenterService.deleteLinkInterfaceByLinkServiceId(linkServiceIds);
            return ResponseOk.create((Object)"succeed");
        }
        catch (Exception e) {
            this.LOGGER.error("BasicLinkMntController.deleteLinkInterfaceByLinkServiceId \u5220\u9664\u94fe\u8def\u670d\u52a1\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_DELETE_LINKSERVICE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_DELETE_LINKSERVICE_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/linkmnt/query/linktype"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryLinkTypeList() {
        try {
            return ResponseOk.create((Object)this.confCenterService.queryDicList(TRODictTypeEnum.LINK_TYPE));
        }
        catch (Exception e) {
            this.LOGGER.error("LinkMntController.queryLinkTypeList \u67e5\u8be2\u94fe\u8def\u7c7b\u578b\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_LINKTYPE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_LINKTYPE_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"confcenter/linkmnt/query/linkByLinkType"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryLinkByLinkType(@RequestBody Map<String, Object> paramMap) {
        try {
            return ResponseOk.create((Object)this.confCenterService.queryLinkByLinkType(paramMap));
        }
        catch (Exception e) {
            this.LOGGER.error("BasicLinkMntController.queryLinkByLinkType \u67e5\u8be2\u94fe\u8def\u5217\u8868\u5931\u8d25{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_LINKBYLINKTYPE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_UPDATE_LINKINFO_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/linkmnt/query/linkIdName"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryLinkIdNameList() {
        try {
            return ResponseOk.create((Object)this.confCenterService.queryLinkIdName());
        }
        catch (Exception e) {
            this.LOGGER.error("BasicLinkMntController.queryLinkByLinkType \u67e5\u8be2\u94fe\u8def\u5217\u8868\u5931\u8d25{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_LINKBYLINKTYPE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_UPDATE_LINKINFO_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/linkmnt/query/linkmodule"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryLinkModuleList() {
        try {
            return ResponseOk.create((Object)this.confCenterService.queryDicList(TRODictTypeEnum.LINK_MODULE));
        }
        catch (Exception e) {
            this.LOGGER.error("LinkMntController.queryLinkModuleList \u67e5\u8be2\u94fe\u8def\u6a21\u5757\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_LINKMODULE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_LINKMODULE_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/linkmnt/query/whiteListForLink"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> getWhiteList() {
        try {
            return ResponseOk.create((Object)this.confCenterService.getWhiteListForLink());
        }
        catch (Exception e) {
            this.LOGGER.error("LinkMntController.getWhiteList \u67e5\u8be2\u94fe\u8def\u6a21\u5757\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_WHITELIST_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_WHITELIST_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/linkmnt/query/calcVolumeList"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryCalcVolumeList() {
        try {
            return ResponseOk.create((Object)this.confCenterService.queryDicList(TRODictTypeEnum.VOLUME_CALC_STATUS));
        }
        catch (Exception e) {
            this.LOGGER.error("LinkMntController.queryCalcVolumeList \u67e5\u8be2\u5355\u91cf\u8ba1\u7b97\u65b9\u5f0f\u5b57\u5178\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_VOLUME_CALC_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_VOLUME_CALC_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/linkmnt/query/linkHead"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryLinkHeaderList() {
        try {
            return ResponseOk.create((Object)this.confCenterService.queryLinkHeaderInfoList());
        }
        catch (Exception e) {
            this.LOGGER.error("LinkMntController.queryLinkHeaderList \u67e5\u8be2\u94fe\u8def\u5934\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_LINK_HEADER_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_LINK_HEADER_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/linkmnt/query/secondLinkByModule"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> querySecondLinkByModule(@RequestParam(value="linkModule") String linkModule) {
        try {
            long moduleValue = Long.parseLong(linkModule);
            if (StringUtils.isEmpty((CharSequence)linkModule) || moduleValue < 0L) {
                return ResponseError.create((int)1010301401, (String)("linkModule={" + linkModule + "}\u53c2\u6570\u5f02\u5e38"));
            }
        }
        catch (NumberFormatException e) {
            this.LOGGER.error("LinkMntController.querySecondLinkByModule \u53c2\u6570\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)1010301401, (String)("linkModule={" + linkModule + "}\u53c2\u6570\u5f02\u5e38"));
        }
        try {
            return ResponseOk.create((Object)this.confCenterService.querySecondLinkByModule(linkModule));
        }
        catch (Exception e) {
            this.LOGGER.error("LinkMntController.querySecondLinkByModule \u67e5\u8be2\u94fe\u8def\u6a21\u5757\u4e0b\u6709\u54ea\u4e9b\u4e8c\u7ea7\u94fe\u8def\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_LINK_SECONDLINK_BY_MODULE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_LINK_SECONDLINK_BY_MODULE_EXCEPTION.getErrorMessage());
        }
    }
}

