/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.confcenter;

import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.entity.domain.entity.TFirstLinkMnt;
import io.shulie.tro.web.app.service.TFirstLinkMntService;
import io.swagger.annotations.Api;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e00\u7ea7\u94fe\u8def\u7ba1\u7406\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/"})
public class FirstLinkMntController {
    private final Logger LOGGER = LoggerFactory.getLogger(FirstLinkMntController.class);
    @Autowired
    private TFirstLinkMntService firstLinkService;

    @PostMapping(value={"confcenter/firstlinkmnt/add/link"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> saveLink(@RequestBody @Valid TFirstLinkMnt firstLinkMnt, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1010300101, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.firstLinkService.saveLink(firstLinkMnt);
            return ResponseOk.create((Object)"succeed");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("FirstLinkMntController.saveLink \u6dfb\u52a0\u4e00\u7ea7\u94fe\u8def\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("FirstLinkMntController.saveLink \u6dfb\u52a0\u4e00\u7ea7\u94fe\u8def\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_ADD_FIRST_LINK_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_ADD_FIRST_LINK_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/firstlinkmnt/query/linklist"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryLinkList(@RequestParam(value="firstLinkName") String firstLinkName, @RequestParam(value="secondLinkName") String secondLinkName, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        try {
            return ResponseOk.create((Object)this.firstLinkService.queryLinkList(firstLinkName, secondLinkName, pageNum, pageSize));
        }
        catch (TROModuleException e) {
            this.LOGGER.error("FirstLinkMntController.queryLinkList \u67e5\u8be2\u4e00\u7ea7\u94fe\u8def\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("FirstLinkMntController.queryLinkList \u67e5\u8be2\u4e00\u7ea7\u94fe\u8def\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_FIRST_LINKLIST_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_FIRST_LINKLIST_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/firstlinkmnt/query/linkinfo"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryLinkByLinkId(@RequestParam(value="linkId") String linkId) {
        if (StringUtils.isEmpty((CharSequence)linkId)) {
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_FIRST_LINKINFO_PARAMLACK.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_FIRST_LINKINFO_PARAMLACK.getErrorMessage());
        }
        try {
            return ResponseOk.create((Object)this.firstLinkService.queryLinkMapByLinkId(linkId));
        }
        catch (TROModuleException e) {
            this.LOGGER.error("FirstLinkMntController.queryLinkByLinkId \u67e5\u8be2\u4e00\u7ea7\u94fe\u8def\u8be6\u60c5\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("FirstLinkMntController.queryLinkByLinkId \u67e5\u8be2\u4e00\u7ea7\u94fe\u8def\u8be6\u60c5\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_FIRST_LINKDETAIL_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_FIRST_LINKDETAIL_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/firstlinkmnt/delete/link"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> deleteLinkByLinkIds(@RequestParam(value="linkIds") String linkIds) {
        try {
            this.firstLinkService.deleteLinkByLinkIds(linkIds);
            return ResponseOk.create((Object)"succeed");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("FirstLinkMntController.deleteLinkByLinkIds \u5220\u9664\u94fe\u8def\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("FirstLinkMntController.deleteLinkByLinkIds \u5220\u9664\u94fe\u8def\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_DELETE_FIRST_LINK_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_DELETE_FIRST_LINK_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"confcenter/firstlinkmnt/update/linkinfo"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> updateLinkinfo(@RequestBody @Valid TFirstLinkMnt firstLinkMnt, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1010300101, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.firstLinkService.updateLinkinfo(firstLinkMnt);
            return ResponseOk.create((Object)"succeed");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("FirstLinkMntController.updateLinkinfo \u66f4\u65b0\u4e00\u7ea7\u94fe\u8def\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("FirstLinkMntController.updateLinkinfo \u66f4\u65b0\u4e00\u7ea7\u94fe\u8def\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_UPDATE_FIRST_LINKINFO_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_UPDATE_FIRST_LINKINFO_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/firstlinkmnt/query/linkTopology"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> getLinkTopologyByFirstLinkId(@RequestParam(value="linkId") String linkId) {
        try {
            return ResponseOk.create((Object)this.firstLinkService.getLinkTopologyByFirstLinkId(linkId));
        }
        catch (TROModuleException e) {
            this.LOGGER.error("FirstLinkMntController.getLinkTopologyByFirstLinkId \u83b7\u53d6\u94fe\u8def\u62d3\u6251\u56fe\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("FirstLinkMntController.getLinkTopologyByFirstLinkId \u83b7\u53d6\u94fe\u8def\u62d3\u6251\u56fe\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_LINK_TOPOLOGY_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_LINK_TOPOLOGY_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/firstlinkmnt/query/existFirstLink"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> existFirstLinkBySecondLinkId(@RequestParam(value="secondLinkId") String secondLinkId) {
        if (StringUtils.isEmpty((CharSequence)secondLinkId)) {
            this.LOGGER.error("FirstLinkMntController.existFirstLinkBySecondLinkId\u63a5\u6536\u4e86\u975e\u6cd5\u7684\u53c2\u6570\uff1a" + secondLinkId);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_SECOND_LINKID_LIST_IS_NULL_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_SECOND_LINKID_LIST_IS_NULL_EXCEPTION.getErrorMessage());
        }
        List tFirstLinkMnts = this.firstLinkService.queryLinkBySecondLinkId(secondLinkId);
        if (tFirstLinkMnts != null && tFirstLinkMnts.size() > 0) {
            return ResponseOk.create((Object)true);
        }
        return ResponseOk.create((Object)false);
    }

    @GetMapping(value={"/emptyUrl"}, produces={"application/json;charset=UTF-8"})
    public String emptyUrl() {
        return "success";
    }
}

