/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.confcenter;

import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.entity.domain.vo.TDictionaryVo;
import io.shulie.tro.web.app.service.DictionaryMntService;
import io.swagger.annotations.Api;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u5b57\u5178\u6a21\u5757\u5165\u53e3"})
@RestController
@RequestMapping(value={"/api/"})
public class DictionaryMntController {
    private final Logger LOGGER = LoggerFactory.getLogger(DictionaryMntController.class);
    @Autowired
    private DictionaryMntService dictionaryMntService;

    @PostMapping(value={"confcenter/dictionary/save"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> saveDictionary(@RequestBody @Valid TDictionaryVo tDictionaryVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1010600102, (String)"\u65b0\u589e\u6570\u636e\u5b57\u5178\u53c2\u6570\u5f02\u5e38");
        }
        try {
            this.dictionaryMntService.saveDictionary(tDictionaryVo);
            return ResponseOk.create((Object)"\u4fdd\u5b58\u6210\u529f!");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("DictionaryMntController.saveDictionary \u4fdd\u5b58\u6570\u636e\u5b57\u5178\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("DictionaryMntController.saveDictionary \u4fdd\u5b58\u6570\u636e\u5b57\u5178\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_SAVE_DICTIONARY_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_SAVE_DICTIONARY_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"confcenter/dictionary/update"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> updateDictionary(@RequestBody @Valid TDictionaryVo tDictionaryVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1010600202, (String)"\u66f4\u65b0\u6570\u636e\u5b57\u5178\u53c2\u6570\u5f02\u5e38");
        }
        try {
            this.dictionaryMntService.updateDictionary(tDictionaryVo);
            return ResponseOk.create((Object)"\u66f4\u65b0\u6210\u529f!");
        }
        catch (Exception e) {
            this.LOGGER.error("DictionaryMntController.updateDictionary \u4fee\u6539\u6570\u636e\u5b57\u5178\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_UPDATE_DICTIONARY_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_UPDATE_DICTIONARY_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"confcenter/dictionary/query/list"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryDictionaryList(@RequestBody Map<String, Object> paramMap) {
        try {
            return ResponseOk.create((Object)this.dictionaryMntService.queryDictionaryList(paramMap));
        }
        catch (Exception e) {
            this.LOGGER.error("DictionaryMntController.queryDictionaryList \u67e5\u8be2\u6570\u636e\u5b57\u5178\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_DICTIONARY_LIST_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_DICTIONARY_LIST_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/dictionary/query/detail"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryDictionaryDetail(@RequestParam(value="tDictId") String tDictionaryId) {
        try {
            return ResponseOk.create((Object)this.dictionaryMntService.queryDictionaryDetail(tDictionaryId));
        }
        catch (Exception e) {
            this.LOGGER.error("DictionaryMntController.queryDictionaryDetail \u67e5\u8be2\u6570\u636e\u5b57\u5178\u8be6\u60c5\u5931\u8d25{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_DICTIONARY_DETAIL_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_DICTIONARY_DETAIL_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/dictionary/delete"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> deleteDictionary(@RequestParam(value="tDictIds") String tDidctionaryIds) {
        try {
            this.dictionaryMntService.deleteDictionary(tDidctionaryIds);
            return ResponseOk.create((Object)"\u5220\u9664\u6210\u529f!");
        }
        catch (Exception e) {
            this.LOGGER.error("DictionaryMntController.deleteDictionary \u5220\u9664\u6570\u636e\u5b57\u5178\u5931\u8d25{" + tDidctionaryIds + "}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_DELETE_DICTIONARY_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_DELETE_DICTIONARY_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/dictionary/queryDictValue"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryDictionaryKeyValue(@RequestParam(value="dictCode") String dictCode) {
        try {
            Map dictValue = this.dictionaryMntService.queryDictionaryKeyValue(dictCode);
            return ResponseOk.create((Object)dictValue);
        }
        catch (Exception e) {
            this.LOGGER.error("DictionaryMntController.queryDictionaryKeyValue \u67e5\u8be2\u6570\u636e\u5b57\u5178\u5931\u8d25{" + dictCode + "}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_DICTIONARY_VALUE_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_DICTIONARY_VALUE_EXCEPTION.getErrorMessage());
        }
    }
}

