/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.confcenter;

import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.entity.domain.entity.TBaseConfig;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.service.BaseConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"TRO\u57fa\u7840\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/api/"})
public class BaseConfigController {
    private final Logger LOGGER = LoggerFactory.getLogger(BaseConfigController.class);
    @Autowired
    private BaseConfigService baseConfigService;

    @PostMapping(value={"confcenter/troConfig/addGlobalConfig"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u65b0\u589e\u914d\u7f6e")
    public ResponseEntity<Object> addBaseConfig(@RequestBody TBaseConfig tBaseConfig) {
        try {
            this.baseConfigService.addBaseConfig(tBaseConfig);
            return ResponseOk.create((Object)"\u65b0\u589e\u6210\u529f");
        }
        catch (Exception e) {
            this.LOGGER.error("BaseConfigController.updateBaseConfig \u66f4\u65b0\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.API_TRO_CONFCENTER_ADD_BASE_CONFIG_EXCEPTION.getErrorCode(), (String)TROErrorEnum.API_TRO_CONFCENTER_ADD_BASE_CONFIG_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/troConfig/queryGlobalConfig"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u83b7\u53d6\u914d\u7f6e")
    public ResponseEntity<Object> queryByConfigCode(@RequestParam(value="configCode") String configCode) {
        if (StringUtils.isEmpty((CharSequence)String.valueOf(configCode))) {
            return ResponseError.create((int)1010100301, (String)"\u53c2\u6570\u7f3a\u5931");
        }
        try {
            return ResponseOk.create((Object)this.baseConfigService.queryByConfigCode(configCode));
        }
        catch (Exception e) {
            this.LOGGER.error("BaseConfigController.queryByConfigCode \u67e5\u8be2\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.API_TRO_CONFCENTER_BASE_CONFIG_QUERY_EXCEPTION.getErrorCode(), (String)TROErrorEnum.API_TRO_CONFCENTER_BASE_CONFIG_QUERY_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"/base/config"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u83b7\u53d6\u6a21\u677f\u914d\u7f6e")
    public Response<String> queryConfigByCode(@RequestParam(value="configCode") String configCode) {
        TBaseConfig config = this.baseConfigService.queryByConfigCode(configCode);
        return Response.success((Object)(config != null ? config.getConfigValue() : null));
    }

    @PostMapping(value={"confcenter/troConfig/updateGlobalConfig"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> updateBaseConfig(@RequestBody TBaseConfig tBaseConfig) {
        try {
            this.baseConfigService.updateBaseConfig(tBaseConfig);
            return ResponseOk.create((Object)"\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            this.LOGGER.error("BaseConfigController.updateBaseConfig \u66f4\u65b0\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.API_TRO_CONFCENTER_UPDATE_BASE_CONFIG_EXCEPTION.getErrorCode(), (String)TROErrorEnum.API_TRO_CONFCENTER_UPDATE_BASE_CONFIG_EXCEPTION.getErrorMessage());
        }
    }
}

