/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.confcenter;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.constant.TRODictTypeEnum;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.entity.domain.entity.TWList;
import com.pamirs.tro.entity.domain.query.TWListVo;
import io.shulie.tro.web.app.service.ConfCenterService;
import io.shulie.tro.web.app.utils.ExcelUtil;
import io.swagger.annotations.Api;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u9ed1\u767d\u540d\u5355\u7ba1\u7406\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/"})
public class BWListMntController {
    private final Logger LOGGER = LoggerFactory.getLogger(BWListMntController.class);
    @Autowired
    private ConfCenterService confCenterService;

    @PostMapping(value={"confcenter/wbmnt/add/wlist"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> saveWList(@RequestBody @Valid TWListVo twlistVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1010200101, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            List list = this.confCenterService.saveWList(twlistVo);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return ResponseOk.create((Object)"succeed");
            }
            String join = Joiner.on((String)",").skipNulls().join((Iterable)list);
            return ResponseOk.create((Object)(join + " \u5df2\u7ecf\u5b58\u5728,\u8bf7\u52ff\u91cd\u65b0\u6dfb\u52a0"));
        }
        catch (TROModuleException e) {
            this.LOGGER.error("BWListMntController.saveWList \u65b0\u589e\u767d\u540d\u5355\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("BWListMntController.saveWList \u65b0\u589e\u767d\u540d\u5355\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_ADD_WLIST_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_ADD_WLIST_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"confcenter/wbmnt/upload/wlist"})
    public ResponseEntity<Object> uploadWList(@RequestParam(value="file") MultipartFile[] files) throws Exception {
        try {
            new ExcelUtil().verify(files);
            this.confCenterService.batchUploadWList(files);
            return ResponseEntity.ok((Object)"success");
        }
        catch (TROModuleException e) {
            return ResponseError.create((int)500, (String)e.getErrorMessage());
        }
        catch (Exception e) {
            return ResponseError.create((int)500, (String)e.getMessage());
        }
    }

    @GetMapping(value={"confcenter/wbmnt/download/wlist"})
    public void whiteListDownload(HttpServletResponse response, String applicationName, String principalNo, String type, String whiteListUrl, String wlistIds) {
        try {
            HashMap paramMap = Maps.newHashMap();
            paramMap.put("applicationName", applicationName);
            paramMap.put("principalNo", principalNo);
            paramMap.put("type", type);
            paramMap.put("whiteListUrl", whiteListUrl);
            if (StringUtils.isNotBlank((CharSequence)wlistIds)) {
                paramMap.put("wlistIds", Arrays.asList(wlistIds.split(",")));
            }
            ExcelUtil excelUtil = new ExcelUtil();
            excelUtil.export(response, this.confCenterService.queryWListDownLoad((Map)paramMap), null, "\u767d\u540d\u5355\u7ba1\u7406");
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @PostMapping(value={"confcenter/wbmnt/query/wlist"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryWList(@RequestBody Map<String, Object> paramMap) {
        try {
            return ResponseOk.create((Object)this.confCenterService.queryWList(paramMap));
        }
        catch (Exception e) {
            this.LOGGER.error("BWListMntController.queryBList \u67e5\u8be2\u767d\u540d\u5355\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_WLIST_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_WLIST_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/wbmnt/query/wlist/agent"}, produces={"application/json;charset=UTF-8"})
    public ResponseOk.ResponseResult queryWList4Agent() {
        Map result = new HashMap();
        try {
            result = this.confCenterService.queryBWList("");
        }
        catch (Exception e) {
            this.LOGGER.error("BWListMntController.queryBList \u67e5\u8be2\u767d\u540d\u5355\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
        }
        return ResponseOk.result(result);
    }

    @GetMapping(value={"confcenter/wbmnt/query/wlistinfo"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> querySingleWListById(@RequestParam(value="wlistId") String wlistId) {
        if (StringUtils.isEmpty((CharSequence)wlistId)) {
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_WLISTBYID_PARAMLACK.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_WLISTBYID_PARAMLACK.getErrorMessage());
        }
        try {
            return ResponseOk.create((Object)this.confCenterService.querySingleWListById(wlistId));
        }
        catch (TROModuleException e) {
            this.LOGGER.error("ConfCenterController.querySingleWListById \u8be5\u767d\u540d\u5355\u4fe1\u606f\u4e0d\u5b58\u5728{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("BWListMntController.querySingleWListById  \u6839\u636eid\u67e5\u8be2\u767d\u540d\u5355\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_WLISTBYID_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_WLISTBYID_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"confcenter/wbmnt/update/wlist"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> updateWListById(@RequestBody @Valid TWList tWList, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1010200401, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.confCenterService.updateWListById(tWList);
            return ResponseOk.create((Object)"succeed");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("ConfCenterController.updateWListById \u8be5\u767d\u540d\u5355\u4fe1\u606f\u4e0d\u5b58\u5728{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("BWListMntController.updateWListById  \u6839\u636eid\u66f4\u65b0\u767d\u540d\u5355\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_UPDATE_WLIST_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_UPDATE_WLIST_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/wbmnt/delete/wlist"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> deleteWListByIds(@RequestParam(value="wlistIds") String wlistIds) {
        try {
            String diableDeleteWList = this.confCenterService.deleteWListByIds(wlistIds);
            if (StringUtils.isNotEmpty((CharSequence)diableDeleteWList)) {
                return ResponseError.create((String)("\u8be5\u767d\u540d\u5355{ " + diableDeleteWList + " }\u5728\u57fa\u7840\u94fe\u8def\u4e2d\u4f7f\u7528,\u4e0d\u5141\u8bb8\u5220\u9664"));
            }
            return ResponseOk.create((Object)"succeed");
        }
        catch (Exception e) {
            this.LOGGER.error("BWListMntController.deleteWListByIds  \u5220\u9664\u767d\u540d\u5355\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_DELETE_WLIST_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_DELETE_WLIST_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/wbmnt/dic/query/wlist"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryWListDic() {
        try {
            return ResponseOk.create((Object)this.confCenterService.queryDicList(TRODictTypeEnum.WLIST));
        }
        catch (Exception e) {
            this.LOGGER.error("BWListMntController.queryWListDic  \u67e5\u8be2\u767d\u540d\u5355\u5b57\u5178\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_WLISTDIC_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_WLISTDIC_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"confcenter/wbmnt/query/wlistbyappname"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryWListByAppName(@RequestBody Map<String, Object> paramMap) {
        try {
            return ResponseOk.create((Object)this.confCenterService.queryWListByAppName(paramMap));
        }
        catch (Exception e) {
            this.LOGGER.error("BWListMntController.queryWListByAppName  \u67e5\u8be2\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_WLISTBYAPPNAME_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_WLISTBYAPPNAME_EXCEPTION.getErrorMessage());
        }
    }

    @GetMapping(value={"confcenter/wbmnt/query/list"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryWListByAppId(@RequestParam(value="applicationId") String applicationId) {
        if (StringUtils.isBlank((CharSequence)applicationId)) {
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_WLISTBYAPPID_PARAM_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_WLISTBYAPPID_PARAM_EXCEPTION.getErrorMessage());
        }
        try {
            return ResponseOk.create((Object)this.confCenterService.queryWListByAppId(applicationId));
        }
        catch (Exception e) {
            this.LOGGER.error("BWListMntController.queryWListByAppId  \u67e5\u8be2\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_WLISTBYAPPID_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_WLISTBYAPPID_EXCEPTION.getErrorMessage());
        }
    }
}

