/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.confcenter;

import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.entity.domain.entity.TApplicationMnt;
import io.shulie.tro.web.app.service.ConfCenterService;
import io.swagger.annotations.Api;
import java.util.Map;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e94\u7528\u7ba1\u7406\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/"})
public class ApplicationMntController {
    private final Logger LOGGER = LoggerFactory.getLogger(ApplicationMntController.class);
    @Autowired
    private ConfCenterService confCenterService;

    @PostMapping(value={"confcenter/applicationmnt/add/application"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> saveApplication(@RequestBody @Valid TApplicationMnt tApplicationMnt, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1010100101, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.confCenterService.saveApplication(tApplicationMnt);
            return ResponseOk.create((Object)"succeed");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("ConfCenterController.queryWList \u5e94\u7528\u5df2\u7ecf\u5b58\u5728,\u8bf7\u52ff\u91cd\u65b0\u6dfb\u52a0 {}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("ApplicationMntController.saveApplication \u65b0\u589e\u5e94\u7528\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_ADD_APPLICATION_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_ADD_APPLICATION_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"confcenter/applicationmnt/query/applicationlist"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryApplicationinfo(@RequestBody Map<String, Object> paramMap) {
        try {
            return ResponseOk.create((Object)this.confCenterService.queryApplicationList(paramMap));
        }
        catch (Exception e) {
            this.LOGGER.error("ApplicationMntController.queryApplicationinfo \u67e5\u8be2\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)1010100102, (String)"\u67e5\u8be2\u5e94\u7528\u4fe1\u606f\u5f02\u5e38");
        }
    }

    @GetMapping(value={"confcenter/applicationmnt/query/applicationinfo"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryApplicationinfoById(@RequestParam(value="applicationId") long applicationId) {
        if (StringUtils.isEmpty((CharSequence)String.valueOf(applicationId))) {
            return ResponseError.create((int)1010100301, (String)"\u53c2\u6570\u7f3a\u5931");
        }
        try {
            return ResponseOk.create((Object)this.confCenterService.queryApplicationinfoById(applicationId));
        }
        catch (Exception e) {
            this.LOGGER.error("ApplicationMntController.queryApplicationinfoById \u67e5\u8be2\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)1010100302, (String)"\u6839\u636e\u5e94\u7528id\u67e5\u8be2\u5f02\u5e38");
        }
    }

    @GetMapping(value={"confcenter/applicationmnt/delete/applicationinfo"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> deleteApplicationinfoByIds(@RequestParam(value="applicationIds") String applicationIds) {
        try {
            String diableDeleteApplication = this.confCenterService.deleteApplicationinfoByIds(applicationIds);
            if (StringUtils.isNotEmpty((CharSequence)diableDeleteApplication)) {
                return ResponseError.create((String)("\u8be5\u5e94\u7528{ " + diableDeleteApplication + " }\u5728\u57fa\u7840\u94fe\u8def\u4e2d\u4f7f\u7528,\u4e0d\u5141\u8bb8\u5220\u9664"));
            }
            return ResponseOk.create((Object)"succeed");
        }
        catch (Exception e) {
            this.LOGGER.error("ApplicationMntController.deleteApplicationinfoById \u5220\u9664\u5e94\u7528\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)1010100102, (String)"\u6279\u91cf\u5220\u9664\u5e94\u7528\u5f02\u5e38");
        }
    }

    @GetMapping(value={"confcenter/applicationmnt/dic/query/applicationdata"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryApplicationdata() {
        try {
            return ResponseOk.create((Object)this.confCenterService.queryApplicationdata());
        }
        catch (Exception e) {
            this.LOGGER.error("ConfCenterController.queryWList \u67e5\u8be2\u5e94\u7528\u4e0b\u62c9\u6846\u6570\u636e\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)1010100102, (String)"\u67e5\u8be2\u5e94\u7528\u4e0b\u62c9\u6846\u6570\u636e\u5f02\u5e38");
        }
    }

    @PostMapping(value={"confcenter/applicationmnt/update/applicationinfo"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> updateApplicationinfo(@RequestBody @Valid TApplicationMnt tApplicationMnt, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseError.create((int)1010100601, (String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.confCenterService.updateApplicationinfo(tApplicationMnt);
            return ResponseOk.create((Object)"succeed");
        }
        catch (TROModuleException e) {
            this.LOGGER.error("ConfCenterController.updateApplicationinfo \u521b\u5efa\u5e94\u7528\u811a\u672c\u5b58\u653e\u8def\u5f84\u4e0d\u5b58\u5728{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            this.LOGGER.error("ConfCenterController.updateApplicationinfo \u6839\u636e\u5e94\u7528id\u66f4\u65b0\u5e94\u7528\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)1010100602, (String)"\u6839\u636e\u5e94\u7528id\u66f4\u65b0\u5e94\u7528\u4fe1\u606f\u5f02\u5e38");
        }
    }

    @GetMapping(value={"confcenter/applicationmnt/query/appnamebyprada"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryAppNameByPradar() {
        try {
            String result = "{\"success\":\"true\",\"code\":200,\"data\":null}";
            return ResponseOk.create((Object)result);
        }
        catch (Exception e) {
            this.LOGGER.error("ApplicationMntController.queryAppNameByPradar \u67e5\u8be2\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)1010100702, (String)"\u67e5\u8be2\u5e94\u7528\u4fe1\u606f\u5f02\u5e38");
        }
    }
}

