/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.confcenter;

import com.github.pagehelper.util.StringUtil;
import com.pamirs.tro.entity.domain.query.ApplicationQueryParam;
import com.pamirs.tro.entity.domain.vo.ApplicationVo;
import io.shulie.tro.common.beans.annotation.ModuleDef;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.service.ApplicationService;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController(value="confApplicationController")
@RequestMapping(value={"/api/"})
@Api(tags={"\u63a5\u53e3: \u5e94\u7528\u7ba1\u7406\u4e2d\u5fc3"}, value="\u5e94\u7528\u7ba1\u7406\u4e2d\u5fc3")
public class ApplicationController {
    private static String FALSE_CODE = "0";
    @Autowired
    private ApplicationService applicationService;

    @GetMapping(value={"/application/center/list"})
    @ApiOperation(value="\u5e94\u7528\u5217\u8868\u67e5\u8be2\u63a5\u53e3")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.QUERY)
    public Response<List<ApplicationVo>> getApplicationListWithAuth(@ApiParam(name="applicationName", value="\u7cfb\u7edf\u540d\u5b57") String applicationName, Integer current, Integer pageSize, @ApiParam(name="accessStatus", value="\u63a5\u5165\u72b6\u6001") Integer accessStatus) {
        current = current + 1;
        ApplicationQueryParam param = new ApplicationQueryParam();
        param.setCurrentPage(current);
        param.setPageSize(pageSize);
        param.setApplicationName(applicationName);
        return this.applicationService.getApplicationList(param, accessStatus);
    }

    @GetMapping(value={"/application/center/list/dictionary"})
    @ApiOperation(value="\u5e94\u7528\u5217\u8868\u67e5\u8be2\u63a5\u53e3")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.QUERY)
    public Response<List<ApplicationVo>> getApplicationListNoAuth() {
        return this.applicationService.getApplicationList();
    }

    @GetMapping(value={"/console/application/center/app/info"})
    @ApiOperation(value="\u5e94\u7528\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.QUERY)
    public Response<ApplicationVo> getApplicationInfoWithAuth(@ApiParam(name="id", value="\u7cfb\u7edfid") String id) {
        return this.applicationService.getApplicationInfo(id);
    }

    @GetMapping(value={"/application/center/app/info/dictionary"})
    @ApiOperation(value="\u5e94\u7528\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3")
    public Response<ApplicationVo> getApplicationInfoNoAuth(@ApiParam(name="id", value="\u7cfb\u7edfid") String id) {
        return this.applicationService.getApplicationInfo(id);
    }

    @PostMapping(value={"/console/application/center/app/info"})
    @ApiOperation(value="\u65b0\u589e\u5e94\u7528\u63a5\u53e3")
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u57fa\u7840\u4fe1\u606f", logMsgKey="message.basic_info.create")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.CREATE)
    public Response addApplication(@RequestBody ApplicationVo vo) {
        OperationLogContextHolder.operationType((String)"\u65b0\u589e");
        OperationLogContextHolder.addVars((String)"application", (String)vo.getApplicationName());
        return this.applicationService.addApplication(vo);
    }

    @PutMapping(value={"/console/application/center/app/info"})
    @ApiOperation(value="\u7f16\u8f91\u5e94\u7528")
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u57fa\u7840\u4fe1\u606f", logMsgKey="message.basic_info.update")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.UPDATE)
    public Response modifyApplication(@RequestBody ApplicationVo vo) {
        OperationLogContextHolder.operationType((String)"\u7f16\u8f91");
        return this.applicationService.modifyApplication(vo);
    }

    @ApiOperation(value="\u5220\u9664\u5e94\u7528\u63a5\u53e3")
    @DeleteMapping(value={"/console/application/center/app/info"})
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u57fa\u7840\u4fe1\u606f", logMsgKey="message.basic_info.delete")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.DELETE)
    public Response deleteApplication(@RequestBody ApplicationVo vo) {
        if (vo == null || StringUtil.isEmpty((String)vo.getId())) {
            return Response.fail((String)FALSE_CODE, (String)"id \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Response applicationVo = this.applicationService.getApplicationInfo(vo.getId());
        if (null == ((ApplicationVo)applicationVo.getData()).getId()) {
            return Response.fail((String)"\u8be5\u5e94\u7528\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ApplicationVo data = (ApplicationVo)applicationVo.getData();
        OperationLogContextHolder.operationType((String)"\u5220\u9664");
        OperationLogContextHolder.addVars((String)"application", (String)data.getApplicationName());
        return this.applicationService.deleteApplication(vo.getId());
    }

    @ApiOperation(value="\u538b\u6d4b\u5168\u5c40\u5f00\u5173\u63a5\u53e3")
    @PutMapping(value={"/application/center/app/switch"})
    @ModuleDef(moduleName="\u914d\u7f6e\u4e2d\u5fc3", subModuleName="\u538b\u6d4b\u5f00\u5173", logMsgKey="message.pressure_test_switch.action")
    @AuthVerification(moduleCode="configCenter_pressureMeasureSwitch", needAuth=ActionTypeEnum.ENABLE_DISABLE)
    public Response AppSwitch(@RequestBody ApplicationVo vo) {
        if (vo == null || vo.getPressureEnable() == null) {
            return Response.fail((String)FALSE_CODE, (String)"pressureEnable \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        OperationLogContextHolder.operationType((String)(vo.getPressureEnable() != false ? "\u5f00\u542f" : "\u5173\u95ed"));
        OperationLogContextHolder.addVars((String)"action", (String)(vo.getPressureEnable() != false ? "\u5f00\u542f" : "\u5173\u95ed"));
        return this.applicationService.userAppPressureSwitch(null, vo.getPressureEnable());
    }

    @ApiOperation(value="\u538b\u6d4b\u5f00\u5173\u72b6\u6001\u91cd\u65b0\u8ba1\u7b97\u63a5\u53e3")
    @GetMapping(value={"/application/center/app/switch/calculate"})
    public Response AppSwitchForce(@RequestParam(value="uid", required=false) Long uid) {
        return this.applicationService.calculateUserSwitch(uid);
    }

    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u538b\u6d4b\u5f00\u5173\u72b6\u6001\u63a5\u53e3")
    @GetMapping(value={"/application/center/app/switch"})
    public Response AppSwitchInfo() {
        return this.applicationService.userAppSwitchInfo();
    }

    @ApiOperation(value="\u83b7\u53d6\u4e0b\u8f7d\u5bfc\u51fa\u914d\u7f6e\u5730\u5740")
    @GetMapping(value={"/application/center/app/config/url"})
    public Response getExportDownloadConfigUrl(@ApiParam(name="id", value="\u7cfb\u7edfid") @NotNull String id, HttpServletRequest request) {
        return this.applicationService.buildExportDownLoadConfigUrl(id, request);
    }

    @ApiOperation(value="|_ \u5e94\u7528\u914d\u7f6e\u5bfc\u51fa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5e94\u7528id", paramType="query", dataType="int")})
    @GetMapping(value={"/application/center/app/config/export"})
    public void export(@RequestParam(value="id") Long applicationId, HttpServletResponse response) {
        this.applicationService.exportApplicationConfig(response, applicationId);
    }

    @ApiOperation(value="|_ \u5e94\u7528\u914d\u7f6e\u5bfc\u5165")
    @PostMapping(value={"/application/center/app/config/import"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5e94\u7528id", paramType="form", dataType="int"), @ApiImplicitParam(name="file", value="\u5bfc\u5165\u7684 excel", paramType="form", dataType="file")})
    public Response importApplicationConfig(@RequestParam MultipartFile file, @RequestParam Long id) {
        return this.applicationService.importApplicationConfig(file, id);
    }

    @ApiOperation(value="\u5e94\u7528\u6570\u636e\u6e90\u914d\u7f6e\u662f\u5426\u4e3a\u65b0\u7248\u672c")
    @GetMapping(value={"/application/center/app/config/ds/isnew"})
    public Response<Boolean> appDsConfigIsNewVersion() {
        return this.applicationService.appDsConfigIsNewVersion();
    }
}

