/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.application;

import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.request.application.ApplicationNodeDashBoardQueryRequest;
import io.shulie.tro.web.app.request.application.ApplicationNodeQueryRequest;
import io.shulie.tro.web.app.response.application.ApplicationNodeDashBoardResponse;
import io.shulie.tro.web.app.response.application.ApplicationNodeResponse;
import io.shulie.tro.web.app.service.application.ApplicationNodeService;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/"})
@Api(tags={"ApplicationNodeController"}, value="\u5e94\u7528\u5b9e\u4f8b\uff08\u8282\u70b9\uff09\u7ba1\u7406")
public class ApplicationNodeController {
    @Autowired
    private ApplicationNodeService applicationNodeService;

    @ApiOperation(value="\u6839\u636e\u5e94\u7528id\u83b7\u53d6\u8282\u70b9\u4fe1\u606f")
    @GetMapping(value={"application/node/list"})
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.QUERY)
    public PagingList<ApplicationNodeResponse> getNodesByAppId(ApplicationNodeQueryRequest request) {
        return this.applicationNodeService.pageNodes(request);
    }

    @ApiOperation(value="\u6839\u636e\u5e94\u7528id\u83b7\u53d6\u8282\u70b9\u6c47\u603b\u4fe1\u606f")
    @GetMapping(value={"application/node/dashboard"})
    public ApplicationNodeDashBoardResponse getNodeDashBoardByAppId(ApplicationNodeDashBoardQueryRequest request) {
        return this.applicationNodeService.getApplicationNodeAmount(request);
    }

    @ApiOperation(value="\u6839\u636eagentId\u83b7\u53d6\u8282\u70b9\u4fe1\u606f")
    @GetMapping(value={"application/node/info"})
    public ApplicationNodeResponse getNodeByAgentId(@Validated @NotNull String agentId) {
        return this.applicationNodeService.getNodeByAgentId(agentId);
    }
}

