/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.application;

import io.shulie.tro.common.beans.annotation.ModuleDef;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.request.application.ShadowConsumerCreateRequest;
import io.shulie.tro.web.app.request.application.ShadowConsumerDeleteRequest;
import io.shulie.tro.web.app.request.application.ShadowConsumerQueryRequest;
import io.shulie.tro.web.app.request.application.ShadowConsumerUpdateRequest;
import io.shulie.tro.web.app.request.application.ShadowConsumersOperateRequest;
import io.shulie.tro.web.app.response.application.ShadowConsumerResponse;
import io.shulie.tro.web.app.service.ShadowConsumerService;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/consumers"})
@Api(tags={"ApplicationMqConsumerController"}, value="\u5f71\u5b50\u6d88\u8d39\u8005")
public class ApplicationMqConsumerController {
    @Autowired
    private ShadowConsumerService shadowConsumerService;

    @GetMapping(value={"/get"})
    @ApiOperation(value="\u67e5\u770b\u5f71\u5b50\u6d88\u8d39\u8005")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.QUERY)
    public ShadowConsumerResponse getMqConsumerById(@Validated @NotNull @RequestParam(value="id") Long id) {
        return this.shadowConsumerService.getMqConsumerById(id);
    }

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5f71\u5b50\u6d88\u8d39\u8005")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.QUERY)
    public PagingList<ShadowConsumerResponse> pageMqConsumers(@Validated ShadowConsumerQueryRequest request) {
        return this.shadowConsumerService.pageMqConsumers(request);
    }

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u521b\u5efa\u5f71\u5b50\u6d88\u8d39\u8005")
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u767d\u540d\u5355", logMsgKey="message.shadow_consumer.create")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.CREATE)
    public void createMqConsumers(@Validated @RequestBody ShadowConsumerCreateRequest request) {
        this.shadowConsumerService.createMqConsumers(request);
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u5f71\u5b50\u6d88\u8d39\u8005")
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u767d\u540d\u5355", logMsgKey="message.shadow_consumer.update")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.UPDATE)
    public void updateMqConsumers(@Validated @RequestBody ShadowConsumerUpdateRequest request) {
        this.shadowConsumerService.updateMqConsumers(request);
    }

    @DeleteMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u5f71\u5b50\u6d88\u8d39\u8005")
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u767d\u540d\u5355", logMsgKey="message.shadow_consumer.delete")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.DELETE)
    public void deleteMqConsumers(@Validated @RequestBody ShadowConsumerDeleteRequest request) {
        this.shadowConsumerService.deleteMqConsumers(request.getIds());
    }

    @PostMapping(value={"/operate"})
    @ApiOperation(value="\uff08\u52a0\u5165/\u53d6\u6d88\uff09\u5f71\u5b50\u6d88\u8d39\u8005")
    @ModuleDef(moduleName="\u5e94\u7528\u7ba1\u7406", subModuleName="\u767d\u540d\u5355", logMsgKey="message.shadow_consumer.add_remove")
    @AuthVerification(moduleCode="appManage", needAuth=ActionTypeEnum.ENABLE_DISABLE)
    public void operateMqConsumers(@Validated @RequestBody ShadowConsumersOperateRequest request) {
        this.shadowConsumerService.operateMqConsumers(request);
    }
}

