/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.application;

import com.google.common.collect.Lists;
import io.shulie.tro.web.amdb.api.ApplicationEntranceClient;
import io.shulie.tro.web.amdb.bean.common.EntranceTypeEnum;
import io.shulie.tro.web.app.request.application.ApplicationEntranceTopologyQueryRequest;
import io.shulie.tro.web.app.request.application.ApplicationEntrancesQueryRequest;
import io.shulie.tro.web.app.response.application.ApplicationEntranceTopologyResponse;
import io.shulie.tro.web.app.response.application.ApplicationEntrancesResponse;
import io.shulie.tro.web.app.service.LinkTopologyService;
import io.shulie.tro.web.common.util.ActivityUtil;
import io.shulie.tro.web.common.vo.WebOptionEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/application/entrances"})
@Api(tags={"\u5e94\u7528\u670d\u52a1\u7ba1\u7406"}, value="\u5e94\u7528\u670d\u52a1\u7ba1\u7406")
public class ApplicationEntranceController {
    private static final Logger log = LoggerFactory.getLogger(ApplicationEntranceController.class);
    @Autowired
    private ApplicationEntranceClient applicationEntranceClient;
    @Autowired
    private LinkTopologyService linkTopologyService;

    @GetMapping(value={"/types"})
    @ApiOperation(value="\u83b7\u5f97\u5165\u53e3\u670d\u52a1\u7c7b\u578b")
    public List<WebOptionEntity> getEntranceTypes() {
        EntranceTypeEnum[] values = EntranceTypeEnum.values();
        return Stream.of(values).filter(item -> item != EntranceTypeEnum.RABBITMQ).map(item -> {
            WebOptionEntity webOptionEntity = new WebOptionEntity();
            webOptionEntity.setLabel(item.name());
            webOptionEntity.setValue(item.name());
            return webOptionEntity;
        }).collect(Collectors.toList());
    }

    @GetMapping
    @ApiOperation(value="\u83b7\u5f97\u5165\u53e3\u670d\u52a1\u5217\u8868")
    public List<ApplicationEntrancesResponse> getApplicationEntrances(@Validated ApplicationEntrancesQueryRequest request) {
        List applicationEntrances = this.applicationEntranceClient.getApplicationEntrances(request.getApplicationName(), request.getType().getType());
        if (CollectionUtils.isEmpty((Collection)applicationEntrances)) {
            return Lists.newArrayList();
        }
        return applicationEntrances.stream().filter(item -> !item.getServiceName().startsWith("PT_")).map(item -> {
            ApplicationEntrancesResponse applicationEntrancesResponse = new ApplicationEntrancesResponse();
            applicationEntrancesResponse.setMethod(item.getMethodName());
            applicationEntrancesResponse.setRpcType(item.getRpcType());
            applicationEntrancesResponse.setExtend(item.getExtend());
            applicationEntrancesResponse.setServiceName(item.getServiceName());
            applicationEntrancesResponse.setLabel(ActivityUtil.serviceNameLabel((String)item.getServiceName(), (String)item.getMethodName()));
            applicationEntrancesResponse.setValue(ActivityUtil.createLinkId((String)item.getServiceName(), (String)item.getMethodName(), (String)item.getAppName(), (String)item.getRpcType(), (String)item.getExtend()));
            return applicationEntrancesResponse;
        }).collect(Collectors.toList());
    }

    @ApiOperation(value="\u83b7\u5f97\u5165\u53e3\u670d\u52a1\u62d3\u6251\u56fe")
    @GetMapping(value={"topology"})
    public ApplicationEntranceTopologyResponse getApplicationEntrancesTopology(@Validated ApplicationEntranceTopologyQueryRequest request) {
        return this.linkTopologyService.getApplicationEntrancesTopology(request);
    }

    @PostMapping(value={"/updateUnknownNode"})
    @ApiOperation(value="\u6807\u8bb0\u672a\u77e5\u8282\u70b9")
    public Boolean updateUnknownNodeToOuter(@Validated @RequestBody ApplicationEntranceTopologyQueryRequest request) {
        return this.applicationEntranceClient.updateUnknownNodeToOuter(request.getApplicationName(), request.getLinkId(), request.getServiceName(), request.getMethod(), request.getRpcType(), request.getExtend(), request.getNodeId());
    }
}

