/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.agent;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.pamirs.tro.common.ResponseError;
import com.pamirs.tro.common.ResponseOk;
import com.pamirs.tro.common.constant.TROErrorEnum;
import com.pamirs.tro.common.exception.TROModuleException;
import com.pamirs.tro.entity.domain.dto.NodeUploadDataDTO;
import com.pamirs.tro.entity.domain.query.ShadowJobConfigQuery;
import com.pamirs.tro.entity.domain.vo.ApplicationVo;
import com.pamirs.tro.entity.domain.vo.TUploadInterfaceVo;
import com.pamirs.tro.entity.domain.vo.TUploadNeedVo;
import io.shulie.tro.channel.bean.CommandPacket;
import io.shulie.tro.utils.json.JsonHelper;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.service.ApplicationService;
import io.shulie.tro.web.app.service.ConfCenterService;
import io.shulie.tro.web.app.service.UploadInterfaceService;
import io.shulie.tro.web.app.service.linkManage.ApplicationApiService;
import io.shulie.tro.web.app.service.perfomanceanaly.TraceManageService;
import io.shulie.tro.web.app.service.simplify.ShadowJobConfigService;
import io.shulie.tro.web.app.utils.Estimate;
import io.shulie.tro.web.app.utils.XmlUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Api(tags={"Agent\u5168\u5c40\u914d\u7f6e"})
public class AgentPushController {
    private static final Logger log = LoggerFactory.getLogger(AgentPushController.class);
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApplicationApiService apiService;
    @Autowired
    private ShadowJobConfigService shadowJobConfigService;
    @Autowired
    private UploadInterfaceService uploadInterfaceService;
    @Autowired
    private ConfCenterService confCenterService;
    @Autowired
    private TraceManageService traceManageService;

    @ApiOperation(value="agent\u6ce8\u518capi")
    @PostMapping(value={"/agent/api/register"})
    public Response registerApi(@RequestBody Map<String, List<String>> register) {
        try {
            return this.apiService.registerApi(register);
        }
        catch (Exception e) {
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    @PostMapping(value={"/application/agent/middle/status"})
    @ApiOperation(value="agent\u4e0a\u4f20\u4e2d\u95f4\u4ef6\u5217\u8868\u72b6\u6001")
    public Response uploadMiddlewareStatusAndRole(@RequestBody String requestJson, @RequestParam(value="appName") String appName) {
        try {
            Map requestMap = (Map)JSONObject.parseObject((String)requestJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            return this.applicationService.uploadMiddlewareStatus(requestMap, appName);
        }
        catch (Exception e) {
            return Response.fail((String)"middle status error", (Object[])new Object[0]);
        }
    }

    @PostMapping(value={"/application/center/app/info"})
    @ApiOperation(value="\u4e0a\u4f20\u5e94\u7528")
    public Response addApplication(@RequestBody ApplicationVo vo) {
        OperationLogContextHolder.operationType((String)"\u65b0\u589e");
        OperationLogContextHolder.addVars((String)"application", (String)vo.getApplicationName());
        return this.applicationService.addAgentRegisteApplication(vo);
    }

    @PostMapping(value={"/application/agent/access/status"})
    @ApiOperation(value="\u4e0a\u4f20\u5e94\u7528\u72b6\u6001")
    public Response uploadAccessStatus(@RequestBody NodeUploadDataDTO param) {
        return this.applicationService.uploadAccessStatus(param);
    }

    @PostMapping(value={"/confcenter/interface/add/interfaceData"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> judgeNeedUpload(@RequestBody TUploadInterfaceVo TUploadInterfaceVo2) {
        try {
            return ResponseOk.create((Object)this.uploadInterfaceService.saveUploadInterfaceData(TUploadInterfaceVo2));
        }
        catch (TROModuleException e) {
            log.error("AgentController.judgeNeedUpload \u67e5\u8be2\u662f\u5426\u9700\u8981\u4e0a\u4f20\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            log.error("AgentController.judgeNeedUpload \u67e5\u8be2\u662f\u5426\u9700\u8981\u4e0a\u4f20\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_INTERFACE_UPLOAD_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_INTERFACE_NEED_UPLOAD_EXCEPTION.getErrorMessage());
        }
    }

    @PostMapping(value={"/confcenter/interface/query/needUpload"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> judgeNeedUpload(@RequestBody TUploadNeedVo uploadNeedVo) {
        try {
            return ResponseOk.create((Object)this.uploadInterfaceService.executeNeedUploadInterface(uploadNeedVo));
        }
        catch (TROModuleException e) {
            log.error("AgentController.judgeNeedUpload \u67e5\u8be2\u662f\u5426\u9700\u8981\u4e0a\u4f20\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            log.error("AgentController.judgeNeedUpload \u67e5\u8be2\u662f\u5426\u9700\u8981\u4e0a\u4f20\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_INTERFACE_NEED_UPLOAD_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_INTERFACE_NEED_UPLOAD_EXCEPTION.getErrorMessage());
        }
    }

    @ApiOperation(value="\u5f71\u5b50JOB\u914d\u7f6e\u4fee\u6539")
    @RequestMapping(value={"/shadow/job/update"}, method={RequestMethod.PUT, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public Response update(@RequestBody ShadowJobConfigQuery query) {
        try {
            Estimate.notBlank((Object)query.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            Map xmlMap = XmlUtil.readStringXml((String)query.getConfigCode());
            String className = (String)xmlMap.get("className");
            OperationLogContextHolder.operationType((String)"\u7f16\u8f91");
            OperationLogContextHolder.addVars((String)"task", (String)className);
            return this.shadowJobConfigService.update(query);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.fail((String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    @GetMapping(value={"/confcenter/applicationmnt/update/applicationAgent"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> appAgentVersionUpdate(@RequestParam(value="appName") String appName, @RequestParam(value="agentVersion") String agentVersion, @RequestParam(value="pradarVersion") String pradarVersion) {
        try {
            if (StringUtils.isBlank((CharSequence)agentVersion) || StringUtils.isBlank((CharSequence)pradarVersion) || "null".equalsIgnoreCase(agentVersion) || "null".equalsIgnoreCase(pradarVersion)) {
                return ResponseError.create((int)1010100102, (String)"\u66f4\u65b0\u5e94\u7528\u7248\u672c\u5f02\u5e38,\u53c2\u6570\u4e3a\u7a7a");
            }
            this.confCenterService.updateAppAgentVersion(appName, agentVersion, pradarVersion);
            return ResponseOk.create((Object)"succeed");
        }
        catch (TROModuleException e) {
            log.error("AgentController.appAgentVersionUpdate \u66f4\u65b0\u5e94\u7528\u7248\u672c\u5f02\u5e38 {}", (Throwable)e);
            return ResponseError.create((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        catch (Exception e) {
            log.error("AgentController.appAgentVersionUpdate \u66f4\u65b0\u5e94\u7528\u7248\u672c\u5f02\u5e38 {}", (Throwable)e);
            return ResponseError.create((int)1010100102, (String)"\u66f4\u65b0\u5e94\u7528\u7248\u672c\u5f02\u5e38");
        }
    }

    @PostMapping(value={"/traceManage/uploadTraceInfo"})
    @ApiOperation(value="agent\u4e0a\u4f20trace\u4fe1\u606f")
    public void uploadTraceInfo(@RequestBody CommandPacket commandPacket) {
        log.info("agent\u4e0a\u4f20trace\u4fe1\u606f\uff0c\u5165\u53c2\u4e3a:{}", (Object)JsonHelper.bean2Json((Object)commandPacket));
        this.traceManageService.uploadTraceInfo(commandPacket);
    }

    @Deprecated
    @RequestMapping(value={"/confcenter/wbmnt/query/bwlistmetric"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<Object> queryBWMetricList(@RequestParam(name="appName", required=false) String appName) {
        try {
            return ResponseEntity.ok(null);
        }
        catch (Exception e) {
            log.error("AgentController.queryBWMetricList  \u67e5\u8be2Metric\u9ed1\u767d\u540d\u5355\u5217\u8868\u5f02\u5e38{}", (Throwable)e);
            return ResponseError.create((int)TROErrorEnum.CONFCENTER_QUERY_BWLIST_EXCEPTION.getErrorCode(), (String)TROErrorEnum.CONFCENTER_QUERY_BWLIST_EXCEPTION.getErrorMessage());
        }
    }
}

