/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.agent;

import com.pamirs.tro.entity.domain.dto.ApplicationSwitchStatusDTO;
import com.pamirs.tro.entity.domain.dto.config.WhiteListSwitchDTO;
import com.pamirs.tro.entity.domain.entity.simplify.TShadowJobConfig;
import com.pamirs.tro.entity.domain.vo.dsmanage.DsAgentVO;
import com.pamirs.tro.entity.domain.vo.dsmanage.DsServerVO;
import com.pamirs.tro.entity.domain.vo.guardmanage.LinkGuardVo;
import io.shulie.tro.web.app.agent.vo.ShadowConsumerVO;
import io.shulie.tro.web.app.cache.AgentConfigCacheManager;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.response.application.ShadowServerConfigurationResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Api(tags={"Agent\u5e94\u7528\u914d\u7f6e"})
public class AgentPullController {
    private static final Logger log = LoggerFactory.getLogger(AgentPullController.class);
    @Autowired
    private AgentConfigCacheManager agentConfigCacheManager;

    @ApiOperation(value="\u62c9\u53d6\u5f71\u5b50\u5e93\u8868\u914d\u7f6e")
    @GetMapping(value={"/link/ds/configs/pull"})
    public Response<List<DsAgentVO>> getConfigs(@RequestParam(value="appName") String appName) {
        return Response.success((Object)this.agentConfigCacheManager.getShadowDb(appName));
    }

    @ApiOperation(value="\u62c9\u53d6\u5f71\u5b50\u6d88\u8d39\u8005\u914d\u7f6e")
    @GetMapping(value={"/agent/configs/shadow/consumer"})
    public Response<List<ShadowConsumerVO>> getShadowConsumer(@RequestParam(value="appName") String appName) {
        return Response.success((Object)this.agentConfigCacheManager.getShadowConsumer(appName));
    }

    @ApiOperation(value="\u62c9\u53d6Es\u5f71\u5b50\u7d22\u5f15\u914d\u7f6e")
    @GetMapping(value={"/link/es/server/configs/pull"})
    public Response<List<DsServerVO>> getShadowEsServer(@RequestParam(value="appName") String appName) {
        return Response.success((Object)this.agentConfigCacheManager.getShadowEsServers(appName));
    }

    @ApiOperation(value="\u62c9\u53d6kafka\u5f71\u5b50\u7d22\u5f15\u914d\u7f6e")
    @GetMapping(value={"/link/kafka/cluster/configs/pull"})
    public Response<List<DsServerVO>> getShadowKafkaCluster(@RequestParam(value="appName") String appName) {
        return Response.success((Object)this.agentConfigCacheManager.getShadowKafkaCluster(appName));
    }

    @ApiOperation(value="\u62c9\u53d6Hbase\u5f71\u5b50\u914d\u7f6e")
    @GetMapping(value={"/link/hbase/server/configs/pull"})
    public Response<List<DsServerVO>> getShadowHbaseServer(@RequestParam(value="appName") String appName) {
        return Response.success((Object)this.agentConfigCacheManager.getShadowHbase(appName));
    }

    @ApiOperation(value="\u62c9\u53d6Job\u914d\u7f6e")
    @GetMapping(value={"/shadow/job/queryByAppName"}, produces={"application/json;charset=UTF-8"})
    public Response<List<TShadowJobConfig>> queryByAppName(@RequestParam(value="appName", defaultValue="") String appName) {
        return Response.success((Object)this.agentConfigCacheManager.getShadowJobs(appName));
    }

    @ApiOperation(value="\u62c9\u53d6\u5f71\u5b50\u5e93server\u914d\u7f6e")
    @GetMapping(value={"/link/ds/server/configs/pull"})
    public Response<List<ShadowServerConfigurationResponse>> getShadowServerConfigs(@RequestParam(value="appName") String appName) {
        return Response.success((Object)this.agentConfigCacheManager.getShadowServer(appName));
    }

    @GetMapping(value={"/link/guard/guardmanage"})
    @ApiOperation(value="\u6321\u677f\u5217\u8868\u67e5\u8be2\u63a5\u53e3")
    public Response<List<LinkGuardVo>> getGuardList(@ApiParam(name="applicationName", value="\u7cfb\u7edf\u540d\u5b57") @RequestParam(value="applicationName") String applicationName) {
        return Response.success((Object)this.agentConfigCacheManager.getGuards(applicationName));
    }

    @GetMapping(value={"/global/switch/whitelist"})
    @ApiOperation(value="\u67e5\u770b\u5168\u5c40\u767d\u540d\u5355\u5f00\u5173")
    public Response<WhiteListSwitchDTO> getWhiteListSwitch() {
        WhiteListSwitchDTO switchDTO = new WhiteListSwitchDTO();
        switchDTO.setConfigCode("WHITE_LIST_SWITCH");
        switchDTO.setSwitchFlagFix(Boolean.valueOf(this.agentConfigCacheManager.getAllowListSwitch()));
        return Response.success((Object)switchDTO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u538b\u6d4b\u5f00\u5173\u72b6\u6001\u63a5\u53e3")
    @GetMapping(value={"/application/center/app/switch/agent"})
    public Response<ApplicationSwitchStatusDTO> AgentAppSwitchInfo() {
        return Response.success((Object)this.agentConfigCacheManager.getPressureSwitch());
    }
}

