/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller.activity;

import io.shulie.tro.common.beans.annotation.ModuleDef;
import io.shulie.tro.common.beans.page.PagingList;
import io.shulie.tro.web.amdb.bean.common.EntranceTypeEnum;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.request.activity.ActivityCreateRequest;
import io.shulie.tro.web.app.request.activity.ActivityQueryRequest;
import io.shulie.tro.web.app.request.activity.ActivityUpdateRequest;
import io.shulie.tro.web.app.response.activity.ActivityListResponse;
import io.shulie.tro.web.app.response.activity.ActivityResponse;
import io.shulie.tro.web.app.service.ActivityService;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.shulie.tro.web.common.util.business.EntranceNameUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/activities"})
@Api(tags={"\u4e1a\u52a1\u6d3b\u52a8\u7ba1\u7406"}, value="\u4e1a\u52a1\u6d3b\u52a8\u7ba1\u7406")
@RestController
public class ActivityController {
    @Autowired
    private ActivityService activityService;

    @ApiOperation(value="\u6dfb\u52a0\u4e1a\u52a1\u6d3b\u52a8")
    @PostMapping(value={"/create"})
    @ModuleDef(moduleName="\u94fe\u8def\u68b3\u7406", subModuleName="\u4e1a\u52a1\u6d3b\u52a8", logMsgKey="message.business_activity.create")
    @AuthVerification(moduleCode="businessActivity", needAuth=ActionTypeEnum.CREATE)
    public void createActivity(@Validated @RequestBody ActivityCreateRequest request) {
        EntranceNameUtils.checkEntranceName((String)request.getEntranceName());
        EntranceNameUtils.EntranceNameVO entranceNameVO = EntranceNameUtils.getEntranceNameVO((String)request.getEntranceName(), (String)request.getType().getType());
        request.setServiceName(entranceNameVO.getServiceName());
        request.setMethod(entranceNameVO.getMethod());
        request.setRpcType(EntranceNameUtils.getRpcType((String)request.getType().getType()));
        OperationLogContextHolder.operationType((String)"\u65b0\u589e");
        OperationLogContextHolder.addVars((String)"businessActivity", (String)request.getActivityName());
        OperationLogContextHolder.addVars((String)"entranceType", (String)request.getType().name());
        OperationLogContextHolder.addVars((String)"applicationName", (String)request.getApplicationName());
        OperationLogContextHolder.addVars((String)"serviceName", (String)request.getServiceName());
        this.activityService.createActivity(request);
    }

    private String getRpcType(EntranceTypeEnum type) {
        return "1";
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u4e1a\u52a1\u6d3b\u52a8")
    @ModuleDef(moduleName="\u94fe\u8def\u68b3\u7406", subModuleName="\u4e1a\u52a1\u6d3b\u52a8", logMsgKey="message.business_activity.update")
    @AuthVerification(moduleCode="businessActivity", needAuth=ActionTypeEnum.UPDATE)
    public void updateActivity(@Validated @RequestBody ActivityUpdateRequest request) {
        EntranceNameUtils.checkEntranceName((String)request.getEntranceName());
        EntranceNameUtils.EntranceNameVO entranceNameVO = EntranceNameUtils.getEntranceNameVO((String)request.getEntranceName(), (String)request.getType().getType());
        request.setServiceName(entranceNameVO.getServiceName());
        request.setMethod(entranceNameVO.getMethod());
        request.setRpcType(EntranceNameUtils.getRpcType((String)request.getType().getType()));
        OperationLogContextHolder.operationType((String)"\u7f16\u8f91");
        OperationLogContextHolder.addVars((String)"businessActivity", (String)request.getActivityName());
        OperationLogContextHolder.addVars((String)"entranceType", (String)request.getType().name());
        OperationLogContextHolder.addVars((String)"applicationName", (String)request.getApplicationName());
        OperationLogContextHolder.addVars((String)"serviceName", (String)request.getServiceName());
        this.activityService.updateActivity(request);
    }

    @ApiOperation(value="\u5220\u9664\u4e1a\u52a1\u6d3b\u52a8")
    @DeleteMapping(value={"/delete"})
    @ModuleDef(moduleName="\u94fe\u8def\u68b3\u7406", subModuleName="\u4e1a\u52a1\u6d3b\u52a8", logMsgKey="message.business_activity.delete")
    @AuthVerification(moduleCode="businessActivity", needAuth=ActionTypeEnum.DELETE)
    public void deleteActivity(@Valid @NotNull @RequestParam Long activityId) {
        this.activityService.deleteActivity(activityId);
    }

    @ApiOperation(value="\u4e1a\u52a1\u6d3b\u52a8\u5217\u8868")
    @GetMapping
    @AuthVerification(moduleCode="businessActivity", needAuth=ActionTypeEnum.QUERY)
    public PagingList<ActivityListResponse> pageActivities(@Valid ActivityQueryRequest request) {
        return this.activityService.pageActivities(request);
    }

    @ApiOperation(value="\u83b7\u5f97\u5355\u4e2a\u4e1a\u52a1\u6d3b\u52a8\u7684\u8be6\u60c5")
    @GetMapping(value={"/activity"})
    @AuthVerification(moduleCode="businessActivity", needAuth=ActionTypeEnum.QUERY)
    public ActivityResponse getActivityById(@Valid @RequestParam Long id) {
        return this.activityService.getActivityById(id);
    }
}

