/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.controller;

import com.pamirs.tro.entity.domain.dto.config.WhiteListSwitchDTO;
import io.shulie.tro.common.beans.annotation.ModuleDef;
import io.shulie.tro.web.app.annotation.AuthVerification;
import io.shulie.tro.web.app.cache.AgentConfigCacheManager;
import io.shulie.tro.web.app.common.Response;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.context.OperationLogContextHolder;
import io.shulie.tro.web.app.service.config.ConfigService;
import io.shulie.tro.web.auth.api.enums.ActionTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/"})
@Api(tags={"\u63a7\u5236\u53f0\u767d\u540d\u5355\u914d\u7f6e"})
public class GlobalController {
    private static final Logger log = LoggerFactory.getLogger(GlobalController.class);
    @Autowired
    private ConfigService configService;
    @Autowired
    private AgentConfigCacheManager agentConfigCacheManager;

    @GetMapping(value={"/console/switch/whitelist"})
    @ApiOperation(value="\u67e5\u770b\u5168\u5c40\u767d\u540d\u5355\u5f00\u5173")
    public Response<WhiteListSwitchDTO> getWhiteListSwitch() {
        WhiteListSwitchDTO switchDTO = new WhiteListSwitchDTO();
        switchDTO.setConfigCode("WHITE_LIST_SWITCH");
        String key = RestContext.getUser().getCustomerKey();
        switchDTO.setSwitchFlagFix(Boolean.valueOf(this.configService.getAllowListSwitch(key)));
        return Response.success((Object)switchDTO);
    }

    @PutMapping(value={"/console/switch/whitelist/open"})
    @ApiOperation(value="\u6253\u5f00\u5168\u5c40\u767d\u540d\u5355\u5f00\u5173")
    @ModuleDef(moduleName="\u914d\u7f6e\u4e2d\u5fc3", subModuleName="\u767d\u540d\u5355\u5f00\u5173", logMsgKey="message.whitelist_switch.action")
    @AuthVerification(moduleCode="configCenter_whitelistSwitch", needAuth=ActionTypeEnum.ENABLE_DISABLE)
    public Response openWhiteListSwitch() {
        OperationLogContextHolder.operationType((String)"\u5f00\u542f");
        OperationLogContextHolder.addVars((String)"action", (String)"\u5f00\u542f");
        this.configService.updateAllowListSwitch(RestContext.getUser().getKey(), Boolean.valueOf(true));
        this.agentConfigCacheManager.evictAllowListSwitch();
        return Response.success();
    }

    @PutMapping(value={"/console/switch/whitelist/close"})
    @ApiOperation(value="\u5173\u95ed\u5168\u5c40\u767d\u540d\u5355\u5f00\u5173")
    @ModuleDef(moduleName="\u914d\u7f6e\u4e2d\u5fc3", subModuleName="\u767d\u540d\u5355\u5f00\u5173", logMsgKey="message.whitelist_switch.action")
    @AuthVerification(moduleCode="configCenter_whitelistSwitch", needAuth=ActionTypeEnum.ENABLE_DISABLE)
    public Response closeWhiteListSwitch() {
        OperationLogContextHolder.operationType((String)"\u5173\u95ed");
        OperationLogContextHolder.addVars((String)"action", (String)"\u5173\u95ed");
        this.configService.updateAllowListSwitch(RestContext.getUser().getKey(), Boolean.valueOf(false));
        this.agentConfigCacheManager.evictAllowListSwitch();
        return Response.success();
    }
}

