/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.context;

import io.shulie.tro.web.app.context.OperationLogContext;

public final class OperationLogContextHolder {
    private static final InheritableThreadLocal<OperationLogContext> HOLDER = new InheritableThreadLocal();

    private OperationLogContextHolder() {
    }

    public static void operationType(String type) {
        OperationLogContext operationLogContext = (OperationLogContext)HOLDER.get();
        if (operationLogContext == null) {
            operationLogContext = new OperationLogContext();
            HOLDER.set(operationLogContext);
        }
        operationLogContext.setOperationType(type);
    }

    public static void addVars(String key, String value) {
        OperationLogContext operationLogContext = (OperationLogContext)HOLDER.get();
        if (operationLogContext == null) {
            operationLogContext = new OperationLogContext();
            HOLDER.set(operationLogContext);
        }
        operationLogContext.getVars().put(key, value);
    }

    public static void ignoreLog() {
        OperationLogContext operationLogContext = (OperationLogContext)HOLDER.get();
        if (operationLogContext == null) {
            operationLogContext = new OperationLogContext();
            HOLDER.set(operationLogContext);
        }
        operationLogContext.setIgnore(Boolean.valueOf(true));
    }

    public static OperationLogContext get() {
        return (OperationLogContext)HOLDER.get();
    }

    public static void reset() {
        HOLDER.remove();
        HOLDER.set(new OperationLogContext());
    }

    public static void start() {
        OperationLogContext operationLogContext = (OperationLogContext)HOLDER.get();
        operationLogContext.setStartTime(Long.valueOf(System.currentTimeMillis()));
    }

    public static void end(boolean isSuccess) {
        OperationLogContext operationLogContext = (OperationLogContext)HOLDER.get();
        Long endTime = System.currentTimeMillis();
        operationLogContext.setEndTime(endTime);
        operationLogContext.setSuccess(Boolean.valueOf(isSuccess));
        operationLogContext.setCostTime(Long.valueOf(endTime - operationLogContext.getStartTime()));
    }
}

