/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.constant;

import java.io.File;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FastDebugLogPathFactory {
    @Value(value="${fast.debug.upload.log.path:/data/fastdebug/log/}")
    String logPathPre;

    public String appLogPath(Long customerId, String appName, String agentId, String traceId, String filePath, String fileName) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.logPathPre);
        builder.append("applog");
        builder.append(File.separator);
        builder.append(customerId);
        builder.append(File.separator);
        builder.append(appName);
        builder.append(File.separator);
        builder.append(agentId);
        builder.append(File.separator);
        builder.append(traceId);
        builder.append(File.separator);
        builder.append(filePath);
        builder.append(File.separator);
        builder.append(fileName);
        return builder.toString();
    }

    public String agentLogPath(Long customerId, String appName, String agentId, String traceId, String fileName) {
        return this.logPathPre + "agentlog" + File.separator + customerId + File.separator + appName + File.separator + agentId + File.separator + traceId + File.separator + fileName;
    }

    public String getAgentLogNamesStatus(Long customerId, String appName, String agentId, String traceId) {
        return customerId + "-" + appName + "-" + agentId + "-" + traceId;
    }

    public String agentLogDir(Long customerId, String appName, String agentId, String traceId) {
        return this.logPathPre + "agentlog" + File.separator + customerId + File.separator + appName + File.separator + agentId + File.separator + traceId + File.separator;
    }

    public String agentLogPullStatusKey(Long customerId, String appName, String agentId, String traceId, String fileName) {
        return "agent:log:pull:status:" + customerId + "-" + appName + "-" + agentId + "-" + traceId + "-" + fileName;
    }

    public String appLogPullStatusKey(Long customerId, String appName, String agentId, String traceId, String filePath, String fileName) {
        return "app:log:pull:status:" + customerId + "-" + appName + "-" + agentId + "-" + traceId + "-" + filePath + "-" + fileName;
    }

    public String agentStackUploadTimesKey(String traceId) {
        return "agent-stack-upload-times-" + traceId;
    }

    public String appLogUploadLastLineKey(Long customerId, String agentId, String traceId, String filePath) {
        return customerId + "-" + agentId + "-" + traceId + "-" + filePath;
    }

    public String appLogIsExistKey(Long customerId, String agentId, String filePath) {
        return customerId + "-" + agentId + "-" + filePath;
    }

    public String agentLogUploadLastLineKey(Long customerId, String agentId, String traceId, String fileName) {
        return customerId + "-" + agentId + "-" + traceId + "-" + fileName;
    }

    public String getLogPathPre() {
        return this.logPathPre;
    }

    public String agentNextPageHasSendedKey(String appName, String agentId, String traceId, String fileName, Integer lineStart) {
        StringBuilder builder = new StringBuilder();
        builder.append(appName);
        builder.append("-");
        builder.append(agentId);
        builder.append("-");
        builder.append(traceId);
        builder.append("-");
        builder.append(fileName);
        builder.append("-");
        builder.append(lineStart);
        return builder.toString();
    }

    public String appNextPageHasSendedKey(String appName, String agentId, String traceId, String filePath, Integer lineStart) {
        StringBuilder builder = new StringBuilder();
        builder.append(appName);
        builder.append("-");
        builder.append(agentId);
        builder.append("-");
        builder.append(traceId);
        builder.append("-");
        builder.append(filePath);
        builder.append("-");
        builder.append(lineStart);
        return builder.toString();
    }
}

