/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.conf.intercepter;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.pamirs.tro.entity.domain.entity.user.User;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.service.auth.TroAuthService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class MenuAuthInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MenuAuthInterceptor.class);
    @Autowired
    TroAuthService troAuthService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        User user = RestContext.getUser();
        if (user == null) {
            return StringUtils.isNotBlank((CharSequence)RestContext.getTenantUserKey());
        }
        if (user.getUserType() == 0) {
            return true;
        }
        String url = request.getRequestURI();
        boolean hasPermission = this.troAuthService.hasPermissionUrl(user, url);
        if (!hasPermission) {
            String msg = "\u6743\u9650\u4e0d\u8db3\uff0c\u7528\u6237\u65e0\u83dc\u5355\u6743\u9650\uff01";
            log.error("\u7528\u6237\u65e0\u83dc\u5355\u6743\u9650:{},{}", (Object)user.getName(), (Object)url);
            this.println(response, msg);
        }
        return hasPermission;
    }

    private void println(HttpServletResponse response, String message) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        try {
            PrintWriter printWriter = response.getWriter();
            HashMap map = Maps.newHashMap();
            map.put("msg", message);
            map.put("status", HttpStatus.UNAUTHORIZED.value());
            String s = JSON.toJSONString((Object)map);
            printWriter.write(s);
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

