/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.conf.intercepter;

import com.pamirs.tro.entity.domain.entity.user.User;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.app.service.auth.TroAuthService;
import io.shulie.tro.web.data.mapper.mysql.TroUserMapper;
import io.shulie.tro.web.data.model.mysql.TroUserEntity;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class LoginInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoginInterceptor.class);
    @Autowired
    private TroAuthService troAuthService;
    @Resource
    private TroUserMapper troUserMapper;

    private String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        User user = this.setUserLoginMessage(request, response);
        if (user != null) {
            return true;
        }
        log.debug("\u7528\u6237\u672a\u767b\u5f55");
        log.debug("\u5ba2\u6237\u7aefIP\uff1a[{}]", (Object)this.getIpAddress(request));
        log.debug("\u8bf7\u6c42\u8def\u5f84\uff1a[{}]", (Object)request.getRequestURI());
        this.troAuthService.checkFail(response);
        return false;
    }

    private User setUserLoginMessage(HttpServletRequest request, HttpServletResponse response) {
        try {
            User user = this.troAuthService.check(request, response);
            if (user != null) {
                return this.getAdminUser(user);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private User getAdminUser(User user) {
        TroUserEntity admin = (TroUserEntity)this.troUserMapper.selectById((Serializable)user.getCustomerId());
        if (admin != null) {
            user.setCustomerId(admin.getId());
            user.setCustomerKey(admin.getKey());
        } else {
            log.error("\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f");
        }
        RestContext.clear();
        RestContext.setUser((User)user);
        return user;
    }
}

