/*
 * Decompiled with CFR 0.152.
 */
package io.shulie.tro.web.app.conf.intercepter;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.pamirs.tro.entity.domain.entity.user.User;
import io.shulie.tro.web.app.cache.webimpl.AllUserCache;
import io.shulie.tro.web.app.common.RestContext;
import io.shulie.tro.web.common.context.CurrentUser;
import io.shulie.tro.web.data.result.user.UserCacheResult;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class AgentInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AgentInterceptor.class);
    public static final String KEY_USER_MAP_REDIS_KEY = "tro:web:key2user";
    private static final String APP_KEY_HEADER_KEY = "UserAppKey";
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private AllUserCache allUserCache;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        RestContext.clear();
        String userAppKey = request.getHeader(APP_KEY_HEADER_KEY);
        if (StringUtils.isBlank((CharSequence)userAppKey)) {
            HashMap map = Maps.newHashMap();
            map.put("msg", "Agent\u672a\u643a\u5e26userAppKey\uff0c\u7981\u6b62\u8bbf\u95ee");
            map.put("status", HttpStatus.FORBIDDEN.value());
            response.setStatus(HttpStatus.FORBIDDEN.value());
            this.assembleResponse(response, (Map)map);
            log.error("Agent\u672a\u643a\u5e26userAppKey\uff0c\u7981\u6b62\u8bbf\u95ee");
            return false;
        }
        CurrentUser currentUser = (CurrentUser)this.redisTemplate.opsForHash().get((Object)KEY_USER_MAP_REDIS_KEY, (Object)userAppKey);
        if (currentUser == null) {
            UserCacheResult cachedUserByKey = this.allUserCache.getCachedUserByKey(userAppKey);
            if (cachedUserByKey == null) {
                HashMap map = Maps.newHashMap();
                map.put("msg", "Agent\u63d0\u4f9b\u7684userAppKey\u5728\u6570\u636e\u5e93\u4e2d\u672a\u627e\u5230\u8bb0\u5f55");
                map.put("status", HttpStatus.UNAUTHORIZED.value());
                response.setStatus(HttpStatus.UNAUTHORIZED.value());
                this.assembleResponse(response, (Map)map);
                log.error("Agent\u63d0\u4f9b\u7684userAppKey\u5728\u6570\u636e\u5e93\u4e2d\u672a\u627e\u5230\u8bb0\u5f55\uff0cUserAppKey:{}", (Object)userAppKey);
                return false;
            }
            currentUser = new CurrentUser();
            currentUser.setCustomerId(cachedUserByKey.getCustomerId());
            currentUser.setCustomerKey(cachedUserByKey.getCustomerKey());
            currentUser.setId(cachedUserByKey.getId());
            currentUser.setUserType(cachedUserByKey.getUserType());
            this.redisTemplate.opsForHash().put((Object)KEY_USER_MAP_REDIS_KEY, (Object)userAppKey, (Object)currentUser);
            this.redisTemplate.expire((Object)KEY_USER_MAP_REDIS_KEY, 1L, TimeUnit.HOURS);
        }
        User user = new User();
        BeanUtils.copyProperties((Object)currentUser, (Object)user);
        RestContext.setUser((User)user);
        RestContext.setTenantUserKey((String)userAppKey);
        return true;
    }

    public void assembleResponse(HttpServletResponse response, Map<String, Object> map) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        try {
            PrintWriter printWriter = response.getWriter();
            String s = JSON.toJSONString(map);
            printWriter.write(s);
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException e) {
            log.error("error:", (Throwable)e);
        }
    }
}

